package com.moengage.locationlibrary;

import android.content.Intent;

/**
 * @author Umang Chamaria
 */

public class MoELocationCallbacks {

  private MoELocationCallbacks(){

  }

  private static MoELocationCallbacks _INSTANCE = null;

  private OnGeoFenceHit onGeoFenceHit;

  public static MoELocationCallbacks getInstance(){
    if (_INSTANCE == null){
      _INSTANCE = new MoELocationCallbacks();
    }
    return _INSTANCE;
  }

  /**
   * Sets a listener for geo-fence hit. Ideally should be present in the Application class of the
   * app as hit can happen in background.
   * @param geoFenceHitListener instance of {@link MoELocationCallbacks.OnGeoFenceHit}
   */
  public void setGeoFenceHitListener(OnGeoFenceHit geoFenceHitListener){
    onGeoFenceHit = geoFenceHitListener;
  }

  boolean onGeoFenceHit(Intent geoFenceHit){
    return onGeoFenceHit != null && onGeoFenceHit.geoHit(geoFenceHit);
  }

  /**
   * Callback for geo-fence hit
   */
  public interface OnGeoFenceHit{
    /**
     * Callback triggered whenever geo-fence hit
     * @param geoFenceHit Intent received from google's location services
     * @return true if the app wants to consume the hit and don't want MoEngage SDK to take any
     * action on this hit, else false
     */
    boolean geoHit(Intent geoFenceHit);
  }
}
