package com.moengage.locationlibrary;

/**
 * @author Umang Chamaria
 */
interface LocationConstants {

  /**
   * API Response attribute stating the collection of fences
   */
  String RESPONSE_ATTR_FENCES_INFO = "fencesInfo";
  /**
   * API response attribute for the geo ids
   */
  String RESPONSE_ATTR_GEOID = "geoId";
  /**
   * API response attribute stating the distance
   */
  String RESPONSE_ATTR_DISTANCE = "distance";
  /**
   * API response attribute stating the transition type
   */
  String RESPONSE_ATTR_TRANSITION_TYPE = "transitionType";
  /**
   * API response attribute setting the loitering delay for DWELL
   */
  String RESPONSE_ATTR_FENCE_LDELAY = "ldelay";
  /**
   * API response attribute setting the notification responsiveness
   */
  String RESPONSE_ATTR_FENCE_RESPONSIVENESS = "responsiveness_time";
  /**
   * API response attribute which denotes the expiry date for the geo fence
   */
  String RESPONSE_ATTR_FENCE_EXPIRY = "expiry";
  /**
   * Campaign id associated with the geo-fence
   */
  String RESPONSE_ATTR_FENCE_CAMPAIGN_ID = "cid";
  /**
   * Geo fence Transition type is exit
   */
  String TRANSITION_TYPE_EXIT = "exit";
  /**
   * Geo fence Transition type is enter
   */
  String TRANSITION_TYPE_ENTER = "enter";
  /**
   * Geo fence Transition type is enter
   */
  String TRANSITION_TYPE_DWELL = "dwell";
  /**
   * API endpoint for geo fence hit
   */
  String API_ENDPOINT_GEOFENCEHIT = "/v1/geoFenceHit";
  /**
   * <b>API Param</b> key for the geo id for which a geo fencing hit is being
   * logged
   */
  /**
   * API endpoint for geo fences
   */
  String API_ENDPOINT_GEOFENCES = "/v1/geoFences";

  String PARAM_GEOIDS = "geoIds";
  /**
   * The Url associated with logging geo fence hits
   */
  String API_GEO_FENCE = "https://apiv2.moengage.com";
  /**
   * <b>API Param</b>. stating latitude
   */
  String PARAM_LAT = "lat";
  /**
   * <b>API Param</b>. stating longitude
   */
  String PARAM_LNG = "lng";
  /**
   * API PARAM for geo-fence hit
   */
  String CURRENT_LATITUDE = "curr_lat";
  /**
   * API PARAM for geo-fence hit
   */
  String CURRENT_LONGITUDE = "curr_long";

  String EVENT_ATTRIBUTE_GEO_ID = "geo_id";

  String EVENT_ATTRIBUTE_CAMPAIGN_ID = "campaign_id";

  String EVENT_ATTRIBUTE_TRANSITION_TYPE = "transition_type";

  String EVENT_ATTRIBUTE_TRIGGER_LOCATION = "trigger_location";

  String GEO_ID_SEPARATOR = ":";
}
