/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.widgets;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.moengage.core.Logger;
import com.moengage.core.executor.ITask;
import com.moengage.core.executor.OnTaskCompleteListener;
import com.moengage.core.executor.TaskManager;
import com.moengage.core.executor.TaskProcessor;
import com.moengage.core.executor.TaskResult;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.model.NudgeViewResult;
import com.moengage.inapp.tasks.BuildNudgeViewTask;
import java.lang.ref.WeakReference;
import java.util.Observable;
import java.util.Observer;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class NudgeView
extends LinearLayout
implements OnTaskCompleteListener {
    private static final String TAG = "InApp_4.2.03_NudgeView";
    private Context context;
    private Activity nudgeView;
    private String requestId;
    private InAppCacheObserver inAppCacheObserver = new InAppCacheObserver();
    private WeakReference<OnTaskCompleteListener> completeListener;
    boolean alreadyObserving = false;
    private final Object queryLock = new Object();
    private AtomicBoolean wip = new AtomicBoolean(false);

    public NudgeView(Context contextList) {
        this(contextList, null);
    }

    public NudgeView(Context contextList, AttributeSet attrs) {
        super(contextList, attrs);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.setVisibility(4);
        this.setOrientation(1);
        this.context = contextList;
        this.requestId = UUID.randomUUID().toString();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public void initialiseNudgeView(Activity activity) {
        Logger.v((String)"NudgeView: inside initialiseNudgeView()");
        this.nudgeView = activity;
        this.queryForNudge();
    }

    public void onTaskComplete(String tag, TaskResult taskResult) {
        if ("BUILD_NUDGE_VIEW_TASK".equals(tag)) {
            Logger.v((String)"InApp_4.2.03_NudgeView onTaskComplete() : Building nudge view completed.");
            this.wip.set(false);
            if (taskResult.isSuccess() && taskResult.getPayload() != null && taskResult.getPayload() instanceof NudgeViewResult) {
                NudgeViewResult nudgeViewResult = (NudgeViewResult)taskResult.getPayload();
                if (!nudgeViewResult.requestId.equals(this.requestId)) {
                    Logger.v((String)"InApp_4.2.03_NudgeView onTaskComplete() : Nudge view not for this request.");
                    return;
                }
                this.addNudge(nudgeViewResult);
            }
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        Logger.v((String)("InApp_4.2.03_NudgeView onWindowVisibilityChanged() : Visibility: " + visibility));
        if (0 != visibility) {
            if (this.alreadyObserving) {
                InAppController.getInstance().unregisterSyncObserver(this.inAppCacheObserver);
                if (this.completeListener != null) {
                    TaskProcessor.getInstance().removeOnTaskCompleteListener(this.completeListener);
                }
                this.alreadyObserving = false;
            }
        } else {
            InAppController.getInstance().registerSyncObserver(this.inAppCacheObserver);
            this.completeListener = TaskProcessor.getInstance().setOnTaskCompleteListener((OnTaskCompleteListener)this);
            this.alreadyObserving = true;
        }
    }

    void addNudge(final NudgeViewResult nudgeViewResult) {
        try {
            Logger.v((String)"InApp_4.2.03_NudgeView addNudge() : Will attempt to show nudge view.");
            InAppController.getInstance().mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        Logger.v((String)"InApp_4.2.03_NudgeView run() : Adding nudge to layout.");
                        NudgeView.this.addView(nudgeViewResult.view);
                        InAppController.getInstance().onInAppShown(NudgeView.this.context, nudgeViewResult.campaignPayload);
                        NudgeView.this.setVisibility(0);
                    }
                    catch (Exception e) {
                        Logger.e((String)"InApp_4.2.03_NudgeView run() : Exception ", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            Logger.e((String)"NudgeView : addNudge ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryForNudge() {
        if (this.wip.get()) {
            return;
        }
        Object object = this.queryLock;
        synchronized (object) {
            if (this.nudgeView != null) {
                if (this.getVisibility() == 0) {
                    Logger.v((String)"InApp_4.2.03_NudgeView queryForNudge() : Already showing a nudge");
                    return;
                }
                TaskManager.getInstance().startTask((ITask)new BuildNudgeViewTask(this.context, this.requestId));
                this.wip.set(true);
            }
        }
    }

    private class InAppCacheObserver
    implements Observer {
        private InAppCacheObserver() {
        }

        @Override
        public void update(Observable observable, Object data) {
            NudgeView.this.queryForNudge();
        }
    }
}

