/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.widgets;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RatingBar;
import androidx.annotation.Keep;
import com.moengage.inapp.R;

@SuppressLint(value={"AppCompatCustomView"})
@Keep
public class MoERatingBar
extends RatingBar {
    private int color = Color.rgb((int)97, (int)97, (int)97);
    private int colorFillPressedOff = 0;
    private int polygonVertices = 5;
    private int strokeWidth = -1;
    private final Paint paintInside = new Paint();
    private final Paint paintOutline = new Paint();
    private Path path = new Path();
    private final RectF rectangle = new RectF();
    private float interiorAngleModifier = 2.2f;
    private final float dp;
    private float starSize;
    private Bitmap colorsJoined;

    public MoERatingBar(Context context) {
        this(context, null);
    }

    public MoERatingBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.dp = this.getResources().getDisplayMetrics().density;
        this.getXmlAttrs(context, attrs);
        this.init();
    }

    public MoERatingBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.dp = this.getResources().getDisplayMetrics().density;
        this.getXmlAttrs(context, attrs);
        this.init();
    }

    private void init() {
        this.paintInside.setAntiAlias(true);
        this.paintOutline.setStrokeWidth((float)this.strokeWidth);
        this.paintOutline.setStyle(Paint.Style.STROKE);
        this.paintOutline.setStrokeJoin(Paint.Join.ROUND);
        this.paintOutline.setAntiAlias(true);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int desiredWidth = (int)(40.0f * this.dp * (float)this.getNumStars());
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(desiredWidth, widthSize) : desiredWidth);
        int height = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? Math.min(heightSize, width / this.getNumStars()) : width / this.getNumStars());
        this.starSize = Math.min(height, width / this.getNumStars());
        if (this.strokeWidth < 0) {
            this.strokeWidth = (int)(this.starSize / 15.0f);
        }
        this.starSize -= (float)this.strokeWidth;
        this.setMeasuredDimension(width, height);
    }

    private Path createStarBySize(float size, int steps) {
        if (steps == 0) {
            this.path.addOval(new RectF(0.0f, 0.0f, size, size), Path.Direction.CW);
            this.path.close();
            return this.path;
        }
        float halfSize = size / 2.0f;
        float radius = halfSize / this.interiorAngleModifier;
        float degreesPerStep = (float)Math.toRadians(360.0f / (float)steps);
        float halfDegreesPerStep = degreesPerStep / 2.0f;
        this.path.setFillType(Path.FillType.EVEN_ODD);
        float max = (float)Math.PI * 2;
        this.path.moveTo(halfSize, 0.0f);
        for (double step = 0.0; step < (double)max; step += (double)degreesPerStep) {
            this.path.lineTo((float)((double)halfSize - (double)halfSize * Math.sin(step)), (float)((double)halfSize - (double)halfSize * Math.cos(step)));
            this.path.lineTo((float)((double)halfSize - (double)radius * Math.sin(step + (double)halfDegreesPerStep)), (float)((double)halfSize - (double)radius * Math.cos(step + (double)halfDegreesPerStep)));
        }
        this.path.close();
        return this.path;
    }

    protected void onDraw(Canvas canvas) {
        BitmapShader shaderFillPressed = this.updateShader(this.color, this.colorFillPressedOff);
        this.paintInside.setShader((Shader)shaderFillPressed);
        this.path.rewind();
        this.path = this.createStarBySize(this.starSize, this.polygonVertices);
        for (int i = 0; i < this.getNumStars(); ++i) {
            this.paintOutline.setColor(this.color);
            this.path.computeBounds(this.rectangle, true);
            this.path.offset(((float)i + 0.5f) * (float)this.getWidth() / (float)this.getNumStars() - this.rectangle.centerX(), (float)(this.getHeight() / 2) - this.rectangle.centerY());
            canvas.drawPath(this.path, this.paintInside);
            canvas.drawPath(this.path, this.paintOutline);
        }
    }

    private BitmapShader updateShader(int colorOn, int colorOff) {
        int ratingWidth = (int)(this.getRating() * (float)this.getWidth() / (float)this.getNumStars());
        if (ratingWidth <= 0 || this.getWidth() - ratingWidth <= 0) {
            this.colorsJoined = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.colorsJoined.eraseColor(ratingWidth <= 0 ? colorOff : colorOn);
        } else {
            Bitmap colorLeft = Bitmap.createBitmap((int)ratingWidth, (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            colorLeft.eraseColor(colorOn);
            Bitmap colorRight = Bitmap.createBitmap((int)(this.getWidth() - ratingWidth), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            colorRight.eraseColor(colorOff);
            this.colorsJoined = this.combineBitmaps(colorLeft, colorRight);
        }
        return new BitmapShader(this.colorsJoined, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
    }

    private Bitmap combineBitmaps(Bitmap leftBitmap, Bitmap rightBitmap) {
        this.colorsJoined = Bitmap.createBitmap((int)(leftBitmap.getWidth() + rightBitmap.getWidth()), (int)leftBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas comboImage = new Canvas(this.colorsJoined);
        comboImage.drawBitmap(leftBitmap, 0.0f, 0.0f, null);
        comboImage.drawBitmap(rightBitmap, (float)leftBitmap.getWidth(), 0.0f, null);
        return this.colorsJoined;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getXmlAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MoERatingBar, 0, 0);
        try {
            this.color = a.getInteger(R.styleable.MoERatingBar_starColor, Color.rgb((int)97, (int)97, (int)97));
        }
        finally {
            a.recycle();
        }
    }

    public void setColor(int color) {
        this.color = color;
    }
}

