/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.tasks;

import android.content.Context;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.inapp.InAppInjector;
import com.moengage.inapp.model.enums.StateUpdateType;
import com.moengage.inapp.model.meta.CampaignState;
import com.moengage.inapp.model.meta.InAppCampaign;
import com.moengage.inapp.repository.InAppRepository;

public class UpdateCampaignStateTask
extends SDKTask {
    private static final String TAG = "InApp_4.2.03_UpdateCampaignStateTask";
    private String campaignId;
    private StateUpdateType updateType;
    private boolean isSelfHandled;

    public UpdateCampaignStateTask(Context context, StateUpdateType updateType, String campaignId) {
        this(context, campaignId, updateType, false);
    }

    public UpdateCampaignStateTask(Context context, String campaignId, StateUpdateType updateType, boolean isSelfHandled) {
        super(context);
        this.campaignId = campaignId;
        this.updateType = updateType;
        this.isSelfHandled = isSelfHandled;
    }

    public TaskResult execute() {
        try {
            Logger.v((String)("InApp_4.2.03_UpdateCampaignStateTask execute() : Will log updated in-app state " + (Object)((Object)this.updateType) + " for campaign id " + this.campaignId));
            long currentTime = MoEUtils.currentSeconds();
            InAppRepository repository = InAppInjector.getInstance().getInAppRepository(this.context);
            InAppCampaign campaign = repository.localRepository.getCampaignById(this.campaignId);
            if (campaign == null) {
                Logger.v((String)"InApp_4.2.03_UpdateCampaignStateTask execute() : Campaign not found. Cannot update stats.");
                return this.taskResult;
            }
            if (this.isSelfHandled && !campaign.campaignMeta.templateType.equals("SELF_HANDLED")) {
                Logger.v((String)"InApp_4.2.03_UpdateCampaignStateTask execute() : Expected template type was self-handled. Not a self handled campaign will ignore update.");
                return this.taskResult;
            }
            CampaignState currentState = campaign.campaignState;
            CampaignState updatedState = null;
            switch (this.updateType) {
                case SHOWN: {
                    updatedState = new CampaignState(currentState.showCount + 1L, currentTime, currentState.isClicked);
                    repository.localRepository.updateLastShowTime(currentTime);
                    break;
                }
                case CLICKED: {
                    updatedState = new CampaignState(currentState.showCount, currentState.lastShowTime, true);
                }
            }
            int updateCount = repository.localRepository.updateCampaignState(updatedState, campaign.campaignMeta.campaignId);
            repository.updateCache();
            if (updateCount > 0) {
                this.taskResult.setIsSuccess(true);
            }
            Logger.v((String)("InApp_4.2.03_UpdateCampaignStateTask execute() : Updated in-app state for campaign id: " + this.campaignId + "updated campaign: " + updateCount));
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_UpdateCampaignStateTask execute() : ", (Throwable)e);
        }
        return this.taskResult;
    }

    public String getTaskTag() {
        return "UPDATE_CAMPAIGN_STATE_TASK";
    }

    public boolean isSynchronous() {
        return false;
    }
}

