/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.tasks;

import android.content.Context;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.evaluator.ConditionEvaluator;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.InAppEvaluator;
import com.moengage.inapp.InAppInjector;
import com.moengage.inapp.InAppUtils;
import com.moengage.inapp.model.CampaignPayload;
import com.moengage.inapp.model.CampaignRequest;
import com.moengage.inapp.model.TriggerRequestMeta;
import com.moengage.inapp.model.meta.InAppCampaign;
import com.moengage.inapp.model.meta.Trigger;
import com.moengage.inapp.repository.InAppRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.json.JSONObject;

public class ShowTriggerInAppTask
extends SDKTask {
    private static final String TAG = "InApp_4.2.03_ShowTriggerInAppTask";
    private Event event;
    private InAppController controller;

    public ShowTriggerInAppTask(Context context, Event event) {
        super(context);
        this.event = event;
        this.controller = InAppController.getInstance();
    }

    public TaskResult execute() {
        Logger.v((String)"InApp_4.2.03_ShowTriggerInAppTask execute() : started execution");
        try {
            if (!this.controller.isModuleEnabled(this.context)) {
                Logger.v((String)"InApp_4.2.03_ShowTriggerInAppTask execute() : InApp Module is disabled. Cannot show in-app.");
                return this.taskResult;
            }
            if (!this.controller.isInAppSynced()) {
                Logger.v((String)"InApp_4.2.03_ShowTriggerInAppTask execute() : Cannot show trigger in-app as sync is pending");
                return null;
            }
            InAppUtils.logCurrentInAppState(this.context);
            InAppRepository repository = InAppInjector.getInstance().getInAppRepository(this.context);
            InAppEvaluator evaluator = new InAppEvaluator();
            Set<String> triggerEvent = repository.cache.triggerEvents;
            if (triggerEvent == null || !triggerEvent.contains(this.event.eventName)) {
                Logger.v((String)("InApp_4.2.03_ShowTriggerInAppTask execute() : Given event is not a trigger event, event name: " + this.event.eventName));
                return null;
            }
            List<InAppCampaign> triggerCampaigns = repository.localRepository.getCampaignsForEvent(this.event.eventName);
            if (triggerCampaigns == null) {
                Logger.v((String)"InApp_4.2.03_ShowTriggerInAppTask execute() : No campaign for given event, This is strange.");
                return null;
            }
            ArrayList<InAppCampaign> filteredCampaigns = new ArrayList<InAppCampaign>();
            for (InAppCampaign campaign : triggerCampaigns) {
                JSONObject eventAttributesTransformed = MoEHelperUtils.transformEventAttributesForEvaluationPackage((JSONObject)this.event.attributes);
                if (!this.evaluateCondition(campaign.campaignMeta.trigger, eventAttributesTransformed)) continue;
                filteredCampaigns.add(campaign);
            }
            if (filteredCampaigns.size() == 0) {
                Logger.v((String)"InApp_4.2.03_ShowTriggerInAppTask execute() : No campaign satisfies the filter condition.");
                return this.taskResult;
            }
            if (!this.controller.canShowInAppForConfig(this.context, filteredCampaigns)) {
                return this.taskResult;
            }
            InAppCampaign suitableCampaign = evaluator.getEligibleCampaignFromList(filteredCampaigns, repository.localRepository.getGlobalState(), MoEHelper.getInstance((Context)this.context).getAppContext());
            if (suitableCampaign == null) {
                Logger.v((String)"InApp_4.2.03_ShowTriggerInAppTask execute() : Did not find any suitable in-app");
                return this.taskResult;
            }
            CampaignPayload campaignPayload = repository.fetchCampaignPayload(new CampaignRequest(repository.localRepository.baseRequest(), suitableCampaign.campaignMeta.campaignId, this.controller.getCurrentActivityName(), MoEHelper.getInstance((Context)this.context).getAppContext(), new TriggerRequestMeta(this.event.eventName, MoEHelperUtils.transformEventAttributesForEvaluationPackage((JSONObject)this.event.attributes), MoEUtils.currentISOTime())), suitableCampaign.campaignMeta.deliveryControl.persistent);
            if (campaignPayload == null) {
                Logger.v((String)"InApp_4.2.03_ShowTriggerInAppTask execute() : Campaign Payload is empty. Cannot show campaign.");
                return this.taskResult;
            }
            this.taskResult.setIsSuccess(true);
            if (campaignPayload.templateType.equals("SELF_HANDLED")) {
                InAppController.getInstance().onSelfHandledAvailable(campaignPayload);
            } else {
                this.controller.buildAndShowInApp(this.context, suitableCampaign, campaignPayload);
            }
            Logger.v((String)"InApp_4.2.03_ShowTriggerInAppTask execute() : execution completed");
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_ShowTriggerInAppTask execute() : ", (Throwable)e);
        }
        return this.taskResult;
    }

    private boolean evaluateCondition(Trigger condition, JSONObject eventAttributesTransformed) {
        boolean conditionEvaluatorResult = false;
        try {
            Logger.v((String)("InApp_4.2.03_ShowTriggerInAppTask execute() : Attribute JSON for evaluation" + eventAttributesTransformed.toString()));
            if (condition.primaryCondition.attributes == null || condition.primaryCondition.attributes.length() == 0) {
                return true;
            }
            conditionEvaluatorResult = new ConditionEvaluator(condition.primaryCondition.attributes, eventAttributesTransformed).evaluate();
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_ShowTriggerInAppTask evaluateCondition() : ", (Throwable)e);
        }
        Logger.v((String)("InApp_4.2.03_ShowTriggerInAppTask evaluateCondition() : Evaluation result: " + conditionEvaluatorResult));
        return conditionEvaluatorResult;
    }

    public String getTaskTag() {
        return "CHECK_AND_SHOW_TRIGGER_BASED_IN_APP_TASK";
    }

    public boolean isSynchronous() {
        return false;
    }
}

