/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.tasks;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.InAppInjector;
import com.moengage.inapp.InAppUtils;
import com.moengage.inapp.ViewCreationMeta;
import com.moengage.inapp.model.TestCampaignResponse;
import com.moengage.inapp.model.ViewDimension;
import com.moengage.inapp.repository.InAppRepository;

public class ShowTestInAppTask
extends SDKTask {
    private static final String TAG = "InApp_4.2.03_ShowTestInAppTask";
    private String campaignId;

    public ShowTestInAppTask(Context context, String campaignId) {
        super(context);
        this.campaignId = campaignId;
    }

    public TaskResult execute() {
        try {
            Logger.v((String)"InApp_4.2.03_ShowTestInAppTask execute() : Executing ShowTestInAppTask.");
            if (!InAppController.getInstance().isModuleEnabled(this.context)) {
                Logger.v((String)"InApp_4.2.03_ShowTestInAppTask execute() : InApp Module is disabled. Cannot show in-app.");
                return this.taskResult;
            }
            if (MoEUtils.isEmptyString((String)this.campaignId)) {
                Logger.v((String)"InApp_4.2.03_ShowTestInAppTask execute() : Empty campaign id. Cannot show test in-app.");
                this.taskResult.setIsSuccess(false);
                return this.taskResult;
            }
            if (InAppController.getInstance().isTablet(this.context)) {
                Logger.v((String)"InApp_4.2.03_ShowTestInAppTask execute() : Cannot show in-app on tablet.");
                this.showErrorDialog("Cannot show in-app on Tablet devices.");
                return this.taskResult;
            }
            InAppRepository repository = InAppInjector.getInstance().getInAppRepository(this.context);
            TestCampaignResponse campaignResponse = repository.fetchTestCampaignPayload(this.campaignId);
            if (campaignResponse == null) {
                this.showErrorDialog("Something went wrong. Could not show in-app.\n Try again or Contact MoEngage Support.\n Draft-id: " + this.campaignId);
                return this.taskResult;
            }
            if (!campaignResponse.isSuccess) {
                String message = campaignResponse.errorMessage;
                if (MoEUtils.isEmptyString((String)message)) {
                    message = "Something went wrong. Could not show in-app.\n Try again or Contact MoEngage Support.";
                }
                message = message + "\n Draft-id: " + this.campaignId;
                this.showErrorDialog(message);
                return this.taskResult;
            }
            if (campaignResponse.campaignPayload == null) {
                Logger.v((String)"InApp_4.2.03_ShowTestInAppTask execute() : Campaign payload empty.");
                return this.taskResult;
            }
            if ("SELF_HANDLED".equals(campaignResponse.campaignPayload.templateType)) {
                InAppController.getInstance().onSelfHandledAvailable(campaignResponse.campaignPayload);
                this.taskResult.setIsSuccess(true);
                return this.taskResult;
            }
            ViewCreationMeta meta = new ViewCreationMeta(InAppUtils.getScreenDimension(this.context), InAppUtils.getStatusBarHeight(this.context));
            View inAppView = InAppController.getInstance().buildInApp(campaignResponse.campaignPayload, meta);
            if (inAppView == null) {
                Logger.v((String)"InApp_4.2.03_ShowTestInAppTask execute() : Cannot show in-app. View creation failed.");
                this.showErrorDialog("Something went wrong in creating the in-app view. Cannot show in-app.\nTry again or Contact MoEngage Support.\nDraft-id: " + this.campaignId);
                return this.taskResult;
            }
            ViewDimension inAppDimensions = InAppUtils.getUnspecifiedViewDimension(inAppView);
            if (InAppUtils.isInAppExceedingScreen(inAppDimensions, InAppUtils.getScreenDimension(this.context))) {
                this.showErrorDialog("Created in-app exceeds screen dimensions.\n Cannot show in-app, please check and edit the in-app template on MoEngage Dashboard.");
                return this.taskResult;
            }
            if (InAppController.getInstance().isLandscapeMode(this.context)) {
                Logger.v((String)"InApp_4.2.03_ShowTestInAppTask execute() : Cannot show in-app in landscape mode.");
                this.showErrorDialog("Cannot show in-app in landscape mode.");
                return this.taskResult;
            }
            InAppController.getInstance().addInAppToViewHierarchy(InAppController.getInstance().getCurrentActivity(), inAppView, campaignResponse.campaignPayload);
            this.taskResult.setIsSuccess(true);
            Logger.v((String)"InApp_4.2.03_ShowTestInAppTask execute() : Completed executing ShowTestInAppTask.");
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_ShowTestInAppTask execute() : ", (Throwable)e);
        }
        return this.taskResult;
    }

    public String getTaskTag() {
        return "TEST_INAPP_TASK";
    }

    public boolean isSynchronous() {
        return true;
    }

    private void showErrorDialog(String errorMessage) {
        Activity activity = InAppController.getInstance().getCurrentActivity();
        if (activity == null) {
            Logger.v((String)"InApp_4.2.03_ShowTestInAppTask showErrorDialog() : Cannot show error dialog. Activity instance is null.");
            return;
        }
        final AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)activity);
        alertDialog.setMessage((CharSequence)errorMessage).setTitle((CharSequence)"Test in-app error").setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog dialog = alertDialog.create();
                dialog.show();
            }
        });
    }
}

