/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.tasks;

import android.content.Context;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.InAppEvaluator;
import com.moengage.inapp.InAppInjector;
import com.moengage.inapp.MoEInAppHelper;
import com.moengage.inapp.listeners.InAppMessageListener;
import com.moengage.inapp.model.CampaignPayload;
import com.moengage.inapp.model.CampaignRequest;
import com.moengage.inapp.model.meta.InAppCampaign;
import com.moengage.inapp.repository.InAppRepository;
import java.util.List;

public class ShowSelfHandledInAppTask
extends SDKTask {
    private static final String TAG = "ShowSelfHandledInAppTask";
    private InAppEvaluator evaluator = new InAppEvaluator();

    public ShowSelfHandledInAppTask(Context context) {
        super(context);
    }

    public TaskResult execute() {
        try {
            Logger.v((String)"ShowSelfHandledInAppTask execute() : started execution");
            InAppController controller = InAppController.getInstance();
            InAppRepository repository = InAppInjector.getInstance().getInAppRepository(this.context);
            InAppMessageListener listener = MoEInAppHelper.getInstance().getListener();
            if (!controller.isModuleEnabled(this.context)) {
                Logger.v((String)"ShowSelfHandledInAppTask execute() : InApp Module is disabled. Cannot show in-app.");
                return this.taskResult;
            }
            if (!controller.isInAppSynced()) {
                Logger.v((String)"ShowSelfHandledInAppTask execute() : Cannot show trigger in-app as sync is pending");
                return null;
            }
            if (listener == null) {
                Logger.w((String)"ShowSelfHandledInAppTask execute() : InAppMessageListener not set. Cannot pass self-handled callback, ignoring request.");
                return this.taskResult;
            }
            List<InAppCampaign> selfHandledCampaigns = repository.cache.selfHandledCampaign;
            if (selfHandledCampaigns == null) {
                Logger.v((String)"ShowSelfHandledInAppTask execute() : No active campaigns to show");
                return this.taskResult;
            }
            InAppCampaign suitableInApp = this.evaluator.getEligibleCampaignFromList(selfHandledCampaigns, repository.localRepository.getGlobalState(), MoEHelper.getInstance((Context)this.context).getAppContext());
            if (suitableInApp == null) {
                Logger.v((String)"ShowSelfHandledInAppTask execute() : Did not find any suitable campaign to show");
                return this.taskResult;
            }
            CampaignPayload campaignPayload = repository.fetchSelfHandledPayload(new CampaignRequest(repository.localRepository.baseRequest(), suitableInApp.campaignMeta.campaignId, controller.getCurrentActivityName(), MoEHelper.getInstance((Context)this.context).getAppContext()));
            if (campaignPayload == null) {
                Logger.v((String)"ShowSelfHandledInAppTask execute() : Campaign Payload is empty. Cannot show campaign.");
                return this.taskResult;
            }
            controller.onSelfHandledAvailable(campaignPayload);
            this.taskResult.setIsSuccess(true);
            Logger.v((String)"ShowSelfHandledInAppTask execute() : execution completion");
        }
        catch (Exception e) {
            Logger.e((String)"ShowSelfHandledInAppTask execute() : ", (Throwable)e);
        }
        return this.taskResult;
    }

    public String getTaskTag() {
        return "CHECK_AND_SHOW_SELF_HANDLED_IN_APP_TASK";
    }

    public boolean isSynchronous() {
        return true;
    }
}

