/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.tasks;

import android.content.Context;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.InAppEvaluator;
import com.moengage.inapp.InAppInjector;
import com.moengage.inapp.InAppUtils;
import com.moengage.inapp.model.CampaignPayload;
import com.moengage.inapp.model.CampaignRequest;
import com.moengage.inapp.model.meta.InAppCampaign;
import com.moengage.inapp.repository.InAppRepository;
import java.util.List;

public class ShowInAppTask
extends SDKTask {
    private static final String TAG = "InApp_4.2.03_ShowInAppTask";
    private InAppEvaluator evaluator = new InAppEvaluator();

    public ShowInAppTask(Context context) {
        super(context);
    }

    public TaskResult execute() {
        try {
            InAppController controller = InAppController.getInstance();
            Logger.v((String)"InApp_4.2.03_ShowInAppTask execute() : started execution");
            if (!controller.isModuleEnabled(this.context)) {
                Logger.v((String)"InApp_4.2.03_ShowInAppTask execute() : InApp Module is disabled. Cannot show in-app.");
                return this.taskResult;
            }
            if (!controller.isInAppSynced()) {
                Logger.v((String)"InApp_4.2.03_ShowInAppTask execute() : Cannot show trigger in-app as sync is pending");
                return null;
            }
            InAppRepository repository = InAppInjector.getInstance().getInAppRepository(this.context);
            InAppUtils.logCurrentInAppState(this.context);
            List<InAppCampaign> generalCampaigns = repository.cache.generalCampaign;
            if (generalCampaigns == null) {
                Logger.v((String)"InApp_4.2.03_ShowInAppTask execute() : No active campaigns to show");
                return this.taskResult;
            }
            if (!controller.canShowInAppForConfig(this.context, generalCampaigns)) {
                return this.taskResult;
            }
            InAppCampaign suitableInApp = this.evaluator.getEligibleCampaignFromList(generalCampaigns, repository.localRepository.getGlobalState(), MoEHelper.getInstance((Context)this.context).getAppContext());
            if (suitableInApp == null) {
                Logger.v((String)"InApp_4.2.03_ShowInAppTask execute() : Did not find any suitable campaign to show");
                return this.taskResult;
            }
            CampaignPayload campaignPayload = repository.fetchCampaignPayload(new CampaignRequest(repository.localRepository.baseRequest(), suitableInApp.campaignMeta.campaignId, controller.getCurrentActivityName(), MoEHelper.getInstance((Context)this.context).getAppContext()), suitableInApp.campaignMeta.deliveryControl.persistent);
            if (campaignPayload == null) {
                Logger.v((String)"InApp_4.2.03_ShowInAppTask execute() : Campaign Payload is empty. Cannot show campaign.");
                return this.taskResult;
            }
            controller.buildAndShowInApp(this.context, suitableInApp, campaignPayload);
            Logger.v((String)"InApp_4.2.03_ShowInAppTask execute() : execution complete");
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_ShowInAppTask execute() : Exception ", (Throwable)e);
        }
        return this.taskResult;
    }

    public String getTaskTag() {
        return "CHECK_AND_SHOW_IN_APP_TASK";
    }

    public boolean isSynchronous() {
        return true;
    }
}

