/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.tasks;

import android.content.Context;
import android.view.View;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.InAppInjector;
import com.moengage.inapp.InAppUtils;
import com.moengage.inapp.ViewCreationMeta;
import com.moengage.inapp.model.CampaignPayload;
import com.moengage.inapp.model.CampaignRequest;
import com.moengage.inapp.model.meta.InAppCampaign;
import com.moengage.inapp.repository.InAppRepository;

public class PreviewInAppTask
extends SDKTask {
    private static final String TAG = "PreviewInAppTask";
    private InAppCampaign campaign;

    public PreviewInAppTask(Context context, InAppCampaign campaign) {
        super(context);
        this.campaign = campaign;
    }

    public TaskResult execute() {
        try {
            View inAppView;
            Logger.v((String)"PreviewInAppTask execute() : will try creating preview");
            InAppRepository repository = InAppInjector.getInstance().getInAppRepository(this.context);
            ViewCreationMeta meta = new ViewCreationMeta(InAppUtils.getScreenDimension(this.context), InAppUtils.getStatusBarHeight(this.context));
            CampaignRequest request = new CampaignRequest(repository.localRepository.baseRequest(), this.campaign.campaignMeta.campaignId, InAppController.getInstance().getCurrentActivityName(), MoEHelper.getInstance((Context)this.context).getAppContext());
            if (this.campaign.campaignMeta.templateType.equals("SELF_HANDLED")) {
                CampaignPayload campaignPayload = repository.fetchSelfHandledPayload(request);
                if (campaignPayload == null) {
                    return this.taskResult;
                }
                InAppController.getInstance().onSelfHandledAvailable(campaignPayload);
                this.taskResult.setIsSuccess(true);
                return this.taskResult;
            }
            CampaignPayload campaignPayload = repository.fetchCampaignPayload(request, true);
            if (campaignPayload != null && (inAppView = InAppController.getInstance().buildInApp(campaignPayload, meta)) != null) {
                InAppController.getInstance().addInAppToViewHierarchy(InAppController.getInstance().getCurrentActivity(), inAppView, campaignPayload);
                this.taskResult.setIsSuccess(true);
            }
            Logger.v((String)"PreviewInAppTask execute() : Preview creation completed.");
        }
        catch (Exception e) {
            Logger.e((String)"PreviewInAppTask execute() : ", (Throwable)e);
        }
        return this.taskResult;
    }

    public String getTaskTag() {
        return "PREVIEW_INAPP_TASK";
    }

    public boolean isSynchronous() {
        return true;
    }
}

