/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.tasks;

import android.content.Context;
import android.view.View;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.InAppInjector;
import com.moengage.inapp.InAppUtils;
import com.moengage.inapp.ViewCreationMeta;
import com.moengage.inapp.model.CampaignPayload;
import com.moengage.inapp.model.CampaignRequest;
import com.moengage.inapp.model.NudgeViewResult;
import com.moengage.inapp.model.meta.InAppCampaign;
import com.moengage.inapp.repository.InAppRepository;
import java.util.Map;

public class BuildNudgeViewTask
extends SDKTask {
    private static final String TAG = "InApp_4.2.03_BuildNudgeViewTask";
    private String requestId;

    public BuildNudgeViewTask(Context context, String requestId) {
        super(context);
        this.requestId = requestId;
    }

    public TaskResult execute() {
        try {
            Logger.v((String)"InApp_4.2.03_BuildNudgeViewTask execute() : Will build nudge if available");
            InAppController controller = InAppController.getInstance();
            if (!controller.isInAppSynced()) {
                Logger.v((String)"InApp_4.2.03_BuildNudgeViewTask execute() : Cannot show nudge. Api Sync is pending.");
                return this.taskResult;
            }
            if (!controller.isModuleEnabled(this.context)) {
                Logger.v((String)"InApp_4.2.03_BuildNudgeViewTask execute() : InApp Module is disabled. Cannot show in-app.");
                return this.taskResult;
            }
            InAppRepository repository = InAppInjector.getInstance().getInAppRepository(this.context);
            Map<String, InAppCampaign> campaignMap = repository.localRepository.embeddedCampaign();
            if (campaignMap == null) {
                Logger.v((String)"InApp_4.2.03_BuildNudgeViewTask execute() : No nudge campaigns found.");
                return this.taskResult;
            }
            InAppCampaign suitableInApp = InAppController.getInstance().getEligibleNudgeView(this.context, campaignMap);
            if (suitableInApp == null) {
                Logger.v((String)"InApp_4.2.03_BuildNudgeViewTask execute() : No valid campaign found.");
                return this.taskResult;
            }
            Logger.v((String)("InApp_4.2.03_BuildNudgeViewTask execute() : Suitable campaign: " + suitableInApp));
            InAppController.getInstance().addProcessingNudge(suitableInApp.campaignMeta.campaignId);
            CampaignPayload campaignPayload = repository.fetchCampaignPayload(new CampaignRequest(repository.localRepository.baseRequest(), suitableInApp.campaignMeta.campaignId, controller.getCurrentActivityName(), MoEHelper.getInstance((Context)this.context).getAppContext()), suitableInApp.campaignMeta.deliveryControl.persistent);
            if (campaignPayload == null) {
                InAppController.getInstance().removeProcessingNudge(suitableInApp.campaignMeta.campaignId);
                return this.taskResult;
            }
            View view = controller.buildInApp(campaignPayload, new ViewCreationMeta(InAppUtils.getScreenDimension(this.context), InAppUtils.getStatusBarHeight(this.context)));
            if (view == null) {
                InAppController.getInstance().removeProcessingNudge(suitableInApp.campaignMeta.campaignId);
                return this.taskResult;
            }
            this.taskResult.setIsSuccess(true);
            this.taskResult.setPayload((Object)new NudgeViewResult(this.requestId, campaignPayload, view));
            Logger.v((String)"InApp_4.2.03_BuildNudgeViewTask execute() : Nudge creation complete");
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_BuildNudgeViewTask execute() : ", (Throwable)e);
        }
        return this.taskResult;
    }

    public String getTaskTag() {
        return "BUILD_NUDGE_VIEW_TASK";
    }

    public boolean isSynchronous() {
        return false;
    }
}

