/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.repository.remote;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.rest.Response;
import com.moengage.inapp.R;
import com.moengage.inapp.exceptions.ParseException;
import com.moengage.inapp.model.Animation;
import com.moengage.inapp.model.Background;
import com.moengage.inapp.model.Border;
import com.moengage.inapp.model.CampaignPayload;
import com.moengage.inapp.model.Color;
import com.moengage.inapp.model.Font;
import com.moengage.inapp.model.InAppCampaignResponse;
import com.moengage.inapp.model.InAppComponent;
import com.moengage.inapp.model.InAppContainer;
import com.moengage.inapp.model.InAppMetaResponse;
import com.moengage.inapp.model.InAppWidget;
import com.moengage.inapp.model.Margin;
import com.moengage.inapp.model.Padding;
import com.moengage.inapp.model.StatsUploadResponse;
import com.moengage.inapp.model.TestCampaignResponse;
import com.moengage.inapp.model.Widget;
import com.moengage.inapp.model.actions.Action;
import com.moengage.inapp.model.actions.CallAction;
import com.moengage.inapp.model.actions.Condition;
import com.moengage.inapp.model.actions.ConditionAction;
import com.moengage.inapp.model.actions.CopyAction;
import com.moengage.inapp.model.actions.CustomAction;
import com.moengage.inapp.model.actions.DismissAction;
import com.moengage.inapp.model.actions.NavigationAction;
import com.moengage.inapp.model.actions.ShareAction;
import com.moengage.inapp.model.actions.SmsAction;
import com.moengage.inapp.model.actions.TrackAction;
import com.moengage.inapp.model.actions.UserInputAction;
import com.moengage.inapp.model.enums.ActionType;
import com.moengage.inapp.model.enums.ClosePosition;
import com.moengage.inapp.model.enums.DataTrackType;
import com.moengage.inapp.model.enums.NavigationType;
import com.moengage.inapp.model.enums.Orientation;
import com.moengage.inapp.model.enums.TemplateAlignment;
import com.moengage.inapp.model.enums.UserInputType;
import com.moengage.inapp.model.enums.ViewType;
import com.moengage.inapp.model.enums.WidgetType;
import com.moengage.inapp.model.meta.CampaignMeta;
import com.moengage.inapp.model.meta.CampaignState;
import com.moengage.inapp.model.meta.InAppCampaign;
import com.moengage.inapp.model.style.ButtonStyle;
import com.moengage.inapp.model.style.CloseStyle;
import com.moengage.inapp.model.style.ContainerStyle;
import com.moengage.inapp.model.style.ImageStyle;
import com.moengage.inapp.model.style.InAppStyle;
import com.moengage.inapp.model.style.RatingStyle;
import com.moengage.inapp.model.style.TextStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ResponseParser {
    private static final String TAG = "InApp_4.2.03_ResponseParser";
    private static final String GLOBAL_MINIMUM_DELAY = "min_delay_btw_inapps";
    private static final String SYNC_INTERVAL = "sync_interval";
    private static final String CAMPAIGNS = "campaigns";
    private static final String CAMPAIGN_ID = "campaign_id";
    private static final String CAMPAIGN_TYPE = "campaign_type";
    private static final String IN_APP_ANIMATION_SLIDE_UP = "SLIDE_UP";
    private static final String IN_APP_ANIMATION_SLIDE_DOWN = "SLIDE_DOWN";
    private static final String IN_APP_ANIMATION_SLIDE_LEFT = "SLIDE_LEFT";
    private static final String IN_APP_ANIMATION_SLIDE_RIGHT = "SLIDE_RIGHT";
    private static final String IN_APP_ANIMATION_FADE_IN = "FADE_IN";
    private static final String IN_APP_ANIMATION_FADE_OUT = "FADE_OUT";
    private static final String WIDGETS = "widgets";
    private static final String PAYLOAD = "payload";
    private static final String PRIMARY_CONTAINER = "primary_container";
    private static final String PRIMARY_WIDGET = "primary_widget";
    private static final String CANCELLABLE = "cancellable";
    private static final String MARGIN = "margin";
    private static final String BORDER = "border";
    private static final String BACKGROUND = "background";
    private static final String ANIMATION = "animation";
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String TOP = "top";
    private static final String BOTTOM = "bottom";
    private static final String CONTENT = "content";
    private static final String ENTRY = "entry";
    private static final String EXIT = "exit";
    private static final String RADIUS = "radius";
    private static final String FONT = "font";
    private static final String SIZE = "size";
    private static final String FONT_NAME = "font_name";
    private static final String STYLE = "style";
    private static final String ACTION_TYPE = "action_type";
    private static final String TRACK_TYPE = "track_type";
    private static final String VALUE = "value";
    private static final String REFERENCE_PATH = "_ref";
    private static final String WIDGET_FLOAT = "float";
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static final String COMPONENT = "component";
    private static final String POSITION = "position";
    private static final String MINIMUM_HEIGHT = "min_height";
    private static final String NAVIGATION_TYPE = "navigation_type";
    private static final String NAME = "name";
    private static final String MESSAGE = "message";
    private static final String ATTR_DATA_MAP = "data_map";
    private static final String CAMPAIGN_NAME = "campaign_name";
    private static final String TEMPLATE_ALIGNMENT = "template_alignment";
    private static final String REAL_HEIGHT = "realHeight";
    private static final String REAL_WIDTH = "realWidth";
    private static final String WIDGET_ACTION = "action";
    private static final String WIDGET_ACTIONS = "actions";
    private static final String DISPLAY = "display";
    private static final String PADDING = "padding";
    private static final String IMAGE = "image";
    private static final String COLOR = "color";
    private static final String COLOR_ALPHA = "a";
    private static final String COLOR_RED = "r";
    private static final String COLOR_GREEN = "g";
    private static final String COLOR_BLUE = "b";
    private static final String TEMPLATE_TYPE = "template_type";
    private static final String DISMISS_INTERVAL = "dismiss_interval";
    private static final String WIDGET_ID = "widget_id";
    private static final String RATING_STYLE = "rating_style";
    private static final String NUMBER_OF_STARS = "number_of_stars";
    private static final String HALF_STEP_ALLOWED = "half_step_allowed";
    private static final String INPUT_TYPE = "input_type";
    private static final String CONDITIONS = "conditions";
    private static final String ATTRIBUTE = "attribute";
    private static final String ERROR = "error";
    private static final String ERROR_MESSAGE_NO_INTERNET_CONNECTION = "No Internet Connection.\nPlease connect to internet and try again.";
    private static final String ERROR_MESSAGE_COULD_NOT_REACH_MOENGAGE_SERVER = "Could not reach MoEngage Server.\n Please try again or contact MoEngage Support.";

    ResponseParser() {
    }

    InAppMetaResponse parseSyncResponse(Response response) {
        try {
            if (response == null || response.responseCode != 200 || response.responseBody == null) {
                return new InAppMetaResponse(false);
            }
            JSONObject responseJson = new JSONObject(response.responseBody);
            return new InAppMetaResponse(true, this.campaignsFromResponse(responseJson), responseJson.optLong(SYNC_INTERVAL, -1L), responseJson.getLong(GLOBAL_MINIMUM_DELAY));
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_ResponseParser parseSyncResponse() : Exception ", (Throwable)e);
            return new InAppMetaResponse(false);
        }
    }

    List<InAppCampaign> campaignsFromResponse(JSONObject responseJSON) {
        try {
            if (!responseJSON.has(CAMPAIGNS)) {
                return new ArrayList<InAppCampaign>();
            }
            JSONArray campaignArray = responseJSON.getJSONArray(CAMPAIGNS);
            if (campaignArray == null || campaignArray.length() == 0) {
                return new ArrayList<InAppCampaign>();
            }
            MoEUtils.logJsonArray((String)TAG, (JSONArray)campaignArray);
            HashMap<String, InAppCampaign> campaignMap = new HashMap<String, InAppCampaign>();
            for (int i = 0; i < campaignArray.length(); ++i) {
                JSONObject campaignJson = campaignArray.getJSONObject(i);
                InAppCampaign campaign = this.campaignFromJson(campaignJson);
                if (campaign == null) continue;
                if (campaign.campaignType.equals("smart") && campaign.campaignMeta.templateType.equals("EMBEDDED")) {
                    Logger.v((String)"InApp_4.2.03_ResponseParser campaignsFromResponse() : Embedded smart triggers not supported. Ignoring campaign.");
                    continue;
                }
                campaignMap.put(campaign.campaignMeta.campaignId, campaign);
            }
            return new ArrayList<InAppCampaign>(campaignMap.values());
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_ResponseParser campaignsFromResponse() : ", (Throwable)e);
            return new ArrayList<InAppCampaign>();
        }
    }

    @Nullable
    InAppCampaign campaignFromJson(JSONObject campaignJson) {
        try {
            if (!campaignJson.has(CAMPAIGN_TYPE)) {
                Logger.v((String)"InApp_4.2.03_ResponseParser campaignFromJson() : Campaign type missing ignoring campaign.");
                return null;
            }
            if (!campaignJson.getString(CAMPAIGN_TYPE).equals("MOBILE_INAPP")) {
                Logger.v((String)"InApp_4.2.03_ResponseParser campaignFromJson() : Not a mobile in-app campaign will ignore campaign.");
                return null;
            }
            CampaignMeta campaignMeta = this.jsonToCampaignMeta(campaignJson);
            long currentTime = MoEUtils.currentSeconds();
            return new InAppCampaign(-1L, campaignMeta.trigger == null ? "general" : "smart", "ACTIVE", this.getDeletionTime(currentTime, campaignMeta.expiryTime), currentTime, campaignMeta, new CampaignState(0L, 0L, false));
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_ResponseParser campaignFromJson() : ", (Throwable)e);
            return null;
        }
    }

    long getDeletionTime(long currentTime, long expiryTime) {
        return Math.max(currentTime + 5184000L, expiryTime);
    }

    private CampaignMeta jsonToCampaignMeta(JSONObject campaignJson) throws JSONException {
        return CampaignMeta.fromJson(campaignJson);
    }

    InAppCampaignResponse selfHandledCampaignFromResponse(Response response) {
        int responseCode = 999;
        try {
            if (response == null) {
                return new InAppCampaignResponse(responseCode, false);
            }
            responseCode = response.responseCode;
            if (response.responseCode != 200 || response.responseBody == null) {
                return new InAppCampaignResponse(response.responseCode, false);
            }
            JSONObject responseJson = new JSONObject(response.responseBody);
            return new InAppCampaignResponse(response.responseCode, true, this.selfHandledCampaignFromJson(responseJson));
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_ResponseParser selfHandledCampaignFromResponse() : ", (Throwable)e);
            return new InAppCampaignResponse(responseCode, false, true);
        }
    }

    private CampaignPayload selfHandledCampaignFromJson(JSONObject responseJson) throws JSONException {
        return new CampaignPayload(responseJson.getString(CAMPAIGN_ID), responseJson.getString(CAMPAIGN_NAME), TemplateAlignment.setValue(responseJson.optString(TEMPLATE_ALIGNMENT, TemplateAlignment.CENTER.toString()).trim().toUpperCase()), responseJson.getString(TEMPLATE_TYPE), responseJson.optBoolean(CANCELLABLE, true), responseJson.optLong(DISMISS_INTERVAL, -1L), responseJson, responseJson.getString(PAYLOAD));
    }

    InAppCampaignResponse parseCampaignPayload(Response response) {
        boolean hasParsingException = false;
        int responseCode = 999;
        try {
            if (response == null) {
                return new InAppCampaignResponse(responseCode, false);
            }
            responseCode = response.responseCode;
            if (response.responseCode != 200 || response.responseBody == null) {
                return new InAppCampaignResponse(response.responseCode, false);
            }
            JSONObject responseJson = new JSONObject(response.responseBody);
            return new InAppCampaignResponse(response.responseCode, true, this.campaignPayloadFromResponse(responseJson));
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_ResponseParser parseCampaignPayload() : Exception: ", (Throwable)e);
            hasParsingException = true;
            return new InAppCampaignResponse(responseCode, false, hasParsingException);
        }
    }

    CampaignPayload campaignPayloadFromResponse(JSONObject responseJson) throws JSONException, ParseException {
        return new CampaignPayload(responseJson.getString(CAMPAIGN_ID), responseJson.getString(CAMPAIGN_NAME), this.containerFromJson(responseJson, this.getJsonFromReferencePath(responseJson, responseJson.getJSONObject(PRIMARY_CONTAINER).getString(REFERENCE_PATH)), true), responseJson.has(PRIMARY_WIDGET) ? this.widgetFromJson((JSONObject)responseJson, (JSONObject)this.getJsonFromReferencePath((JSONObject)responseJson, (String)responseJson.getJSONObject((String)PRIMARY_WIDGET).getString((String)REFERENCE_PATH))).id : -1, responseJson.getString(TEMPLATE_TYPE), TemplateAlignment.setValue(responseJson.optString(TEMPLATE_ALIGNMENT, TemplateAlignment.CENTER.toString()).trim().toUpperCase()), responseJson.optBoolean(CANCELLABLE, true), responseJson.optLong(DISMISS_INTERVAL, -1L), responseJson);
    }

    private InAppContainer containerFromJson(JSONObject responseJSON, JSONObject containerJSON, boolean isPrimary) throws JSONException, ParseException {
        InAppStyle style = this.styleFromJson(responseJSON, this.getJsonFromReferencePath(responseJSON, containerJSON.getJSONObject(STYLE).getString(REFERENCE_PATH)), WidgetType.CONTAINER, null);
        if (style == null) {
            throw new ParseException("Style could not be parsed.");
        }
        return new InAppContainer(containerJSON.getInt(ID), style, Orientation.setValue(containerJSON.getString(POSITION).trim().toUpperCase()), isPrimary, this.widgetMapForContainer(responseJSON, containerJSON.getJSONArray(WIDGETS)));
    }

    private ArrayList<Widget> widgetMapForContainer(JSONObject responseJSON, JSONArray widgetArray) throws JSONException, ParseException {
        ArrayList<Widget> widgetList = new ArrayList<Widget>();
        for (int index = 0; index < widgetArray.length(); ++index) {
            JSONObject widgetJSON = widgetArray.getJSONObject(index);
            WidgetType widgetType = WidgetType.setValue(widgetJSON.getString(TYPE).trim().toUpperCase());
            if (widgetType == WidgetType.WIDGET) {
                InAppWidget inAppWidget = this.widgetFromJson(responseJSON, this.getJsonFromReferencePath(responseJSON, widgetJSON.getString(REFERENCE_PATH)));
                widgetList.add(new Widget(widgetType, inAppWidget));
                continue;
            }
            if (widgetType != WidgetType.CONTAINER) continue;
            InAppContainer inAppContainer = this.containerFromJson(responseJSON, this.getJsonFromReferencePath(responseJSON, widgetJSON.getString(REFERENCE_PATH)), false);
            widgetList.add(new Widget(widgetType, inAppContainer));
        }
        return widgetList;
    }

    private InAppWidget widgetFromJson(JSONObject responseJson, JSONObject widgetJson) throws JSONException, ParseException {
        ViewType viewType = ViewType.setValue(widgetJson.getString(TYPE).trim().toUpperCase());
        return new InAppWidget(widgetJson.getInt(ID), viewType, this.getComponentFromJson(responseJson, this.getJsonFromReferencePath(responseJson, widgetJson.getJSONObject(COMPONENT).getString(REFERENCE_PATH)), viewType), this.actionsForWidget(responseJson, widgetJson));
    }

    private List<Action> actionsForWidget(JSONObject responseJSON, JSONObject widgetJSON) throws JSONException {
        if (!widgetJSON.has(WIDGET_ACTION)) {
            return null;
        }
        return this.actionListFromJson(widgetJSON.getJSONObject(WIDGET_ACTION), responseJSON);
    }

    private List<Action> actionListFromJson(JSONObject actionsJson, JSONObject responseJSON) throws JSONException {
        ArrayList<Action> actionList = new ArrayList<Action>();
        Iterator actionIterator = actionsJson.keys();
        while (actionIterator.hasNext()) {
            Action action = this.actionFromJson(responseJSON, this.getJsonFromReferencePath(responseJSON, actionsJson.getJSONObject((String)actionIterator.next()).getString(REFERENCE_PATH)));
            if (action == null) continue;
            actionList.add(action);
        }
        return actionList;
    }

    private Action actionFromJson(JSONObject responseJson, JSONObject actionJson) {
        try {
            ActionType actionType = ActionType.valueOf(actionJson.getString(ACTION_TYPE).trim().toUpperCase());
            switch (actionType) {
                case DISMISS: {
                    return new DismissAction(actionType);
                }
                case TRACK_DATA: {
                    return this.trackActionFromJson(actionType, responseJson, actionJson);
                }
                case NAVIGATE: {
                    return this.navigationActionFromJson(actionType, responseJson, actionJson);
                }
                case SHARE: {
                    return this.shareActionFromJson(actionType, responseJson, actionJson);
                }
                case COPY_TEXT: {
                    return this.copyActionFromJson(actionType, responseJson, actionJson);
                }
                case CALL: {
                    return this.callActionFromJson(actionType, responseJson, actionJson);
                }
                case SMS: {
                    return this.smsActionFromJson(actionType, responseJson, actionJson);
                }
                case CUSTOM_ACTION: {
                    return this.customActionFromJson(actionType, responseJson, actionJson);
                }
                case CONDITION_ACTION: {
                    return this.conditionActionFromJson(actionType, responseJson, actionJson);
                }
                case USER_INPUT: {
                    return this.userInputActionJson(actionType, responseJson, actionJson);
                }
            }
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_ResponseParser actionFromJson() : ", (Throwable)e);
        }
        return null;
    }

    private TrackAction trackActionFromJson(ActionType actionType, JSONObject responseJson, JSONObject actionJson) throws JSONException {
        return new TrackAction(actionType, DataTrackType.setValue(actionJson.getString(TRACK_TYPE).trim().toUpperCase()), actionJson.has(VALUE) ? this.getStringFromPath(responseJson, actionJson.getJSONObject(VALUE).getString(REFERENCE_PATH)) : null, this.getStringFromPath(responseJson, actionJson.getJSONObject(NAME).getString(REFERENCE_PATH)), this.dataMapForAction(responseJson, actionJson));
    }

    private NavigationAction navigationActionFromJson(ActionType actionType, JSONObject responseJson, JSONObject actionJson) throws JSONException {
        return new NavigationAction(actionType, NavigationType.valueOf(actionJson.getString(NAVIGATION_TYPE).trim().toUpperCase()), this.getStringFromPath(responseJson, actionJson.getJSONObject(VALUE).getString(REFERENCE_PATH)), this.dataMapForAction(responseJson, actionJson));
    }

    private CopyAction copyActionFromJson(ActionType actionType, JSONObject responseJson, JSONObject actionJson) throws JSONException {
        return new CopyAction(actionType, actionJson.has(MESSAGE) ? this.getStringFromPath(responseJson, actionJson.getJSONObject(MESSAGE).getString(REFERENCE_PATH)) : null, this.getStringFromPath(responseJson, actionJson.getJSONObject(VALUE).getString(REFERENCE_PATH)));
    }

    private ShareAction shareActionFromJson(ActionType actionType, JSONObject responseJson, JSONObject actionJson) throws JSONException {
        return new ShareAction(actionType, this.getStringFromPath(responseJson, actionJson.getJSONObject(VALUE).getString(REFERENCE_PATH)));
    }

    private CustomAction customActionFromJson(ActionType actionType, JSONObject responseJson, JSONObject actionJson) throws JSONException {
        return new CustomAction(actionType, this.dataMapForAction(responseJson, actionJson));
    }

    private CallAction callActionFromJson(ActionType actionType, JSONObject responseJson, JSONObject actionJson) throws JSONException {
        return new CallAction(actionType, this.getStringFromPath(responseJson, actionJson.getJSONObject(VALUE).getString(REFERENCE_PATH)));
    }

    private SmsAction smsActionFromJson(ActionType actionType, JSONObject responseJson, JSONObject actionJson) throws JSONException {
        return new SmsAction(actionType, this.getStringFromPath(responseJson, actionJson.getJSONObject(VALUE).getString(REFERENCE_PATH)), this.getStringFromPath(responseJson, actionJson.getJSONObject(MESSAGE).getString(REFERENCE_PATH)));
    }

    private ConditionAction conditionActionFromJson(ActionType actionType, JSONObject responseJson, JSONObject actionJson) throws JSONException, ParseException {
        if (!actionJson.has(CONDITIONS)) {
            throw new ParseException("Mandatory key \"conditions\" missing.");
        }
        InAppWidget widget = this.widgetFromJson(responseJson, this.getJsonFromReferencePath(responseJson, actionJson.getJSONObject(WIDGET_ID).getString(REFERENCE_PATH)));
        JSONArray conditionsArray = actionJson.getJSONArray(CONDITIONS);
        ArrayList<Condition> conditionList = new ArrayList<Condition>();
        for (int i = 0; i < conditionsArray.length(); ++i) {
            JSONObject conditionJson = conditionsArray.getJSONObject(i);
            conditionList.add(new Condition(conditionJson.getJSONObject(ATTRIBUTE), this.actionListFromReferences(conditionJson.getJSONObject(WIDGET_ACTIONS), responseJson)));
        }
        return new ConditionAction(actionType, conditionList, widget.id);
    }

    private UserInputAction userInputActionJson(ActionType actionType, JSONObject responseJson, JSONObject actionJson) throws JSONException, ParseException {
        InAppWidget widget = this.widgetFromJson(responseJson, this.getJsonFromReferencePath(responseJson, actionJson.getJSONObject(WIDGET_ID).getString(REFERENCE_PATH)));
        return new UserInputAction(actionType, UserInputType.valueOf(actionJson.getString(INPUT_TYPE).trim().toUpperCase()), widget.id, this.actionListFromReferences(actionJson.getJSONObject(WIDGET_ACTIONS), responseJson));
    }

    private List<Action> actionListFromReferences(JSONObject actionListJson, JSONObject responseJson) throws JSONException {
        ArrayList<Action> actionList = new ArrayList<Action>();
        if (actionListJson.length() == 0) {
            return actionList;
        }
        Iterator actionKeys = actionListJson.keys();
        while (actionKeys.hasNext()) {
            Action action = this.actionFromJson(responseJson, this.getJsonFromReferencePath(responseJson, actionListJson.getJSONObject((String)actionKeys.next()).getString(REFERENCE_PATH)));
            if (action == null) continue;
            actionList.add(action);
        }
        return actionList;
    }

    private InAppComponent getComponentFromJson(JSONObject responseJson, JSONObject componentJson, ViewType viewType) throws JSONException, ParseException {
        InAppStyle style = this.styleFromJson(responseJson, this.getJsonFromReferencePath(responseJson, componentJson.getJSONObject(STYLE).getString(REFERENCE_PATH)), WidgetType.WIDGET, viewType);
        if (style == null) {
            throw new ParseException("Style could not be parsed.");
        }
        if (viewType != ViewType.RATING && !componentJson.has(CONTENT)) {
            throw new ParseException("Mandatory param content missing");
        }
        return new InAppComponent(componentJson.has(CONTENT) ? this.getStringFromPath(responseJson, componentJson.getJSONObject(CONTENT).getString(REFERENCE_PATH)) : null, style);
    }

    private InAppStyle styleFromJson(JSONObject responseJson, JSONObject styleJson, WidgetType widgetType, ViewType viewType) throws JSONException, ParseException {
        InAppStyle baseStyle = new InAppStyle(styleJson.optDouble(HEIGHT, -2.0), styleJson.getDouble(WIDTH), this.marginFromJson(styleJson), this.paddingFromJson(styleJson), styleJson.getBoolean(DISPLAY));
        switch (widgetType) {
            case CONTAINER: {
                return this.containerStyleFromJson(responseJson, styleJson, baseStyle);
            }
            case WIDGET: {
                switch (viewType) {
                    case TEXT: {
                        return this.textStyleFromJson(responseJson, styleJson, baseStyle);
                    }
                    case IMAGE: {
                        return this.imageStyleFromJson(responseJson, styleJson, baseStyle);
                    }
                    case BUTTON: {
                        return this.buttonStyleFromJson(responseJson, styleJson, baseStyle);
                    }
                    case RATING: {
                        return this.ratingStyleFromJson(responseJson, styleJson, baseStyle);
                    }
                    case CLOSE_BUTTON: {
                        return this.closeStyleFromJson(responseJson, styleJson, baseStyle);
                    }
                }
            }
        }
        return null;
    }

    private ContainerStyle containerStyleFromJson(JSONObject responseJson, JSONObject styleJson, InAppStyle baseStyle) throws JSONException {
        return new ContainerStyle(baseStyle, this.borderFromJson(styleJson), this.backgroundFromJson(styleJson, responseJson), this.animationFromJson(styleJson));
    }

    private TextStyle textStyleFromJson(JSONObject responseJson, JSONObject styleJson, InAppStyle baseStyle) throws JSONException {
        return new TextStyle(baseStyle, this.fontFromJson(styleJson), this.backgroundFromJson(styleJson, responseJson), this.borderFromJson(styleJson));
    }

    private ImageStyle imageStyleFromJson(JSONObject responseJson, JSONObject styleJson, InAppStyle baseStyle) throws JSONException {
        return new ImageStyle(baseStyle, this.borderFromJson(styleJson), styleJson.getDouble(REAL_HEIGHT), styleJson.getDouble(REAL_WIDTH));
    }

    private ButtonStyle buttonStyleFromJson(JSONObject responseJson, JSONObject styleJson, InAppStyle baseStyle) throws JSONException {
        return new ButtonStyle(baseStyle, this.fontFromJson(styleJson), this.backgroundFromJson(styleJson, responseJson), this.borderFromJson(styleJson), styleJson.getInt(MINIMUM_HEIGHT));
    }

    private RatingStyle ratingStyleFromJson(JSONObject responseJson, JSONObject styleJson, InAppStyle baseStyle) throws JSONException, ParseException {
        if (!styleJson.has(RATING_STYLE)) {
            throw new ParseException("Mandatory key \"rating_style\" missing.");
        }
        JSONObject ratingStyle = styleJson.getJSONObject(RATING_STYLE);
        return new RatingStyle(baseStyle, this.borderFromJson(styleJson), this.colorFromJson(ratingStyle.getJSONObject(COLOR)), ratingStyle.getInt(NUMBER_OF_STARS), ratingStyle.getBoolean(HALF_STEP_ALLOWED), styleJson.getDouble(REAL_HEIGHT));
    }

    private CloseStyle closeStyleFromJson(JSONObject responseJson, JSONObject styleJson, InAppStyle baseStyle) throws JSONException {
        return new CloseStyle(baseStyle, styleJson.has(WIDGET_FLOAT) ? ClosePosition.setValue(styleJson.getString(WIDGET_FLOAT).trim().toUpperCase()) : ClosePosition.RIGHT);
    }

    private Font fontFromJson(JSONObject styleJSONObject) throws JSONException {
        JSONObject fontJson = styleJSONObject.getJSONObject(FONT);
        return new Font(fontJson.optString(FONT_NAME), fontJson.getInt(SIZE), fontJson.has(COLOR) ? this.colorFromJson(fontJson.getJSONObject(COLOR)) : new Color(0, 0, 0, 1.0f));
    }

    private Animation animationFromJson(JSONObject styleJSONObject) throws JSONException {
        if (!styleJSONObject.has(ANIMATION)) {
            return null;
        }
        JSONObject animationJson = styleJSONObject.getJSONObject(ANIMATION);
        return new Animation(animationJson.has(ENTRY) ? this.getEntryAnimation(animationJson.getString(ENTRY)) : -1, animationJson.has(EXIT) ? this.getExitAnimation(animationJson.getString(EXIT)) : -1);
    }

    private Background backgroundFromJson(JSONObject styleJSONObject, JSONObject responseJSON) throws JSONException {
        if (!styleJSONObject.has(BACKGROUND)) {
            return null;
        }
        JSONObject backgroundJson = styleJSONObject.getJSONObject(BACKGROUND);
        return new Background(backgroundJson.has(COLOR) ? this.colorFromJson(backgroundJson.getJSONObject(COLOR)) : null, this.contentFromBackground(backgroundJson, responseJSON));
    }

    private Border borderFromJson(JSONObject styleJSONObject) throws JSONException {
        if (styleJSONObject.has(BORDER)) {
            JSONObject borderJson = styleJSONObject.getJSONObject(BORDER);
            return new Border(borderJson.has(COLOR) ? this.colorFromJson(borderJson.getJSONObject(COLOR)) : null, borderJson.optDouble(RADIUS, 0.0), borderJson.optDouble(WIDTH, 0.0));
        }
        return null;
    }

    private Margin marginFromJson(JSONObject styleJSONObject) throws JSONException {
        if (styleJSONObject.has(MARGIN)) {
            JSONObject marginJSON = styleJSONObject.getJSONObject(MARGIN);
            return new Margin(marginJSON.optDouble(LEFT, 0.0), marginJSON.optDouble(RIGHT, 0.0), marginJSON.optDouble(TOP, 0.0), marginJSON.optDouble(BOTTOM, 0.0));
        }
        return new Margin(0.0, 0.0, 0.0, 0.0);
    }

    private Padding paddingFromJson(JSONObject styleJson) throws JSONException {
        if (styleJson.has(PADDING)) {
            JSONObject marginJSON = styleJson.getJSONObject(PADDING);
            return new Padding(marginJSON.optDouble(LEFT, 0.0), marginJSON.optDouble(RIGHT, 0.0), marginJSON.optDouble(TOP, 0.0), marginJSON.optDouble(BOTTOM, 0.0));
        }
        return new Padding(0.0, 0.0, 0.0, 0.0);
    }

    @Nullable
    private String contentFromBackground(JSONObject backgroundJSON, JSONObject responseJSON) throws JSONException {
        String contentString = null;
        if (backgroundJSON.has(IMAGE)) {
            contentString = this.getStringFromPath(responseJSON, backgroundJSON.getJSONObject(IMAGE).getString(REFERENCE_PATH));
        }
        if (TextUtils.isEmpty(contentString)) {
            contentString = null;
        }
        return contentString;
    }

    private String getStringFromPath(JSONObject responseJSON, String contentPath) throws JSONException {
        String[] pathPieces = contentPath.split("/");
        JSONObject campaignPayload = responseJSON;
        for (int i = 1; i < pathPieces.length - 1; ++i) {
            campaignPayload = campaignPayload.getJSONObject(pathPieces[i]);
        }
        return campaignPayload.getString(pathPieces[pathPieces.length - 1]);
    }

    private JSONObject getJsonFromReferencePath(JSONObject responseJSON, String contentPath) throws JSONException {
        String[] pathPieces = contentPath.split("/");
        JSONObject campaignPayload = responseJSON;
        for (int i = 1; i < pathPieces.length; ++i) {
            campaignPayload = campaignPayload.getJSONObject(pathPieces[i]);
        }
        return campaignPayload;
    }

    private int getEntryAnimation(String entryAnimation) {
        switch (entryAnimation) {
            case "SLIDE_UP": {
                return R.anim.slide_up_in;
            }
            case "SLIDE_DOWN": {
                return R.anim.slide_down_in;
            }
            case "SLIDE_LEFT": {
                return R.anim.slide_right_in;
            }
            case "SLIDE_RIGHT": {
                return R.anim.slide_left_in;
            }
            case "FADE_IN": {
                return R.anim.fade_in;
            }
        }
        return -1;
    }

    private int getExitAnimation(String exitAnimation) {
        switch (exitAnimation) {
            case "SLIDE_UP": {
                return R.anim.slide_up_out;
            }
            case "SLIDE_DOWN": {
                return R.anim.slide_down_out;
            }
            case "SLIDE_LEFT": {
                return R.anim.slide_left_out;
            }
            case "SLIDE_RIGHT": {
                return R.anim.slide_right_out;
            }
            case "FADE_OUT": {
                return R.anim.fade_out;
            }
        }
        return -1;
    }

    private Map<String, Object> dataMapForAction(JSONObject responseJson, JSONObject actionJson) throws JSONException {
        return actionJson.has(ATTR_DATA_MAP) ? MoEUtils.jsonToMap((JSONObject)this.getJsonFromReferencePath(responseJson, actionJson.getJSONObject(ATTR_DATA_MAP).getString(REFERENCE_PATH))) : new HashMap<String, Object>();
    }

    private Color colorFromJson(JSONObject colorJson) throws JSONException {
        return new Color(colorJson.getInt(COLOR_RED), colorJson.getInt(COLOR_GREEN), colorJson.getInt(COLOR_BLUE), (float)colorJson.getDouble(COLOR_ALPHA));
    }

    StatsUploadResponse statsUploadResponse(Response response) {
        if (response == null) {
            return new StatsUploadResponse(false);
        }
        return new StatsUploadResponse(response.responseCode == 200);
    }

    TestCampaignResponse parseTestCampaignResponse(Response response) {
        try {
            if (response == null) {
                return new TestCampaignResponse(false, ERROR_MESSAGE_NO_INTERNET_CONNECTION);
            }
            if (response.responseCode != 200) {
                if (response.responseCode >= 500 && response.responseCode <= 599) {
                    return new TestCampaignResponse(false, ERROR_MESSAGE_COULD_NOT_REACH_MOENGAGE_SERVER);
                }
                JSONObject errorJson = new JSONObject(response.errorMessage);
                return new TestCampaignResponse(false, errorJson.getString(ERROR));
            }
            if (MoEUtils.isEmptyString((String)response.responseBody)) {
                return new TestCampaignResponse(false);
            }
            JSONObject responseJson = new JSONObject(response.responseBody);
            if ("SELF_HANDLED".equals(responseJson.getString(TEMPLATE_TYPE))) {
                return new TestCampaignResponse(true, this.selfHandledCampaignFromJson(responseJson));
            }
            return new TestCampaignResponse(true, this.campaignPayloadFromResponse(responseJson));
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_ResponseParser parseTestCampaignResponse() : ", (Throwable)e);
            return new TestCampaignResponse(false);
        }
    }
}

