/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.repository.remote;

import android.content.Context;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.InAppEvaluator;
import com.moengage.inapp.InAppInjector;
import com.moengage.inapp.repository.InAppRepository;

public class FetchMetaTask
extends SDKTask {
    private static final String TAG = "InApp_4.2.03_FetchMetaTask";

    public FetchMetaTask(Context context) {
        super(context);
    }

    public TaskResult execute() {
        try {
            Logger.v((String)"InApp_4.2.03_FetchMetaTask execute() : Fetching InApp Meta");
            InAppEvaluator evaluator = new InAppEvaluator();
            InAppRepository repository = InAppInjector.getInstance().getInAppRepository(this.context);
            InAppController controller = InAppController.getInstance();
            if (!evaluator.isServerSyncRequired(repository.localRepository.getLastSyncTime(), MoEUtils.currentSeconds(), repository.localRepository.getApiSyncInterval(), controller.isInAppSynced())) {
                Logger.e((String)("InApp_4.2.03_FetchMetaTask execute() : Serve sync not required. Next Sync will happen at: " + MoEUtils.isoStringFromSeconds((long)repository.localRepository.getLastSyncTime())));
                return this.taskResult;
            }
            boolean response = repository.fetchInAppCampaignMeta();
            if (response) {
                repository.localRepository.deleteExpiredCampaigns();
                repository.updateCache();
                controller.onSyncSuccess(this.context);
                for (Event event : controller.getPendingTriggerEvents()) {
                    controller.tryToShowTriggerInAppIfPossible(this.context, event);
                }
            }
            controller.clearPendingEvents();
            this.taskResult.setIsSuccess(response);
            Logger.v((String)"InApp_4.2.03_FetchMetaTask execute() : Task Complete");
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_FetchMetaTask execute() : Exception ", (Throwable)e);
        }
        return this.taskResult;
    }

    public String getTaskTag() {
        return "FETCH_IN_APP_META_TASK";
    }

    public boolean isSynchronous() {
        return true;
    }
}

