/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.repository.remote;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.RestUtils;
import com.moengage.core.rest.Request;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.rest.Response;
import com.moengage.core.rest.RestClient;
import com.moengage.core.utils.JsonBuilder;
import com.moengage.inapp.model.CampaignRequest;
import com.moengage.inapp.model.InAppMetaRequest;
import com.moengage.inapp.model.StatsUploadRequest;
import org.json.JSONArray;
import org.json.JSONObject;

class ApiManager {
    private static final String TAG = "InApp_4.2.03_ApiManager";
    private static final String BASE_PATH = "v3/campaigns/inapp/";
    private static final String PATH_PARAM_LIVE = "live";
    private static final String PATH_PARAM_TEST = "test";
    private static final String PATH_PARAM_STATS = "live/stats";
    private static final String QUERY_PARAM_SDK_VERSION = "sdk_ver";
    private static final String QUERY_PARAM_OS = "os";
    private static final String QUERY_PARAM_UNIQUE_ID = "unique_id";
    private static final String HEADER_KEY = "MOE-INAPP-BATCH-ID";
    private static final String TRIGGER_EVENT = "event";
    private static final String EVENT_NAME = "name";
    private static final String TIME = "time";
    private static final String ATTRIBUTES = "attributes";
    private static final String SCREEN_NAME = "screen_name";
    private static final String CONTEXTS = "contexts";
    private static final String STATS = "stats";

    ApiManager() {
    }

    @Nullable
    Response fetchCampaignMeta(InAppMetaRequest requestMeta) {
        try {
            Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath(BASE_PATH).appendEncodedPath(PATH_PARAM_LIVE).appendQueryParameter(QUERY_PARAM_UNIQUE_ID, requestMeta.uniqueId).appendQueryParameter(QUERY_PARAM_SDK_VERSION, String.valueOf(requestMeta.sdkVersion)).appendQueryParameter(QUERY_PARAM_OS, requestMeta.platform);
            JSONObject requestBody = new JSONObject();
            requestBody.put("query_params", (Object)requestMeta.defaultParams.build());
            Request request = RestUtils.getBaseRequestBuilder((Uri)uriBuilder.build(), (RequestBuilder.RequestType)RequestBuilder.RequestType.POST, (String)requestMeta.appId).addBody(requestBody).build();
            RestClient restClient = new RestClient(request);
            return restClient.executeRequest();
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_ApiManager fetchCampaignMeta() : Exception: ", (Throwable)e);
            return null;
        }
    }

    @Nullable
    Response fetchCampaignPayload(CampaignRequest campaignRequest) {
        try {
            Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath(BASE_PATH).appendEncodedPath(PATH_PARAM_LIVE).appendEncodedPath(campaignRequest.campaignId).appendQueryParameter(QUERY_PARAM_UNIQUE_ID, campaignRequest.uniqueId).appendQueryParameter(QUERY_PARAM_SDK_VERSION, String.valueOf(campaignRequest.sdkVersion)).appendQueryParameter(QUERY_PARAM_OS, campaignRequest.platform);
            JsonBuilder requestBodyBuilder = new JsonBuilder();
            if (campaignRequest.triggerMeta != null) {
                JsonBuilder eventBuilder = new JsonBuilder();
                eventBuilder.putString(EVENT_NAME, campaignRequest.triggerMeta.eventName).putString(TIME, campaignRequest.triggerMeta.timeStamp).putJsonObject(ATTRIBUTES, campaignRequest.triggerMeta.attributes);
                requestBodyBuilder.putJsonObject(TRIGGER_EVENT, eventBuilder.build());
            }
            requestBodyBuilder.putJsonObject("query_params", campaignRequest.defaultParams.build());
            if (!MoEUtils.isEmptyString((String)campaignRequest.screenName)) {
                requestBodyBuilder.putString(SCREEN_NAME, campaignRequest.screenName);
            }
            if (campaignRequest.contextList != null && !campaignRequest.contextList.isEmpty()) {
                JSONArray contextArray = new JSONArray();
                for (String context : campaignRequest.contextList) {
                    contextArray.put((Object)context);
                }
                requestBodyBuilder.putJsonArray(CONTEXTS, contextArray);
            }
            Request request = RestUtils.getBaseRequestBuilder((Uri)uriBuilder.build(), (RequestBuilder.RequestType)RequestBuilder.RequestType.POST, (String)campaignRequest.appId).addBody(requestBodyBuilder.build()).build();
            RestClient restClient = new RestClient(request);
            return restClient.executeRequest();
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_ApiManager fetchCampaignPayload() : Exception ", (Throwable)e);
            return null;
        }
    }

    @Nullable
    Response fetchTestCampaign(CampaignRequest campaignRequest) {
        try {
            Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath(BASE_PATH).appendEncodedPath(PATH_PARAM_TEST).appendEncodedPath(campaignRequest.campaignId).appendQueryParameter(QUERY_PARAM_SDK_VERSION, String.valueOf(campaignRequest.sdkVersion)).appendQueryParameter(QUERY_PARAM_OS, campaignRequest.platform).appendQueryParameter(QUERY_PARAM_UNIQUE_ID, campaignRequest.uniqueId);
            RequestBuilder requestBuilder = RestUtils.getBaseRequestBuilder((Uri)uriBuilder.build(), (RequestBuilder.RequestType)RequestBuilder.RequestType.GET, (String)campaignRequest.appId);
            RestClient restClient = new RestClient(requestBuilder.build());
            return restClient.executeRequest();
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_ApiManager fetchTestCampaign() : Exception ", (Throwable)e);
            return null;
        }
    }

    @Nullable
    Response uploadStats(StatsUploadRequest request) {
        try {
            Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath(BASE_PATH).appendEncodedPath(PATH_PARAM_STATS).appendQueryParameter(QUERY_PARAM_SDK_VERSION, String.valueOf(request.sdkVersion)).appendQueryParameter(QUERY_PARAM_OS, request.platform).appendQueryParameter(QUERY_PARAM_UNIQUE_ID, request.uniqueId);
            JSONObject requestBody = new JSONObject();
            requestBody.put(STATS, (Object)request.stat.statsJson);
            requestBody.put("query_params", (Object)request.defaultParams.build());
            RequestBuilder requestBuilder = RestUtils.getBaseRequestBuilder((Uri)uriBuilder.build(), (RequestBuilder.RequestType)RequestBuilder.RequestType.POST, (String)request.appId).addBody(requestBody).addHeader(HEADER_KEY, request.stat.requestId);
            RestClient restClient = new RestClient(requestBuilder.build());
            return restClient.executeRequest();
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_ApiManager uploadStats() : ", (Throwable)e);
            return null;
        }
    }
}

