/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.repository;

import android.content.ContentValues;
import android.database.Cursor;
import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.inapp.model.StatModel;
import com.moengage.inapp.model.meta.CampaignMeta;
import com.moengage.inapp.model.meta.CampaignState;
import com.moengage.inapp.model.meta.InAppCampaign;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class MarshallingHelper {
    private static final String TAG = "InApp_4.2.03_MarshallingHelper";

    MarshallingHelper() {
    }

    ContentValues campaignToContentValues(InAppCampaign inAppCampaign) {
        ContentValues contentValue = new ContentValues();
        if (inAppCampaign._id != -1L) {
            contentValue.put("_id", Long.valueOf(inAppCampaign._id));
        }
        contentValue.put("campaign_id", inAppCampaign.campaignMeta.campaignId);
        contentValue.put("type", inAppCampaign.campaignType);
        contentValue.put("status", inAppCampaign.status);
        contentValue.put("state", CampaignState.toJson(inAppCampaign.campaignState).toString());
        contentValue.put("priority", Long.valueOf(inAppCampaign.campaignMeta.deliveryControl.priority));
        contentValue.put("last_updated_time", Long.valueOf(inAppCampaign.campaignMeta.lastUpdatedTime));
        contentValue.put("template_type", inAppCampaign.campaignMeta.templateType);
        contentValue.put("deletion_time", Long.valueOf(inAppCampaign.deletionTime));
        contentValue.put("last_received_time", Long.valueOf(inAppCampaign.lastReceivedTime));
        contentValue.put("campaign_meta", CampaignMeta.toJson(inAppCampaign.campaignMeta).toString());
        return contentValue;
    }

    ContentValues campaignStateToContentValues(CampaignState campaignState) {
        ContentValues contentValue = new ContentValues();
        contentValue.put("state", CampaignState.toJson(campaignState).toString());
        return contentValue;
    }

    @Nullable
    ArrayList<InAppCampaign> campaignListFromCursor(Cursor cursor) {
        if (cursor == null || !cursor.moveToFirst()) {
            return null;
        }
        ArrayList<InAppCampaign> inAppCampaigns = new ArrayList<InAppCampaign>();
        do {
            try {
                inAppCampaigns.add(this.inAppCampaignFromCursor(cursor));
            }
            catch (Exception e) {
                Logger.e((String)"InApp_4.2.03_MarshallingHelper campaignListFromCursor() : ", (Throwable)e);
            }
        } while (cursor.moveToNext());
        return inAppCampaigns;
    }

    InAppCampaign inAppCampaignFromCursor(Cursor cursor) throws JSONException {
        return new InAppCampaign(cursor.getLong(0), cursor.getString(2), cursor.getString(3), cursor.getLong(8), cursor.getLong(9), this.cursorToCampaignMeta(cursor), this.cursorToCampaignState(cursor));
    }

    private CampaignMeta cursorToCampaignMeta(Cursor cursor) throws JSONException {
        String campaignMeta = cursor.getString(10);
        if (MoEUtils.isEmptyString((String)campaignMeta)) {
            String campaignId = cursor.getString(1);
            return new CampaignMeta(campaignId, null, 0L, 0L, null, null, null, null);
        }
        return CampaignMeta.fromJson(new JSONObject(campaignMeta));
    }

    private CampaignState cursorToCampaignState(Cursor cursor) throws JSONException {
        String campaignState = cursor.getString(4);
        return CampaignState.fromJson(new JSONObject(campaignState));
    }

    @Nullable
    HashSet<String> campaignIdsFromCursor(Cursor cursor) {
        if (cursor == null || !cursor.moveToFirst()) {
            return null;
        }
        HashSet<String> campaignIds = new HashSet<String>();
        do {
            campaignIds.add(cursor.getString(0));
        } while (cursor.moveToNext());
        return campaignIds;
    }

    ContentValues statToContentValues(StatModel stat) {
        ContentValues values = new ContentValues();
        if (stat._id != -1L) {
            values.put("_id", Long.valueOf(stat._id));
        }
        values.put("timestamp", Long.valueOf(stat.timestamp));
        values.put("request_id", stat.requestId);
        values.put("payload", stat.statsJson.toString());
        return values;
    }

    StatModel statFromCursor(Cursor cursor) throws JSONException {
        return new StatModel(cursor.getLong(0), cursor.getLong(1), cursor.getString(2), new JSONObject(cursor.getString(3)));
    }

    @Nullable
    Map<String, InAppCampaign> campaignMapFromCursor(Cursor cursor) {
        if (cursor == null || !cursor.moveToFirst()) {
            return null;
        }
        HashMap<String, InAppCampaign> inAppCampaigns = new HashMap<String, InAppCampaign>();
        do {
            try {
                InAppCampaign campaign = this.inAppCampaignFromCursor(cursor);
                if (campaign == null) continue;
                inAppCampaigns.put(campaign.campaignMeta.campaignId, campaign);
            }
            catch (Exception e) {
                Logger.e((String)"InApp_4.2.03_MarshallingHelper campaignListFromCursor() : ", (Throwable)e);
            }
        } while (cursor.moveToNext());
        return inAppCampaigns;
    }
}

