/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.repository;

import android.content.Context;
import androidx.annotation.Nullable;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.MoEUtils;
import com.moengage.core.SdkConfig;
import com.moengage.core.model.BaseRequest;
import com.moengage.inapp.model.InAppGlobalState;
import com.moengage.inapp.model.StatModel;
import com.moengage.inapp.model.meta.CampaignState;
import com.moengage.inapp.model.meta.InAppCampaign;
import com.moengage.inapp.repository.InAppDAO;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class LocalRepository {
    private ConfigurationProvider provider;
    private InAppDAO dao;

    public LocalRepository(Context context) {
        this.provider = ConfigurationProvider.getInstance((Context)context);
        this.dao = new InAppDAO(context);
    }

    void saveApiSyncInterval(long syncInterval) {
        this.dao.saveApiSyncInterval(syncInterval);
    }

    public long getApiSyncInterval() {
        return this.provider.getInAppApiSyncDelay();
    }

    void saveLastApiSyncTime(long nextSyncTime) {
        this.dao.saveLastSyncTime(nextSyncTime);
    }

    void saveGlobalDelay(long globalDelay) {
        this.dao.saveGlobalDelay(globalDelay);
    }

    void addOrUpdateInApp(List<InAppCampaign> campaignMetaList) {
        this.dao.addOrUpdateCampaign(campaignMetaList);
    }

    public InAppGlobalState getGlobalState() {
        return new InAppGlobalState(this.provider.getInAppGlobalDelay(), this.provider.getLastInAppShownTime(), MoEUtils.currentSeconds());
    }

    public void deleteExpiredCampaigns() {
        this.dao.deleteExpiredCampaigns();
        this.dao.deleteExpiredImages();
    }

    void clearData() {
        this.dao.clearData();
    }

    @Nullable
    public List<String> getBlockedActivityList() {
        return SdkConfig.getConfig().inAppOptOutList;
    }

    @Nullable
    List<InAppCampaign> generalCampaigns() {
        return this.dao.getGeneralCampaigns();
    }

    @Nullable
    Set<String> primaryTriggerEvents() {
        return this.dao.getPrimaryTriggerEvents();
    }

    @Nullable
    List<InAppCampaign> selfHandledCampaign() {
        return this.dao.selfHandledCampaigns();
    }

    public long getLastSyncTime() {
        return this.provider.getLastInAppSyncTime();
    }

    public BaseRequest baseRequest() throws JSONException {
        return this.dao.baseRequest();
    }

    public List<InAppCampaign> getCampaignsForEvent(String eventName) {
        return this.dao.getCampaignsForEvent(eventName);
    }

    public int updateCampaignState(CampaignState state, String campaignId) {
        return this.dao.updateStateForCampaign(state, campaignId);
    }

    public void updateLastShowTime(long time) {
        this.dao.updateLastInAppShowTime(time);
    }

    @Nullable
    public List<InAppCampaign> getAllActiveCampaigns() {
        return this.dao.getActiveCampaigns();
    }

    public InAppCampaign getCampaignById(String campaignId) {
        return this.dao.getCampaignFromId(campaignId);
    }

    @Nullable
    public Map<String, InAppCampaign> embeddedCampaign() {
        return this.dao.getEmbeddedCampaigns();
    }

    @Nullable
    public List<StatModel> getStats(int batchSize) {
        return this.dao.getStats(batchSize);
    }

    @Nullable
    public void deleteStatById(StatModel stat) {
        this.dao.deleteStatById(stat);
    }

    public void writeStats(JSONObject stats) {
        this.dao.writeStats(new StatModel(MoEUtils.currentSeconds(), MoEUtils.getRequestId(), stats));
    }
}

