/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.repository;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.SdkConfig;
import com.moengage.inapp.StatsLogger;
import com.moengage.inapp.model.CampaignPayload;
import com.moengage.inapp.model.CampaignRequest;
import com.moengage.inapp.model.InAppCampaignResponse;
import com.moengage.inapp.model.InAppMetaRequest;
import com.moengage.inapp.model.InAppMetaResponse;
import com.moengage.inapp.model.TestCampaignResponse;
import com.moengage.inapp.repository.InAppCache;
import com.moengage.inapp.repository.LocalRepository;
import com.moengage.inapp.repository.remote.RemoteRepository;

public class InAppRepository {
    private static final String TAG = "InApp_4.2.03_InAppRepository";
    public final LocalRepository localRepository;
    public final RemoteRepository remoteRepository;
    public final InAppCache cache;
    private final Object syncObj = new Object();

    public InAppRepository(LocalRepository localRepository, RemoteRepository remoteRepository, InAppCache inAppCache) {
        this.localRepository = localRepository;
        this.remoteRepository = remoteRepository;
        this.cache = inAppCache;
    }

    @WorkerThread
    public boolean fetchInAppCampaignMeta() {
        try {
            Logger.v((String)"InApp_4.2.03_InAppRepository fetchCampaignMeta() : Fetching in-app campaign meta");
            InAppMetaRequest request = new InAppMetaRequest(this.localRepository.baseRequest());
            InAppMetaResponse response = this.remoteRepository.fetchCampaignMeta(request);
            Logger.v((String)("InApp_4.2.03_InAppRepository fetchInAppCampaignMeta() : Sync Success: " + response.isSyncSuccess));
            Logger.v((String)("InApp_4.2.03_InAppRepository fetchInAppCampaignMeta() : Sync Interval: " + response.syncInterval));
            Logger.v((String)("InApp_4.2.03_InAppRepository fetchInAppCampaignMeta() : Global Delay: " + response.globalDelay));
            long currentTime = MoEUtils.currentSeconds();
            if (!response.isSyncSuccess) {
                return false;
            }
            this.localRepository.saveLastApiSyncTime(currentTime);
            this.localRepository.addOrUpdateInApp(response.campaignMetaList);
            if (response.syncInterval > 0L) {
                this.localRepository.saveApiSyncInterval(response.syncInterval);
            }
            if (response.globalDelay >= 0L) {
                this.localRepository.saveGlobalDelay(response.globalDelay);
            }
            return true;
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_InAppRepository fetchCampaignMeta() : Exception ", (Throwable)e);
            return false;
        }
    }

    @Nullable
    @WorkerThread
    public CampaignPayload fetchCampaignPayload(CampaignRequest request, boolean isPersistent) {
        try {
            Logger.v((String)"InApp_4.2.03_InAppRepository fetchCampaignPayload() : Will try to fetch campaign payload.");
            InAppCampaignResponse response = this.remoteRepository.fetchCampaignPayload(request);
            if (!response.isSuccess) {
                if (response.hasParsingException) {
                    StatsLogger.getInstance().updateStatForCampaign(request.campaignId, MoEUtils.currentISOTime(), "DLV_MAND_PARM_MIS");
                }
                if (response.responseCode != 409 && response.responseCode != 200) {
                    StatsLogger.getInstance().updateStatForCampaign(request.campaignId, MoEUtils.currentISOTime(), "DLV_API_FLR");
                }
                return null;
            }
            if (response.campaignPayload != null && response.campaignPayload.primaryWidget == -1 && !isPersistent) {
                Logger.e((String)"InApp_4.2.03_InAppRepository fetchCampaignPayload() : Primary widget missing for a campaign, which isn't persistent. Cannot show campaign. ");
                return null;
            }
            return response.campaignPayload;
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_InAppRepository fetchCampaignPayload() : Exception ", (Throwable)e);
            return null;
        }
    }

    public boolean isLifeCycleCallbackOptedOut() {
        return SdkConfig.getConfig().isLifecycleInAppOptedOut;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void onLogout(Context context) {
        StatsLogger.getInstance().writeStatsToStorage(context);
        this.uploadStats();
        this.localRepository.clearData();
        this.updateCache();
    }

    public void updateCache() {
        this.cache.updateCache(this.localRepository);
    }

    @WorkerThread
    @Nullable
    public TestCampaignResponse fetchTestCampaignPayload(String campaignId) {
        try {
            return this.remoteRepository.fetchTestCampaign(new CampaignRequest(this.localRepository.baseRequest(), campaignId));
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_InAppRepository fetchTestCampaignPayload() : Exception ", (Throwable)e);
            return null;
        }
    }

    @Nullable
    @WorkerThread
    public CampaignPayload fetchSelfHandledPayload(CampaignRequest request) {
        InAppCampaignResponse response = this.remoteRepository.fetchSelfHandledCampaign(request);
        if (response.isSuccess) {
            return response.campaignPayload;
        }
        if (response.hasParsingException) {
            StatsLogger.getInstance().updateStatForCampaign(request.campaignId, MoEUtils.currentISOTime(), "DLV_MAND_PARM_MIS");
        }
        if (response.responseCode != 409 && response.responseCode != 200) {
            StatsLogger.getInstance().updateStatForCampaign(request.campaignId, MoEUtils.currentISOTime(), "DLV_API_FLR");
        }
        return null;
    }

    public void uploadStats() {
    }
}

