/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.repository;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import androidx.annotation.Nullable;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEFileManager;
import com.moengage.core.MoEUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;

public class InAppImageManager {
    private MoEFileManager fileManager;
    private static final String TAG = "InAppImageManager";

    public InAppImageManager(Context context) {
        this.fileManager = new MoEFileManager(context);
    }

    @Nullable
    public Bitmap getImageFromUrl(Context context, String url, String campaignId) {
        try {
            if (this.isRemoteResource(url)) {
                return this.getRemoteImage(url, campaignId);
            }
            return this.getBundledImageIfPresent(context, url);
        }
        catch (Exception e) {
            Logger.e((String)"InAppImageManager getImageFromUrl() : ", (Throwable)e);
            return null;
        }
    }

    public void deleteImagesForCampaignIds(Set<String> campaignIdList) {
        if (campaignIdList == null) {
            return;
        }
        for (String campaignId : campaignIdList) {
            this.fileManager.deleteFolder(campaignId);
        }
    }

    private Bitmap getRemoteImage(String imageURI, String campaignId) throws NoSuchAlgorithmException {
        String fileName = this.getMd5FromString(imageURI);
        if (this.fileManager.fileExistsInDirectory(campaignId, fileName)) {
            return BitmapFactory.decodeFile((String)this.fileManager.getPathForFile(campaignId, fileName));
        }
        Bitmap bitmap = MoEHelperUtils.downloadImageBitmap((String)imageURI);
        if (bitmap == null) {
            return null;
        }
        this.fileManager.saveImageFile(campaignId, fileName, bitmap);
        return bitmap;
    }

    private Bitmap getBundledImageIfPresent(Context context, String imageName) {
        int res = context.getResources().getIdentifier(imageName, "drawable", context.getPackageName());
        if (res == 0) {
            return null;
        }
        return BitmapFactory.decodeResource((Resources)context.getResources(), (int)res);
    }

    private boolean isRemoteResource(String imageUrl) {
        return imageUrl.startsWith("https://") || imageUrl.startsWith("http://");
    }

    private String getMd5FromString(String imageUrl) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(imageUrl.getBytes());
        return MoEUtils.bytesToHex((byte[])messageDigest.digest());
    }

    @Nullable
    public File getGifFromUrl(String url, String campaignId) {
        try {
            String fileName = this.getMd5FromString(url) + ".gif";
            if (this.fileManager.fileExistsInDirectory(campaignId, fileName)) {
                return this.fileManager.getFileByName(campaignId, fileName);
            }
            InputStream inputStream = new URL(url).openStream();
            return this.fileManager.saveGif(campaignId, fileName, inputStream);
        }
        catch (Exception e) {
            Logger.e((String)"InAppImageManager getGifFromUrl() : ", (Throwable)e);
            return null;
        }
    }
}

