/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.repository;

import android.content.ContentProviderOperation;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.moe.pushlibrary.providers.MoEDataContract;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.RestUtils;
import com.moengage.core.model.BaseRequest;
import com.moengage.inapp.model.StatModel;
import com.moengage.inapp.model.meta.CampaignState;
import com.moengage.inapp.model.meta.InAppCampaign;
import com.moengage.inapp.repository.InAppImageManager;
import com.moengage.inapp.repository.MarshallingHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;

final class InAppDAO {
    private Context context;
    private static final String TAG = "InAppDAO";
    private MarshallingHelper marshallingHelper;
    private Uri campaignContentUri;
    private Uri statsContentUri;

    InAppDAO(Context context) {
        this.context = context;
        this.marshallingHelper = new MarshallingHelper();
        this.campaignContentUri = MoEDataContract.InAppV3Entity.getContentUri((Context)context);
        this.statsContentUri = MoEDataContract.InAppStatsEntity.getContentUri((Context)context);
    }

    void addOrUpdateCampaign(List<InAppCampaign> campaignList) {
        try {
            Map<String, InAppCampaign> storedCampaigns = this.getStoredCampaigns();
            ArrayList<ContentProviderOperation> addOperation = new ArrayList<ContentProviderOperation>();
            ArrayList<ContentProviderOperation> updateOperation = new ArrayList<ContentProviderOperation>();
            if (storedCampaigns == null) {
                for (InAppCampaign inAppCampaign : campaignList) {
                    addOperation.add(ContentProviderOperation.newInsert((Uri)this.campaignContentUri).withValues(this.marshallingHelper.campaignToContentValues(inAppCampaign)).build());
                }
            } else {
                for (InAppCampaign inAppCampaign : campaignList) {
                    InAppCampaign inAppCampaign2 = storedCampaigns.get(inAppCampaign.campaignMeta.campaignId);
                    if (inAppCampaign2 != null) {
                        inAppCampaign._id = inAppCampaign2._id;
                        inAppCampaign.campaignState = inAppCampaign2.campaignState;
                        updateOperation.add(ContentProviderOperation.newUpdate((Uri)this.campaignContentUri.buildUpon().appendPath(String.valueOf(inAppCampaign._id)).build()).withValues(this.marshallingHelper.campaignToContentValues(inAppCampaign)).build());
                        storedCampaigns.remove(inAppCampaign2.campaignMeta.campaignId);
                        continue;
                    }
                    addOperation.add(ContentProviderOperation.newInsert((Uri)this.campaignContentUri).withValues(this.marshallingHelper.campaignToContentValues(inAppCampaign)).build());
                }
                for (Map.Entry entry : storedCampaigns.entrySet()) {
                    InAppCampaign campaign = (InAppCampaign)entry.getValue();
                    campaign.status = "IN_ACTIVE";
                    updateOperation.add(ContentProviderOperation.newUpdate((Uri)this.campaignContentUri.buildUpon().appendPath(String.valueOf(campaign._id)).build()).withValues(this.marshallingHelper.campaignToContentValues(campaign)).build());
                }
            }
            if (!updateOperation.isEmpty()) {
                this.context.getContentResolver().applyBatch(MoEDataContract.getAuthority((Context)this.context), updateOperation);
            }
            if (!addOperation.isEmpty()) {
                this.context.getContentResolver().applyBatch(MoEDataContract.getAuthority((Context)this.context), addOperation);
            }
        }
        catch (Exception e) {
            Logger.e((String)"InAppDAO addOrUpdateCampaign() : ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Map<String, InAppCampaign> getStoredCampaigns() {
        block10: {
            HashMap<String, InAppCampaign> hashMap;
            Cursor cursor = null;
            try {
                HashMap<String, InAppCampaign> campaignsMap = new HashMap<String, InAppCampaign>();
                cursor = this.context.getContentResolver().query(this.campaignContentUri, MoEDataContract.InAppV3Entity.PROJECTION, null, null, null);
                if (cursor == null || !cursor.moveToFirst()) {
                    Map<String, InAppCampaign> map = null;
                    this.closeCursor(cursor);
                    return map;
                }
                do {
                    try {
                        InAppCampaign campaign = this.marshallingHelper.inAppCampaignFromCursor(cursor);
                        if (campaign == null) continue;
                        campaignsMap.put(campaign.campaignMeta.campaignId, campaign);
                    }
                    catch (Exception e) {
                        Logger.e((String)"InAppDAO campaignListFromCursor() : ", (Throwable)e);
                    }
                } while (cursor.moveToNext());
                hashMap = campaignsMap;
                this.closeCursor(cursor);
            }
            catch (Exception e) {
                Logger.e((String)"InAppDAO getStoredCampaigns() : ", (Throwable)e);
                break block10;
            }
            finally {
                this.closeCursor(cursor);
            }
            return hashMap;
        }
        return null;
    }

    @Nullable
    @WorkerThread
    List<InAppCampaign> getTriggerCampaigns() {
        Cursor cursor = null;
        try {
            cursor = this.context.getContentResolver().query(this.campaignContentUri, MoEDataContract.InAppV3Entity.PROJECTION, "status = ?  AND type = ? ", new String[]{"ACTIVE", "smart"}, "priority DESC, last_updated_time DESC");
            ArrayList<InAppCampaign> arrayList = this.marshallingHelper.campaignListFromCursor(cursor);
            this.closeCursor(cursor);
            return arrayList;
        }
        catch (Exception e) {
            Logger.e((String)"InAppDAO getTriggerCampaigns() : ", (Throwable)e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return null;
    }

    @Nullable
    Map<String, InAppCampaign> getEmbeddedCampaigns() {
        Cursor cursor = null;
        try {
            cursor = this.context.getContentResolver().query(this.campaignContentUri, MoEDataContract.InAppV3Entity.PROJECTION, "status = ?  AND type = ?  AND template_type = ? ", new String[]{"ACTIVE", "general", "EMBEDDED"}, "priority DESC, last_updated_time DESC");
            Map<String, InAppCampaign> map = this.marshallingHelper.campaignMapFromCursor(cursor);
            this.closeCursor(cursor);
            return map;
        }
        catch (Exception e) {
            Logger.e((String)"InAppDAO getEmbeddedCampaigns() : ", (Throwable)e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return null;
    }

    @Nullable
    List<InAppCampaign> selfHandledCampaigns() {
        Cursor cursor = null;
        try {
            cursor = this.context.getContentResolver().query(this.campaignContentUri, MoEDataContract.InAppV3Entity.PROJECTION, "status = ?  AND type = ?  AND template_type = ? ", new String[]{"ACTIVE", "general", "SELF_HANDLED"}, "priority DESC, last_updated_time DESC");
            ArrayList<InAppCampaign> arrayList = this.marshallingHelper.campaignListFromCursor(cursor);
            this.closeCursor(cursor);
            return arrayList;
        }
        catch (Exception e) {
            Logger.e((String)"InAppDAO selfHandledCampaigns() : ", (Throwable)e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return null;
    }

    @Nullable
    List<InAppCampaign> getGeneralCampaigns() {
        Cursor cursor = null;
        try {
            cursor = this.context.getContentResolver().query(this.campaignContentUri, MoEDataContract.InAppV3Entity.PROJECTION, "status = ?  AND type = ?  AND template_type IN ( ?, ? ) ", new String[]{"ACTIVE", "general", "POP_UP", "FULL_SCREEN"}, "priority DESC, last_updated_time DESC");
            ArrayList<InAppCampaign> arrayList = this.marshallingHelper.campaignListFromCursor(cursor);
            this.closeCursor(cursor);
            return arrayList;
        }
        catch (Exception e) {
            Logger.e((String)"InAppDAO selfHandledCampaigns() : ", (Throwable)e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    InAppCampaign getCampaignFromId(String campaignId) {
        Cursor cursor = null;
        try {
            cursor = this.context.getContentResolver().query(this.campaignContentUri, MoEDataContract.InAppV3Entity.PROJECTION, "campaign_id = ? ", new String[]{campaignId}, null);
            if (cursor != null && cursor.moveToFirst()) {
                InAppCampaign inAppCampaign = this.marshallingHelper.inAppCampaignFromCursor(cursor);
                this.closeCursor(cursor);
                return inAppCampaign;
            }
            this.closeCursor(cursor);
        }
        catch (Exception e) {
            Logger.e((String)"InAppDAO getCampaignFromId() : ", (Throwable)e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return null;
    }

    int updateStateForCampaign(CampaignState campaignState, String campaignId) {
        int updateCount = -1;
        try {
            Logger.v((String)("InAppDAO updateStateForCampaign() : Updating campaign state for campaign id: " + campaignId));
            updateCount = this.context.getContentResolver().update(this.campaignContentUri, this.marshallingHelper.campaignStateToContentValues(campaignState), "campaign_id = ? ", new String[]{campaignId});
            if (updateCount < 0) {
                Logger.v((String)("InAppDAO updateStateForCampaign() : update failed might not exist. Campaign Id: " + campaignId));
            } else {
                Logger.v((String)("InAppDAO updateStateForCampaign() : Campaign state updated. Campaign Id: " + campaignId));
            }
        }
        catch (Exception e) {
            Logger.e((String)"InAppDAO updateStateForCampaign() : ", (Throwable)e);
        }
        return updateCount;
    }

    void saveApiSyncInterval(long syncDelay) {
        ConfigurationProvider.getInstance((Context)this.context).saveInAppApiSyncDelay(syncDelay);
    }

    void updateLastInAppShowTime(long showTime) {
        ConfigurationProvider.getInstance((Context)this.context).setLastInAppShownTime(showTime);
    }

    void saveLastSyncTime(long nextSyncTime) {
        ConfigurationProvider.getInstance((Context)this.context).saveLastInAppSyncTime(nextSyncTime);
    }

    void saveGlobalDelay(long globalDelay) {
        ConfigurationProvider.getInstance((Context)this.context).saveInAppGlobalDelay(globalDelay);
    }

    void deleteExpiredCampaigns() {
        try {
            int rows = this.context.getContentResolver().delete(this.campaignContentUri, "deletion_time < ? ", new String[]{String.valueOf(MoEUtils.currentSeconds())});
            Logger.v((String)("InAppDAOdeleteExpiredCampaigns(): Number of device triggers records deleted: " + rows));
        }
        catch (Exception e) {
            Logger.e((String)"InAppDAO deleteExpiredCampaigns() : ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Set<String> campaignsEligibleForDeletion() {
        Cursor cursor = null;
        try {
            MarshallingHelper helper = new MarshallingHelper();
            cursor = this.context.getContentResolver().query(this.campaignContentUri, new String[]{"campaign_id"}, "deletion_time < ? ", new String[]{String.valueOf(MoEUtils.currentSeconds())}, null);
            HashSet<String> hashSet = helper.campaignIdsFromCursor(cursor);
            this.closeCursor(cursor);
            return hashSet;
        }
        catch (Exception e) {
            Logger.e((String)"InAppDAO campaignsEligibleForDeletion() : ", (Throwable)e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return null;
    }

    private void closeCursor(Cursor cursor) {
        if (cursor != null) {
            cursor.close();
        }
    }

    void clearData() {
        new InAppImageManager(this.context).deleteImagesForCampaignIds(this.getAllCampaignIds());
        this.context.getContentResolver().delete(MoEDataContract.InAppV3Entity.getContentUri((Context)this.context), null, null);
        this.saveLastSyncTime(0L);
        this.updateLastInAppShowTime(0L);
        this.deleteAllStats();
    }

    void deleteExpiredImages() {
        new InAppImageManager(this.context).deleteImagesForCampaignIds(this.campaignsEligibleForDeletion());
    }

    BaseRequest baseRequest() throws JSONException {
        return RestUtils.getBaseRequest((Context)this.context);
    }

    Set<String> getPrimaryTriggerEvents() {
        HashSet<String> triggerEventSet = new HashSet<String>();
        try {
            List<InAppCampaign> triggerCampaigns = this.getTriggerCampaigns();
            if (triggerCampaigns != null) {
                for (InAppCampaign campaign : triggerCampaigns) {
                    triggerEventSet.add(campaign.campaignMeta.trigger.primaryCondition.eventName);
                }
            }
        }
        catch (Exception e) {
            Logger.e((String)"InAppDAO getPrimaryTriggerEvents() : Exception ", (Throwable)e);
        }
        return triggerEventSet;
    }

    List<InAppCampaign> getCampaignsForEvent(String eventName) {
        ArrayList<InAppCampaign> campaigns = new ArrayList<InAppCampaign>();
        try {
            List<InAppCampaign> triggerCampaigns = this.getTriggerCampaigns();
            if (triggerCampaigns != null) {
                for (InAppCampaign campaign : triggerCampaigns) {
                    if (!eventName.equals(campaign.campaignMeta.trigger.primaryCondition.eventName)) continue;
                    campaigns.add(campaign);
                }
            }
        }
        catch (Exception e) {
            Logger.e((String)"InAppDAO getCampaignsForEvent() : ", (Throwable)e);
        }
        return campaigns;
    }

    List<InAppCampaign> getActiveCampaigns() {
        Cursor cursor = null;
        try {
            cursor = this.context.getContentResolver().query(this.campaignContentUri, MoEDataContract.InAppV3Entity.PROJECTION, "status = ? ", new String[]{"ACTIVE"}, "priority DESC, last_updated_time DESC");
            ArrayList<InAppCampaign> arrayList = this.marshallingHelper.campaignListFromCursor(cursor);
            this.closeCursor(cursor);
            return arrayList;
        }
        catch (Exception e) {
            Logger.e((String)"InAppDAO selfHandledCampaigns() : ", (Throwable)e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Set<String> getAllCampaignIds() {
        Cursor cursor = null;
        try {
            MarshallingHelper helper = new MarshallingHelper();
            cursor = this.context.getContentResolver().query(this.campaignContentUri, new String[]{"campaign_id"}, null, null, null);
            HashSet<String> hashSet = helper.campaignIdsFromCursor(cursor);
            this.closeCursor(cursor);
            return hashSet;
        }
        catch (Exception e) {
            Logger.e((String)"InAppDAO campaignsEligibleForDeletion() : ", (Throwable)e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return null;
    }

    void insertCampaign(InAppCampaign campaign) {
        this.context.getContentResolver().insert(this.campaignContentUri, this.marshallingHelper.campaignToContentValues(campaign));
    }

    void deleteCampaignById(String campaignId) {
        this.context.getContentResolver().delete(this.campaignContentUri, "campaign_id = ? ", new String[]{campaignId});
    }

    void writeStats(StatModel stat) {
        try {
            if (stat == null) {
                Logger.v((String)"InAppDAO writeStats() : Stats model empty. Cannot write.");
                return;
            }
            ContentValues values = this.marshallingHelper.statToContentValues(stat);
            Uri uri = this.context.getContentResolver().insert(this.statsContentUri, values);
            if (uri != null) {
                Logger.v((String)("InAppDAO writeStats() : New stat added. Uri: " + uri.toString()));
            } else {
                Logger.v((String)"InAppDAO writeStats() : Unable to write stat.");
            }
        }
        catch (Exception e) {
            Logger.e((String)"InAppDAO writeStats() : ", (Throwable)e);
        }
    }

    void deleteAllStats() {
        try {
            this.context.getContentResolver().delete(this.statsContentUri, null, null);
        }
        catch (Exception e) {
            Logger.e((String)"InAppDAO deleteAllStats() : ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    List<StatModel> getStats(int batchSize) {
        Uri contentUri = this.statsContentUri.buildUpon().appendQueryParameter("LIMIT", String.valueOf(batchSize)).build();
        Cursor cursor = null;
        ArrayList<StatModel> statsList = null;
        try {
            cursor = this.context.getContentResolver().query(contentUri, MoEDataContract.InAppStatsEntity.PROJECTION, null, null, null);
            if (cursor == null || !cursor.moveToFirst() || cursor.getCount() == 0) {
                Logger.v((String)"InAppDAO getStats() : No entry found.");
                this.closeCursor(cursor);
                List<StatModel> list = null;
                this.closeCursor(cursor);
                return list;
            }
            statsList = new ArrayList<StatModel>(cursor.getCount());
            do {
                try {
                    StatModel statModel = this.marshallingHelper.statFromCursor(cursor);
                    if (statModel == null) continue;
                    statsList.add(statModel);
                }
                catch (Exception e) {
                    Logger.e((String)"InAppDAO getStats() : ", (Throwable)e);
                }
            } while (cursor.moveToNext());
            this.closeCursor(cursor);
        }
        catch (Exception e) {
            Logger.e((String)"InAppDAO getStats() : ", (Throwable)e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return statsList;
    }

    void deleteStatById(StatModel stat) {
        try {
            ArrayList<ContentProviderOperation> operations = new ArrayList<ContentProviderOperation>();
            ContentProviderOperation operation = ContentProviderOperation.newDelete((Uri)this.statsContentUri).withSelection("_id = ?", new String[]{String.valueOf(stat._id)}).build();
            operations.add(operation);
            this.context.getContentResolver().applyBatch(MoEDataContract.getAuthority((Context)this.context), operations);
        }
        catch (Exception e) {
            Logger.e((String)"InAppDAO deleteStatById() : ", (Throwable)e);
        }
    }
}

