/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.model.meta;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class TriggerCondition {
    private static final String TAG = "TriggerCondition";
    @NonNull
    public final String eventName;
    @Nullable
    public final JSONObject attributes;
    private static final String ACTION_NAME = "action_name";
    private static final String ATTRIBUTES = "attributes";

    public TriggerCondition(@NonNull String eventName, @Nullable JSONObject attributes) {
        this.eventName = eventName;
        this.attributes = attributes;
    }

    public static TriggerCondition fromJson(JSONObject triggerJson) throws JSONException {
        return new TriggerCondition(triggerJson.getString(ACTION_NAME), triggerJson.optJSONObject(ATTRIBUTES));
    }

    public static JSONObject toJson(TriggerCondition trigger) {
        try {
            JSONObject triggerJson = new JSONObject();
            triggerJson.put(ACTION_NAME, (Object)trigger.eventName);
            if (trigger.attributes != null) {
                triggerJson.put(ATTRIBUTES, (Object)trigger.attributes);
            } else {
                triggerJson.put(ATTRIBUTES, (Object)new JSONObject());
            }
            return triggerJson;
        }
        catch (Exception e) {
            Logger.e((String)"TriggerCondition toJson() : Exception ", (Throwable)e);
            return null;
        }
    }

    public String toString() {
        try {
            JSONObject jsonObject = TriggerCondition.toJson(this);
            if (jsonObject != null) {
                return jsonObject.toString(4);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return super.toString();
    }
}

