/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.model.meta;

import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.inapp.model.meta.TriggerCondition;
import org.json.JSONException;
import org.json.JSONObject;

public class Trigger {
    private static final String TAG = "Trigger";
    public final TriggerCondition primaryCondition;
    private static final String PRIMARY_CONDITION = "primary_condition";
    private static final String ACTION_NAME = "action_name";

    public Trigger(TriggerCondition primaryCondition) {
        this.primaryCondition = primaryCondition;
    }

    @Nullable
    public static Trigger fromJson(@Nullable JSONObject triggerJson) throws JSONException {
        if (triggerJson == null) {
            return null;
        }
        if (triggerJson.has(PRIMARY_CONDITION) && triggerJson.getJSONObject(PRIMARY_CONDITION).has(ACTION_NAME) && !MoEUtils.isEmptyString((String)triggerJson.getJSONObject(PRIMARY_CONDITION).getString(ACTION_NAME))) {
            return new Trigger(TriggerCondition.fromJson(triggerJson.getJSONObject(PRIMARY_CONDITION)));
        }
        return null;
    }

    @Nullable
    public static JSONObject toJson(@Nullable Trigger trigger) {
        try {
            if (trigger == null) {
                return null;
            }
            JSONObject triggerJson = new JSONObject();
            JSONObject primaryCondition = TriggerCondition.toJson(trigger.primaryCondition);
            triggerJson.put(PRIMARY_CONDITION, (Object)primaryCondition);
            return triggerJson;
        }
        catch (Exception e) {
            Logger.e((String)"Trigger toJson() : Exception ", (Throwable)e);
            return null;
        }
    }

    public String toString() {
        try {
            JSONObject jsonObject = Trigger.toJson(this);
            if (jsonObject != null) {
                return jsonObject.toString(4);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return super.toString();
    }
}

