/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.model.meta;

import com.moengage.core.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class FrequencyCapping {
    private static final String TAG = "FrequencyCapping";
    public final boolean ignoreGlobalDelay;
    public final long maxCount;
    public final long minimumDelay;
    private static final String IGNORE_GLOBAL_DELAY = "ignore_global_delay";
    private static final String MAX_COUNT = "count";
    private static final String MINIMUM_DELAY = "delay";

    public FrequencyCapping(boolean ignoreGlobalDelay, long maxCount, long minimumDelay) {
        this.ignoreGlobalDelay = ignoreGlobalDelay;
        this.maxCount = maxCount;
        this.minimumDelay = minimumDelay;
    }

    public String toString() {
        try {
            JSONObject jsonObject = FrequencyCapping.toJson(this);
            if (jsonObject != null) {
                return jsonObject.toString(4);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return super.toString();
    }

    public static FrequencyCapping fromJson(JSONObject frequencyJson) throws JSONException {
        return new FrequencyCapping(frequencyJson.getBoolean(IGNORE_GLOBAL_DELAY), frequencyJson.getLong(MAX_COUNT), frequencyJson.getLong(MINIMUM_DELAY));
    }

    public static JSONObject toJson(FrequencyCapping frequencyCapping) {
        try {
            JSONObject frequencyJson = new JSONObject();
            frequencyJson.put(IGNORE_GLOBAL_DELAY, frequencyCapping.ignoreGlobalDelay).put(MAX_COUNT, frequencyCapping.maxCount).put(MINIMUM_DELAY, frequencyCapping.minimumDelay);
            return frequencyJson;
        }
        catch (Exception e) {
            Logger.e((String)"FrequencyCapping toJson() : ", (Throwable)e);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrequencyCapping that = (FrequencyCapping)o;
        if (this.ignoreGlobalDelay != that.ignoreGlobalDelay) {
            return false;
        }
        if (this.maxCount != that.maxCount) {
            return false;
        }
        return this.minimumDelay == that.minimumDelay;
    }
}

