/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.model.meta;

import com.moengage.core.Logger;
import com.moengage.inapp.model.meta.FrequencyCapping;
import org.json.JSONException;
import org.json.JSONObject;

public class DeliveryControl {
    private static final String TAG = "DeliveryControl";
    public final long priority;
    public final FrequencyCapping frequencyCapping;
    public final boolean persistent;
    private static final String PRIORITY = "priority";
    private static final String FC_META = "fc_meta";
    private static final String PERSISTENT = "persistent";

    public DeliveryControl(long priority, FrequencyCapping frequencyCapping, boolean persistent) {
        this.priority = priority;
        this.frequencyCapping = frequencyCapping;
        this.persistent = persistent;
    }

    public String toString() {
        try {
            JSONObject jsonObject = DeliveryControl.toJson(this);
            if (jsonObject != null) {
                return jsonObject.toString(4);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return super.toString();
    }

    public static DeliveryControl fromJson(JSONObject deliveryJson) throws JSONException {
        return new DeliveryControl(deliveryJson.getLong(PRIORITY), FrequencyCapping.fromJson(deliveryJson.getJSONObject(FC_META)), deliveryJson.getBoolean(PERSISTENT));
    }

    public static JSONObject toJson(DeliveryControl deliveryControl) {
        try {
            JSONObject deliveryJson = new JSONObject();
            deliveryJson.put(PRIORITY, deliveryControl.priority).put(FC_META, (Object)FrequencyCapping.toJson(deliveryControl.frequencyCapping)).put(PERSISTENT, deliveryControl.persistent);
            return deliveryJson;
        }
        catch (Exception e) {
            Logger.e((String)"DeliveryControl toJson() : ", (Throwable)e);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeliveryControl that = (DeliveryControl)o;
        if (this.priority != that.priority) {
            return false;
        }
        if (this.persistent != that.persistent) {
            return false;
        }
        return this.frequencyCapping != null ? this.frequencyCapping.equals(that.frequencyCapping) : that.frequencyCapping == null;
    }
}

