/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp.model.meta;

import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.inapp.model.meta.DeliveryControl;
import com.moengage.inapp.model.meta.DisplayControl;
import com.moengage.inapp.model.meta.Trigger;
import org.json.JSONException;
import org.json.JSONObject;

public class CampaignMeta {
    private static final String TAG = "CampaignMeta";
    public final String campaignId;
    public final String campaignName;
    public final long expiryTime;
    public final long lastUpdatedTime;
    public final DisplayControl displayControl;
    public final String templateType;
    public final DeliveryControl deliveryControl;
    @Nullable
    public final Trigger trigger;
    private static final String CAMPAIGN_ID = "campaign_id";
    private static final String CAMPAIGN_NAME = "campaign_name";
    private static final String EXPIRY_TIME = "expiry_time";
    private static final String LAST_UPDATED_TIME = "updated_time";
    private static final String DISPLAY_CONTROL = "display";
    private static final String TEMPLATE_TYPE = "template_type";
    private static final String DELIVERY_CONTROL = "delivery";
    private static final String TRIGGER = "trigger";

    public CampaignMeta(String campaignId, String campaignName, long expiryTime, long lastUpdatedTime, DisplayControl displayControl, String templateType, DeliveryControl deliveryControl, @Nullable Trigger trigger) {
        this.campaignId = campaignId;
        this.campaignName = campaignName;
        this.expiryTime = expiryTime;
        this.lastUpdatedTime = lastUpdatedTime;
        this.displayControl = displayControl;
        this.templateType = templateType;
        this.deliveryControl = deliveryControl;
        this.trigger = trigger;
    }

    public String toString() {
        try {
            JSONObject jsonObject = CampaignMeta.toJson(this);
            if (jsonObject != null) {
                return jsonObject.toString(4);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return super.toString();
    }

    public static CampaignMeta fromJson(JSONObject metaJson) throws JSONException {
        return new CampaignMeta(metaJson.getString(CAMPAIGN_ID), metaJson.getString(CAMPAIGN_NAME), MoEUtils.secondsFromIsoString((String)metaJson.getString(EXPIRY_TIME)), MoEUtils.secondsFromIsoString((String)metaJson.getString(LAST_UPDATED_TIME)), DisplayControl.fromJson(metaJson.optJSONObject(DISPLAY_CONTROL)), metaJson.getString(TEMPLATE_TYPE), DeliveryControl.fromJson(metaJson.getJSONObject(DELIVERY_CONTROL)), Trigger.fromJson(metaJson.optJSONObject(TRIGGER)));
    }

    public static JSONObject toJson(CampaignMeta meta) {
        try {
            JSONObject metaJson = new JSONObject();
            metaJson.put(CAMPAIGN_ID, (Object)meta.campaignId).put(CAMPAIGN_NAME, (Object)meta.campaignName).put(EXPIRY_TIME, (Object)MoEUtils.isoStringFromSeconds((long)meta.expiryTime)).put(LAST_UPDATED_TIME, (Object)MoEUtils.isoStringFromSeconds((long)meta.lastUpdatedTime)).put(DISPLAY_CONTROL, (Object)DisplayControl.toJson(meta.displayControl)).put(TEMPLATE_TYPE, (Object)meta.templateType).put(DELIVERY_CONTROL, (Object)DeliveryControl.toJson(meta.deliveryControl)).put(TRIGGER, (Object)Trigger.toJson(meta.trigger));
            return metaJson;
        }
        catch (Exception e) {
            Logger.e((String)"CampaignMeta toJson() : ", (Throwable)e);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CampaignMeta meta = (CampaignMeta)o;
        if (this.expiryTime != meta.expiryTime) {
            return false;
        }
        if (this.lastUpdatedTime != meta.lastUpdatedTime) {
            return false;
        }
        if (!this.campaignId.equals(meta.campaignId)) {
            return false;
        }
        if (!this.campaignName.equals(meta.campaignName)) {
            return false;
        }
        if (!this.displayControl.equals(meta.displayControl)) {
            return false;
        }
        if (!this.templateType.equals(meta.templateType)) {
            return false;
        }
        if (!this.deliveryControl.equals(meta.deliveryControl)) {
            return false;
        }
        return this.trigger != null ? this.trigger.equals(meta.trigger) : meta.trigger == null;
    }
}

