/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.core.content.res.ResourcesCompat;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.SdkConfig;
import com.moengage.inapp.ActionManager;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.InAppUtils;
import com.moengage.inapp.StatsLogger;
import com.moengage.inapp.ViewCreationMeta;
import com.moengage.inapp.exceptions.CouldNotCreateViewException;
import com.moengage.inapp.exceptions.ImageNotFoundException;
import com.moengage.inapp.model.Animation;
import com.moengage.inapp.model.Border;
import com.moengage.inapp.model.CampaignPayload;
import com.moengage.inapp.model.Color;
import com.moengage.inapp.model.InAppComponent;
import com.moengage.inapp.model.InAppContainer;
import com.moengage.inapp.model.InAppWidget;
import com.moengage.inapp.model.Margin;
import com.moengage.inapp.model.Padding;
import com.moengage.inapp.model.Spacing;
import com.moengage.inapp.model.ViewDimension;
import com.moengage.inapp.model.Widget;
import com.moengage.inapp.model.actions.Action;
import com.moengage.inapp.model.enums.Orientation;
import com.moengage.inapp.model.enums.TemplateAlignment;
import com.moengage.inapp.model.enums.ViewType;
import com.moengage.inapp.model.enums.WidgetType;
import com.moengage.inapp.model.style.ButtonStyle;
import com.moengage.inapp.model.style.CloseStyle;
import com.moengage.inapp.model.style.ContainerStyle;
import com.moengage.inapp.model.style.ImageStyle;
import com.moengage.inapp.model.style.InAppStyle;
import com.moengage.inapp.model.style.RatingStyle;
import com.moengage.inapp.model.style.TextStyle;
import com.moengage.inapp.repository.InAppImageManager;
import com.moengage.widgets.MoERatingBar;
import java.io.File;
import java.util.List;

public class ViewEngine {
    private static final String TAG = "InApp_4.2.03_ViewEngine";
    private CampaignPayload campaignPayload;
    private Context context;
    private InAppImageManager imageManager;
    private ViewDimension parentViewDimensions;
    private View popUpView;
    private int statusBarHeight;
    private float densityScale;
    private int popUpId;
    private Activity activity;
    private View inAppView;
    static final int CONTAINER_BASE_ID = 20000;
    static final int WIDGET_BASE_ID = 30000;
    private static final int CLOSE_BUTTON_SIZE = 42;
    private static final int CLOSE_BUTTON_PADDING = 6;
    private static final int CLOSE_BUTTON_MARGIN = 21;
    private static final int CLOSE_BUTTON_IMAGE_SIZE = 24;
    private static final int CLOSE_BUTTON_IMAGE_SIZE_NUDGE = 16;

    public ViewEngine(Activity activity, CampaignPayload campaignPayload, ViewCreationMeta viewCreationMeta) {
        this.activity = activity;
        this.context = activity.getApplicationContext();
        this.campaignPayload = campaignPayload;
        this.imageManager = new InAppImageManager(activity.getApplicationContext());
        this.parentViewDimensions = viewCreationMeta.deviceDimensions;
        this.statusBarHeight = viewCreationMeta.statusBarHeight;
        this.densityScale = activity.getResources().getDisplayMetrics().density;
    }

    @SuppressLint(value={"WrongThread"})
    @WorkerThread
    @Nullable
    View createInApp() {
        try {
            Logger.v((String)("InApp_4.2.03_ViewEngine createInApp() : Will try to create in-app view for campaign-id: " + this.campaignPayload.campaignId));
            Logger.v((String)("InApp_4.2.03_ViewEngine createInApp() : Device Dimensions: " + this.parentViewDimensions + "Status Bar height: " + this.statusBarHeight));
            this.inAppView = this.createPrimaryContainer(this.campaignPayload.primaryContainer);
            if (this.inAppView == null) {
                return null;
            }
            this.handleBackPress(this.inAppView);
            Logger.v((String)"InApp_4.2.03_ViewEngine createInApp() : InApp creation complete, returning created view.");
            ContainerStyle style = (ContainerStyle)this.campaignPayload.primaryContainer.style;
            if (style.animation != null && style.animation.entry != -1) {
                android.view.animation.Animation animation = AnimationUtils.loadAnimation((Context)this.context, (int)style.animation.entry);
                animation.setFillAfter(true);
                this.inAppView.setAnimation(animation);
            }
            this.inAppView.setClickable(true);
            return this.inAppView;
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_ViewEngine createInApp() : ", (Throwable)e);
            if (e instanceof UnsupportedOperationException) {
                StatsLogger.getInstance().updateStatForCampaign(this.campaignPayload.campaignId, MoEUtils.currentISOTime(), "IMP_GIF_LIB_MIS");
            } else if (e instanceof ImageNotFoundException) {
                StatsLogger.getInstance().updateStatForCampaign(this.campaignPayload.campaignId, MoEUtils.currentISOTime(), "IMP_IMG_FTH_FLR");
            }
            return null;
        }
    }

    private View createPrimaryContainer(InAppContainer container) throws CouldNotCreateViewException, ImageNotFoundException, IllegalStateException {
        Logger.v((String)"InApp_4.2.03_ViewEngine createPrimaryContainer() : ");
        RelativeLayout containerLayout = new RelativeLayout(this.context);
        containerLayout.setId(20000 + container.id);
        View widgetView = null;
        Widget widget = this.getWidgetFromList(container.widgets, WidgetType.CONTAINER);
        if (widget == null) {
            throw new IllegalStateException("Unexpected Widget type");
        }
        widgetView = this.createPopUp((InAppContainer)widget.inAppWidget);
        if (widgetView == null) {
            throw new CouldNotCreateViewException("One of the container/widget creation wasn't successful cannot create view further");
        }
        this.popUpView = widgetView;
        containerLayout.addView(widgetView);
        widget = this.getWidgetFromList(container.widgets, WidgetType.WIDGET);
        if (widget == null) {
            throw new IllegalStateException("Unexpected Widget type");
        }
        InAppWidget closeWidget = (InAppWidget)widget.inAppWidget;
        if (closeWidget.viewType != ViewType.CLOSE_BUTTON) {
            throw new IllegalStateException("Unexpected Widget type. Expected widget type is close button.");
        }
        ViewDimension campaignDimensions = this.getViewDimensionsFromPercentage(container.style);
        Logger.v((String)("InApp_4.2.03_ViewEngine createPrimaryContainer() : Campaign Dimension: " + campaignDimensions));
        ViewDimension unspecifiedDimension = this.getUnspecifiedViewDimension((View)containerLayout);
        Logger.v((String)("InApp_4.2.03_ViewEngine createPrimaryContainer() : Computed Dimension: " + unspecifiedDimension));
        campaignDimensions.height = Math.max(campaignDimensions.height, unspecifiedDimension.height);
        if (closeWidget.component.style.display) {
            widgetView = this.createCloseButton(closeWidget, campaignDimensions);
            this.alignCloseButton(widgetView, (CloseStyle)closeWidget.component.style);
            containerLayout.addView(widgetView);
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(campaignDimensions.width, campaignDimensions.height);
        Spacing spacingMargin = this.transformMargin(container.style.margin);
        layoutParams.setMargins(spacingMargin.left, spacingMargin.top, spacingMargin.right, spacingMargin.bottom);
        containerLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        Spacing spacingPadding = this.transformPadding(container.style.padding);
        containerLayout.setPadding(spacingPadding.left, spacingPadding.top, spacingPadding.right, spacingPadding.bottom);
        this.styleContainer(containerLayout, (ContainerStyle)container.style, campaignDimensions);
        return containerLayout;
    }

    private Widget getWidgetFromList(List<Widget> widgetList, WidgetType widgetType) {
        for (Widget widget : widgetList) {
            if (widget.type != widgetType) continue;
            return widget;
        }
        return null;
    }

    private void alignCloseButton(View widgetView, CloseStyle style) throws CouldNotCreateViewException {
        if (style.position == null) {
            throw new CouldNotCreateViewException("Cannot create in-app position of close button is missing Campaign-id:" + this.campaignPayload.campaignId);
        }
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)widgetView.getLayoutParams();
        switch (style.position) {
            case LEFT: {
                if (this.campaignPayload.templateType.equals("POP_UP")) {
                    layoutParams.addRule(6, this.popUpView.getId());
                    layoutParams.addRule(5, this.popUpView.getId());
                    layoutParams.leftMargin = (int)((float)layoutParams.leftMargin + ((float)this.transformViewDimension(style.margin.left, this.parentViewDimensions.width) - 21.0f * this.densityScale));
                    break;
                }
                if ("EMBEDDED".equals(this.campaignPayload.templateType)) {
                    layoutParams.addRule(6, this.popUpView.getId());
                    layoutParams.addRule(5, this.popUpView.getId());
                    break;
                }
                layoutParams.addRule(9);
                if (!SdkConfig.getConfig().isNavBarOptedOut) break;
                layoutParams.topMargin = this.statusBarHeight;
                break;
            }
            case RIGHT: {
                if (this.campaignPayload.templateType.equals("POP_UP")) {
                    layoutParams.rightMargin = (int)((float)layoutParams.rightMargin + ((float)this.transformViewDimension(style.margin.right, this.parentViewDimensions.width) - 21.0f * this.densityScale));
                    layoutParams.addRule(6, this.popUpView.getId());
                    layoutParams.addRule(7, this.popUpView.getId());
                    break;
                }
                if ("EMBEDDED".equals(this.campaignPayload.templateType)) {
                    layoutParams.addRule(6, this.popUpView.getId());
                    layoutParams.addRule(7, this.popUpView.getId());
                    break;
                }
                layoutParams.addRule(11);
                if (!SdkConfig.getConfig().isNavBarOptedOut) break;
                layoutParams.topMargin = this.statusBarHeight;
            }
        }
        if (this.campaignPayload.templateType.equals("POP_UP")) {
            layoutParams.topMargin -= (int)(21.0f * this.densityScale);
        }
        widgetView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private View createCloseButton(InAppWidget widget, ViewDimension primaryContainerDimension) {
        Logger.v((String)("InApp_4.2.03_ViewEngine createCloseButton() : Will create close button. " + widget));
        Bitmap imageBitmap = this.imageManager.getImageFromUrl(this.context, widget.component.content, this.campaignPayload.campaignId);
        if (imageBitmap == null) {
            int res = this.context.getResources().getIdentifier("moe_close", "drawable", this.context.getPackageName());
            imageBitmap = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)res);
        }
        ImageView imageView = new ImageView(this.context);
        int dimension = (int)(42.0f * this.densityScale);
        ViewDimension imageDimension = new ViewDimension(dimension, Math.min(dimension, primaryContainerDimension.height));
        int imageSize = this.campaignPayload.templateType.equals("EMBEDDED") ? (int)(16.0f * this.densityScale) : (int)(24.0f * this.densityScale);
        imageView.setImageBitmap(this.getScaledBitmap(imageBitmap, new ViewDimension(imageSize, imageSize)));
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(imageDimension.width, imageDimension.height);
        Spacing padding = null;
        if (this.campaignPayload.templateType.equals("EMBEDDED")) {
            int fixedPadding = (int)(14.0f * this.densityScale);
            padding = new Spacing(fixedPadding, 0, 0, fixedPadding);
        } else {
            int fixedPadding = (int)(6.0f * this.densityScale);
            padding = new Spacing(fixedPadding, fixedPadding, fixedPadding, fixedPadding);
        }
        imageView.setPadding(padding.left, padding.top, padding.right, padding.bottom);
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        imageView.setClickable(true);
        this.addAction((View)imageView, widget.actions);
        return imageView;
    }

    @SuppressLint(value={"ResourceType"})
    private View createPopUp(InAppContainer container) throws CouldNotCreateViewException, ImageNotFoundException {
        RelativeLayout popUpLayout = new RelativeLayout(this.context);
        this.popUpId = container.id;
        View popUpView = this.createContainer(container);
        if (popUpView == null) {
            throw new CouldNotCreateViewException("One of the container/widget creation wasn't successful cannot create view further");
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        this.addMarginToLayout(layoutParams, container.style);
        popUpLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        ViewDimension popUpDimensions = new ViewDimension(this.getViewDimensionsFromPercentage((InAppStyle)container.style).width, this.getUnspecifiedViewDimension((View)popUpView).height);
        Logger.v((String)("InApp_4.2.03_ViewEngine createPopUp() : Pop up view Dimensions: " + popUpDimensions));
        this.styleContainer(popUpLayout, (ContainerStyle)container.style, popUpDimensions);
        popUpLayout.addView(popUpView);
        this.alignContainer((View)popUpLayout, this.campaignPayload.alignment);
        popUpLayout.setId(12345);
        return popUpLayout;
    }

    private void alignContainer(View view, TemplateAlignment alignment) {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)view.getLayoutParams();
        layoutParams.addRule(15);
        layoutParams.addRule(14);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private View createContainer(InAppContainer container) throws CouldNotCreateViewException, ImageNotFoundException {
        LinearLayout containerLayout = new LinearLayout(this.context);
        switch (container.orientation) {
            case VERTICAL: {
                containerLayout.setOrientation(1);
                break;
            }
            case HORIZONTAL: {
                containerLayout.setOrientation(0);
                containerLayout.setGravity(1);
            }
        }
        View widgetView = null;
        block8: for (Widget widget : container.widgets) {
            switch (widget.type) {
                case WIDGET: {
                    InAppWidget inAppWidget = (InAppWidget)widget.inAppWidget;
                    if (!inAppWidget.component.style.display) {
                        Logger.v((String)("InApp_4.2.03_ViewEngine createContainer() : Display type of widget is false. Will not create widget. " + inAppWidget));
                        continue block8;
                    }
                    widgetView = this.createWidget(inAppWidget, container.orientation);
                    break;
                }
                case CONTAINER: {
                    InAppContainer inAppContainer = (InAppContainer)widget.inAppWidget;
                    if (!inAppContainer.style.display) {
                        Logger.v((String)("InApp_4.2.03_ViewEngine createContainer() : Display type of container is false. Will not create container. " + inAppContainer));
                        continue block8;
                    }
                    widgetView = this.createContainer(inAppContainer);
                }
            }
            if (widgetView == null) {
                throw new CouldNotCreateViewException("One of the container/widget creation wasn't successful cannot create view further");
            }
            containerLayout.addView(widgetView);
        }
        Logger.v((String)("InApp_4.2.03_ViewEngine createContainer() : " + container.style));
        this.setViewDimensionsPopUp((View)containerLayout, container.style);
        if (this.popUpId != container.id) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)containerLayout.getLayoutParams();
            this.addMarginToLayout(layoutParams, container.style);
            containerLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            Spacing spacing = this.transformPadding(container.style.padding);
            containerLayout.setPadding(spacing.left, spacing.top, spacing.right, spacing.bottom);
            this.styleContainer(containerLayout, (ContainerStyle)container.style);
        }
        containerLayout.setId(20000 + container.id);
        return containerLayout;
    }

    private void setViewDimensionsPopUp(View view, InAppStyle style) {
        ViewDimension campaignDimension = this.getViewDimensionsFromPercentage(style);
        Logger.v((String)("InApp_4.2.03_ViewEngine setViewDimensionsPopUp() : Campaign Dimension " + campaignDimension));
        ViewDimension computedDimension = this.getUnspecifiedViewDimension(view);
        Logger.v((String)("InApp_4.2.03_ViewEngine setViewDimensionsPopUp() : Computed dimension: " + computedDimension));
        campaignDimension.height = Math.max(campaignDimension.height, computedDimension.height);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(campaignDimension.width, campaignDimension.height);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private View createWidget(InAppWidget widget, Orientation parentOrientation) throws ImageNotFoundException, CouldNotCreateViewException {
        Logger.v((String)("InApp_4.2.03_ViewEngine createWidget() : Creating widget: " + widget));
        Object view = null;
        switch (widget.viewType) {
            case TEXT: {
                view = this.createTextView(widget, parentOrientation);
                break;
            }
            case IMAGE: {
                view = this.createImageView(widget, parentOrientation);
                break;
            }
            case BUTTON: {
                view = this.createButton(widget, parentOrientation);
                break;
            }
            case RATING: {
                view = this.createRatingBar(widget, parentOrientation);
            }
        }
        if (view == null) {
            throw new CouldNotCreateViewException("View type not recognised. Type " + (Object)((Object)widget.viewType));
        }
        view.setId(30000 + widget.id);
        view.setClickable(true);
        this.addAction((View)view, widget.actions);
        return view;
    }

    private TextView createTextView(InAppWidget widget, Orientation parentOrientation) {
        int resourceId;
        Logger.v((String)("InApp_4.2.03_ViewEngine createTextView() : Will create text widget: " + widget));
        TextView textView = new TextView(this.context);
        this.setTextContent(textView, widget.component);
        TextStyle textStyle = (TextStyle)widget.component.style;
        textView.setTextSize(textStyle.font.size);
        if (textStyle.font.color != null) {
            textView.setTextColor(this.getColor(textStyle.font.color));
        }
        if ((resourceId = this.context.getResources().getIdentifier(textStyle.font.name, "font", this.context.getPackageName())) > 0) {
            Typeface typeface = ResourcesCompat.getFont((Context)this.context, (int)resourceId);
            textView.setTypeface(typeface);
        }
        ViewDimension campaignDimension = this.getViewDimensionsFromPercentage(widget.component.style);
        Logger.v((String)("InApp_4.2.03_ViewEngine createTextView() : Campaign Dimension: " + campaignDimension));
        campaignDimension.height = -2;
        Spacing paddingSpacing = this.transformPadding(textStyle.padding);
        Logger.v((String)("InApp_4.2.03_ViewEngine createTextView() : Padding: " + paddingSpacing));
        textView.setPadding(paddingSpacing.left, paddingSpacing.top, paddingSpacing.right, paddingSpacing.bottom);
        Logger.v((String)("InApp_4.2.03_ViewEngine createTextView() : Final Dimensions: " + campaignDimension));
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(campaignDimension.width, campaignDimension.height);
        this.setLayoutGravity(layoutParams, parentOrientation);
        Spacing marginSpacing = this.transformMargin(textStyle.margin);
        layoutParams.setMargins(marginSpacing.left, marginSpacing.top, marginSpacing.right, marginSpacing.bottom);
        textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        GradientDrawable drawable = new GradientDrawable();
        if (textStyle.background != null && textStyle.background.color != null) {
            drawable.setColor(this.getColor(textStyle.background.color));
        }
        if (textStyle.border != null) {
            this.getBorder(textStyle.border, drawable);
        }
        this.applyBackgroundToView((View)textView, (Drawable)drawable);
        textView.setGravity(17);
        return textView;
    }

    @SuppressLint(value={"CheckResult"})
    private LinearLayout createImageView(InAppWidget widget, Orientation parentOrientation) throws ImageNotFoundException {
        ViewDimension campaignDimension;
        Logger.v((String)("InApp_4.2.03_ViewEngine createImageView() : Will create this widget: " + widget));
        ImageStyle imageStyle = (ImageStyle)widget.component.style;
        if (MoEUtils.isGif((String)widget.component.content) && !InAppUtils.hasGifSupport()) {
            Logger.w((String)"InApp_4.2.03_ViewEngine createImageView() : Image is of gif type, gif dependency not add");
            throw new UnsupportedOperationException("library not support gif not added.");
        }
        final ImageView imageView = new ImageView(this.context);
        if (MoEUtils.isGif((String)widget.component.content)) {
            final File gifFile = this.imageManager.getGifFromUrl(widget.component.content, this.campaignPayload.campaignId);
            if (gifFile == null || !gifFile.exists()) {
                throw new ImageNotFoundException("Gif Download failure");
            }
            Logger.v((String)("InApp_4.2.03_ViewEngine createImageView() : Real dimensions: " + new ViewDimension((int)imageStyle.realWidth, (int)imageStyle.realHeight)));
            campaignDimension = this.getViewDimensionsFromPercentage(imageStyle);
            Logger.v((String)("InApp_4.2.03_ViewEngine createImageView() : Campaign Dimension: " + campaignDimension));
            campaignDimension.height = (int)(imageStyle.realHeight * (double)campaignDimension.width / imageStyle.realWidth);
            Logger.v((String)("InApp_4.2.03_ViewEngine createImageView() : Final Dimensions: " + campaignDimension));
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(campaignDimension.width, campaignDimension.height);
            imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            imageView.setScaleType(ImageView.ScaleType.FIT_XY);
            Handler mainThread = new Handler(Looper.getMainLooper());
            mainThread.post(new Runnable(){

                @Override
                public void run() {
                    ((RequestBuilder)Glide.with((Context)ViewEngine.this.context).asGif().load(gifFile).fitCenter()).into(imageView);
                }
            });
        } else {
            Bitmap imageBitmap = this.imageManager.getImageFromUrl(this.context, widget.component.content, this.campaignPayload.campaignId);
            if (imageBitmap == null) {
                throw new ImageNotFoundException("Image Download failure");
            }
            campaignDimension = this.getViewDimensionsFromPercentage(widget.component.style);
            Logger.v((String)("InApp_4.2.03_ViewEngine createImageView() : Campaign Dimensions: " + campaignDimension));
            ViewDimension imageDimension = new ViewDimension(imageBitmap.getWidth(), imageBitmap.getHeight());
            Logger.v((String)("InApp_4.2.03_ViewEngine createImageView() : Image dimensions: " + imageDimension));
            campaignDimension.height = imageDimension.height * campaignDimension.width / imageDimension.width;
            Logger.v((String)("InApp_4.2.03_ViewEngine createImageView() : Final dimensions: " + campaignDimension));
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(campaignDimension.width, campaignDimension.height);
            imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            imageView.setImageBitmap(this.getScaledBitmap(imageBitmap, campaignDimension));
        }
        Spacing paddingSpacing = this.transformPadding(imageStyle.padding);
        imageView.setPadding(paddingSpacing.left, paddingSpacing.top, paddingSpacing.right, paddingSpacing.bottom);
        LinearLayout linearLayout = new LinearLayout(this.context);
        LinearLayout.LayoutParams linearLayoutParams = new LinearLayout.LayoutParams(imageView.getLayoutParams().width, imageView.getLayoutParams().height);
        Spacing marginSpacing = this.transformMargin(imageStyle.margin);
        linearLayoutParams.setMargins(marginSpacing.left, marginSpacing.top, marginSpacing.right, marginSpacing.bottom);
        linearLayoutParams.leftMargin = marginSpacing.left;
        linearLayoutParams.rightMargin = marginSpacing.right;
        linearLayoutParams.topMargin = marginSpacing.top;
        linearLayoutParams.bottomMargin = marginSpacing.bottom;
        this.setLayoutGravity(linearLayoutParams, parentOrientation);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)linearLayoutParams);
        int borderWidth = 0;
        if (imageStyle.border != null) {
            borderWidth = this.transformToPx(imageStyle.border.width);
        }
        linearLayout.setPadding(borderWidth, borderWidth, borderWidth, borderWidth);
        if (imageStyle.border != null) {
            this.applyBackgroundToView((View)linearLayout, (Drawable)this.getBorder(imageStyle.border));
        }
        linearLayout.addView((View)imageView);
        return linearLayout;
    }

    private Button createButton(InAppWidget widget, Orientation parentOrientation) {
        int resourceId;
        Logger.v((String)("InApp_4.2.03_ViewEngine createButton() : Will create button widget " + widget));
        Button button = new Button(this.context);
        this.setTextContent((TextView)button, widget.component);
        ButtonStyle style = (ButtonStyle)widget.component.style;
        Logger.v((String)("InApp_4.2.03_ViewEngine createButton() : Style: " + style));
        button.setTextSize(style.font.size);
        if (style.font.color != null) {
            button.setTextColor(this.getColor(style.font.color));
        }
        if ((resourceId = this.context.getResources().getIdentifier(style.font.name, "font", this.context.getPackageName())) > 0) {
            Typeface typeface = ResourcesCompat.getFont((Context)this.context, (int)resourceId);
            button.setTypeface(typeface);
        }
        ViewDimension campaignDimension = this.getViewDimensionsFromPercentage(widget.component.style);
        Logger.v((String)("InApp_4.2.03_ViewEngine createButton() : Campaign Dimension: " + campaignDimension));
        Spacing spacing = this.transformPadding(style.padding);
        Logger.v((String)("InApp_4.2.03_ViewEngine createButton() : Padding: " + spacing));
        button.setPadding(spacing.left, spacing.top, spacing.right, spacing.bottom);
        ViewDimension unSpecifiedDimension = this.getUnspecifiedViewDimension((View)button);
        Logger.v((String)("InApp_4.2.03_ViewEngine createButton() : Calculated Dimensions: " + unSpecifiedDimension));
        int minimumHeight = this.transformToPx(style.minHeight);
        Logger.v((String)("InApp_4.2.03_ViewEngine createButton() : Minimum height for widget: " + minimumHeight));
        if (minimumHeight > unSpecifiedDimension.height) {
            campaignDimension.height = minimumHeight;
        }
        Logger.v((String)("InApp_4.2.03_ViewEngine createButton() : Final Dimensions: " + campaignDimension));
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(campaignDimension.width, campaignDimension.height);
        this.setLayoutGravity(layoutParams, parentOrientation);
        Spacing marginSpacing = this.transformMargin(style.margin);
        layoutParams.setMargins(marginSpacing.left, marginSpacing.top, marginSpacing.right, marginSpacing.bottom);
        button.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        GradientDrawable drawable = new GradientDrawable();
        if (style.background != null && style.background.color != null) {
            drawable.setColor(this.getColor(style.background.color));
        }
        if (style.border != null) {
            this.getBorder(style.border, drawable);
        }
        this.applyBackgroundToView((View)button, (Drawable)drawable);
        button.setGravity(17);
        return button;
    }

    private MoERatingBar createRatingBar(InAppWidget widget, Orientation parentOrientation) {
        Logger.v((String)("InApp_4.2.03_ViewEngine createRatingBar() : Will create rating widget: " + widget));
        MoERatingBar ratingBar = new MoERatingBar(this.context);
        ratingBar.setIsIndicator(false);
        RatingStyle style = (RatingStyle)widget.component.style;
        ratingBar.setNumStars(style.numberOfStars);
        if (style.isHalfStepAllowed) {
            ratingBar.setStepSize(0.5f);
        } else {
            ratingBar.setStepSize(1.0f);
        }
        ratingBar.setColor(this.getColor(style.color));
        ViewDimension campaignDimension = new ViewDimension(this.getViewDimensionsFromPercentage((InAppStyle)style).width, (int)(style.realHeight * (double)this.densityScale));
        Logger.v((String)("InApp_4.2.03_ViewEngine createRatingBar() : Campaign dimensions: " + campaignDimension));
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(campaignDimension.width, campaignDimension.height);
        this.setLayoutGravity(layoutParams, parentOrientation);
        Spacing marginSpacing = this.transformMargin(style.margin);
        layoutParams.setMargins(marginSpacing.left, marginSpacing.top, marginSpacing.right, marginSpacing.bottom);
        ratingBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        GradientDrawable drawable = new GradientDrawable();
        if (style.border != null) {
            this.getBorder(style.border, drawable);
        }
        this.applyBackgroundToView((View)ratingBar, (Drawable)drawable);
        return ratingBar;
    }

    private void applyBackgroundToView(View view, Drawable drawable) {
        view.setBackground(drawable);
    }

    private GradientDrawable getBorder(Border border) {
        GradientDrawable drawable = new GradientDrawable();
        return this.getBorder(border, drawable);
    }

    private GradientDrawable getBorder(Border border, GradientDrawable drawable) {
        if (border.radius != 0.0) {
            drawable.setCornerRadius((float)border.radius * this.densityScale);
        }
        if (border.color != null && border.width != 0.0) {
            drawable.setStroke((int)(border.width * (double)this.densityScale), this.getColor(border.color));
        }
        return drawable;
    }

    private void addAction(View view, final List<Action> actions) {
        if (actions == null) {
            Logger.v((String)"InApp_4.2.03_ViewEngine addAction() : View does not have any actionType.");
            return;
        }
        Logger.v((String)("InApp_4.2.03_ViewEngine addAction() : Will try to execute actionType: " + actions));
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ViewEngine.this.markClickedIfRequired(v.getId());
                ActionManager actionManager = new ActionManager();
                for (Action action : actions) {
                    Logger.v((String)("InApp_4.2.03_ViewEngine onClick() : Will execute actionType: " + action));
                    actionManager.onActionPerformed(ViewEngine.this.activity, ViewEngine.this.inAppView, action, ViewEngine.this.campaignPayload);
                }
            }
        });
    }

    private void markClickedIfRequired(int id2) {
        if (this.campaignPayload.primaryWidget + 30000 == id2) {
            InAppController.getInstance().logPrimaryWidgetClicked(this.context, this.campaignPayload.campaignId);
        }
    }

    private Bitmap getScaledBitmap(Bitmap imageBitmap, ViewDimension bitmapDimension) {
        return Bitmap.createScaledBitmap((Bitmap)imageBitmap, (int)bitmapDimension.width, (int)bitmapDimension.height, (boolean)true);
    }

    private void setTextContent(TextView view, InAppComponent component) {
        view.setText((CharSequence)component.content);
        view.setAllCaps(false);
    }

    private void addMarginToLayout(RelativeLayout.LayoutParams layoutParams, InAppStyle style) {
        Margin margin = style.margin;
        layoutParams.leftMargin = margin.left == 0.0 ? 0 : this.transformViewDimension(margin.left, this.parentViewDimensions.width);
        layoutParams.rightMargin = margin.right == 0.0 ? 0 : this.transformViewDimension(margin.right, this.parentViewDimensions.width);
        layoutParams.topMargin = margin.top == 0.0 ? 0 : this.transformViewDimension(margin.top, this.parentViewDimensions.height);
        layoutParams.bottomMargin = margin.bottom == 0.0 ? 0 : this.transformViewDimension(margin.bottom, this.parentViewDimensions.height);
    }

    private ViewDimension getUnspecifiedViewDimension(View view) {
        view.measure(0, 0);
        return new ViewDimension(view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    private ViewDimension getViewDimensionsFromPercentage(InAppStyle style) {
        return new ViewDimension(this.transformViewDimension(style.width, this.parentViewDimensions.width), style.height == -2.0 ? -2 : this.transformViewDimension(style.height, this.parentViewDimensions.height));
    }

    private int transformViewDimension(double dimension, int containerReference) {
        return (int)(dimension * (double)containerReference / 100.0);
    }

    private void styleContainer(LinearLayout containerLayout, ContainerStyle style) {
        if (style.background != null && style.background.color != null) {
            containerLayout.setBackgroundColor(this.getColor(style.background.color));
        }
        if (style.border != null) {
            GradientDrawable backgroundDrawable = this.getBorder(style.border);
            if (style.background != null && style.background.color != null) {
                backgroundDrawable.setColor(this.getColor(style.background.color));
            }
            this.applyBackgroundToView((View)containerLayout, (Drawable)backgroundDrawable);
        }
    }

    private void styleContainer(RelativeLayout containerLayout, ContainerStyle style, ViewDimension containerDimensions) throws ImageNotFoundException {
        if (style.background == null) {
            return;
        }
        int borderWidth = 0;
        if (style.border != null) {
            borderWidth = (int)((float)((int)style.border.width) * this.densityScale);
        }
        if (borderWidth != 0) {
            Spacing paddingSpacing = new Spacing(containerLayout.getPaddingLeft(), containerLayout.getPaddingRight(), containerLayout.getPaddingTop(), containerLayout.getPaddingBottom());
            containerLayout.setPadding(paddingSpacing.left + borderWidth, paddingSpacing.top + borderWidth, paddingSpacing.right + borderWidth, paddingSpacing.bottom + borderWidth);
        }
        if (style.background.content != null) {
            final ImageView imageView = new ImageView(this.context);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(containerDimensions.width, containerDimensions.height);
            imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            if (MoEUtils.isGif((String)style.background.content)) {
                final File gifFile = this.imageManager.getGifFromUrl(style.background.content, this.campaignPayload.campaignId);
                if (gifFile == null || !gifFile.exists()) {
                    throw new ImageNotFoundException("Gif Download failure");
                }
                InAppController.getInstance().mainThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ((RequestBuilder)Glide.with((Context)ViewEngine.this.context).asGif().load(gifFile).centerCrop()).into(imageView);
                    }
                });
            } else {
                Bitmap imageBitmap = this.imageManager.getImageFromUrl(this.context, style.background.content, this.campaignPayload.campaignId);
                if (imageBitmap == null) {
                    throw new ImageNotFoundException("Image Download failure");
                }
                imageView.setImageBitmap(imageBitmap);
                imageView.setScaleType(ImageView.ScaleType.FIT_XY);
            }
            containerLayout.addView((View)imageView);
        }
        GradientDrawable drawable = new GradientDrawable();
        if (style.background.color != null) {
            drawable.setColor(this.getColor(style.background.color));
        }
        if (style.border != null) {
            this.getBorder(style.border, drawable);
        }
        this.applyBackgroundToView((View)containerLayout, (Drawable)drawable);
    }

    private void handleBackPress(View inAppView) {
        inAppView.setFocusableInTouchMode(true);
        inAppView.requestFocus();
        inAppView.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                try {
                    if (event.getAction() == 0 && keyCode == 4) {
                        Logger.v((String)"InApp_4.2.03_ViewEngine handleBackPress() : on back button pressed");
                        if (((ViewEngine)ViewEngine.this).campaignPayload.isCancellable) {
                            ContainerStyle containerStyle = (ContainerStyle)((ViewEngine)ViewEngine.this).campaignPayload.primaryContainer.style;
                            Animation animation = containerStyle.animation;
                            if (animation != null && animation.exit != -1) {
                                android.view.animation.Animation viewAnimation = AnimationUtils.loadAnimation((Context)ViewEngine.this.context, (int)animation.exit);
                                viewAnimation.setFillAfter(true);
                                v.setAnimation(viewAnimation);
                            }
                            ((ViewGroup)v.getParent()).removeView(v);
                            InAppController.getInstance().handleDismiss(ViewEngine.this.campaignPayload);
                            return true;
                        }
                        ((ViewGroup)v.getParent()).removeView(v);
                        return false;
                    }
                }
                catch (Exception e) {
                    Logger.e((String)"InApp_4.2.03_ViewEngine onKey() : ", (Throwable)e);
                }
                return false;
            }
        });
    }

    @ColorInt
    private int getColor(Color color) {
        return android.graphics.Color.argb((int)((int)(color.alpha * 255.0f + 0.5f)), (int)color.red, (int)color.green, (int)color.blue);
    }

    private Spacing transformPadding(Padding padding) {
        Spacing spacing = new Spacing(padding.left == 0.0 ? 0 : this.transformViewDimension(padding.left, this.parentViewDimensions.width), padding.right == 0.0 ? 0 : this.transformViewDimension(padding.right, this.parentViewDimensions.width), padding.top == 0.0 ? 0 : this.transformViewDimension(padding.top, this.parentViewDimensions.height), padding.bottom == 0.0 ? 0 : this.transformViewDimension(padding.bottom, this.parentViewDimensions.height));
        Logger.v((String)("InApp_4.2.03_ViewEngine transformPadding() : Padding: " + spacing));
        return spacing;
    }

    private Spacing transformMargin(Margin margin) {
        Spacing spacing = new Spacing(margin.left == 0.0 ? 0 : this.transformViewDimension(margin.left, this.parentViewDimensions.width), margin.right == 0.0 ? 0 : this.transformViewDimension(margin.right, this.parentViewDimensions.width), margin.top == 0.0 ? 0 : this.transformViewDimension(margin.top, this.parentViewDimensions.height), margin.bottom == 0.0 ? 0 : this.transformViewDimension(margin.bottom, this.parentViewDimensions.height));
        Logger.v((String)("InApp_4.2.03_ViewEngine transformMargin() : Margin: " + spacing));
        return spacing;
    }

    private int transformToPx(double dp) {
        return (int)TypedValue.applyDimension((int)1, (float)((float)dp), (DisplayMetrics)this.activity.getResources().getDisplayMetrics());
    }

    private void setLayoutGravity(LinearLayout.LayoutParams layoutParams, Orientation parentOrientation) {
        if (Orientation.VERTICAL == parentOrientation) {
            layoutParams.gravity = 1;
        }
    }
}

