/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp;

import android.content.Context;
import com.moengage.inapp.model.CampaignStats;
import com.moengage.inapp.model.enums.EvaluationStatusCode;
import com.moengage.inapp.model.meta.InAppCampaign;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StatsLogger {
    private static StatsLogger instance;
    private Map<String, CampaignStats> stats = new HashMap<String, CampaignStats>();
    private static final String TAG = "StatsLogger";
    private static final String CAMPAIGN_ATTEMPTED = "ATM";
    static final String PRIORITY_STAGE_HIGHER_PRIORITY_CAMPAIGN_AVAILABLE = "PRT_HIGH_PRT_CMP_AVL";
    private static final String PRIORITY_STAGE_MAX_TIMES_SHOWN = "PRT_MAX_TIM_SWN";
    private static final String PRIORITY_STAGE_CAMPAIGN_DELAY = "PRT_MIN_DEL";
    private static final String PRIORITY_STAGE_GLOBAL_DELAY = "PRT_GBL_DEL";
    private static final String PRIORITY_STAGE_INVALID_SCREEN = "PRT_SCR_MISMATCH";
    private static final String PRIORITY_STAGE_INVALID_CONTEXT = "PRT_CTX_MISMATCH";
    private static final String PRIORITY_STAGE_PERSISTENCE = "PRT_PERST";
    private static final String PRIORITY_STAGE_EXPIRY = "PRT_EXP";
    private static final String PRIORITY_STAGE_ORIENTATION_UNSUPPORTED = "PRT_ORT_UNSPP";
    private static final String PRIORITY_STAGE_INAPP_BLOCKED = "PRT_INAPP_BLK";
    public static final String DELIVERY_STAGE_API_FAILURE = "DLV_API_FLR";
    static final String IMPRESSION_STAGE_ANOTHER_CAMPAIGN_VISIBLE = "IMP_ANTR_CMP_VISB";
    static final String IMPRESSION_STAGE_IMAGE_DOWNLOAD_FAILURE = "IMP_IMG_FTH_FLR";
    static final String IMPRESSION_STAGE_GIF_LIBRARY_NOT_PRESENT = "IMP_GIF_LIB_MIS";
    static final String IMPRESSION_STAGE_HEIGHT_EXCEEDS_DEVICE = "IMP_HGT_EXD_DEVC";
    public static final String DELIVERY_STAGE_MANDATORY_PARAM_MISSING = "DLV_MAND_PARM_MIS";
    private static final String IMPRESSION_STAGE_MAX_TIMES_SHOWN = "IMP_MAX_TIM_SHW";
    private static final String IMPRESSION_STAGE_CAMPAIGN_DELAY = "IMP_MIN_DEL";
    private static final String IMPRESSION_STAGE_GLOBAL_DELAY = "IMP_GBL_DEL";
    private static final String IMPRESSION_STAGE_SCREEN_CHANGE = "IMP_SCR_CHG";
    private static final String IMPRESSION_STAGE_CONTEXT_CHANGE = "IMP_CTX_CHG";
    private static final String IMPRESSION_STAGE_PERSISTENCE = "IMP_PERST";
    private static final String IMPRESSION_STAGE_EXPIRY = "IMP_EXP";
    static final String IMPRESSION_STAGE_ORIENTATION_UNSUPPORTED = "IMP_ORT_UNSPP";
    private static final String IMPRESSION_STAGE_INAPP_BLOCKED = "IMP_INAPP_BLK";
    private static Map<EvaluationStatusCode, String> priorityStageFailureMap;
    private static Map<EvaluationStatusCode, String> impressionStageFailureMap;

    private StatsLogger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatsLogger getInstance() {
        if (instance != null) return instance;
        Class<StatsLogger> clazz = StatsLogger.class;
        synchronized (StatsLogger.class) {
            if (instance != null) return instance;
            instance = new StatsLogger();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void logCampaignAttempted(List<InAppCampaign> campaignMetaList) {
    }

    public void logCampaignNotPrioritized(List<InAppCampaign> inAppCampaignList) {
    }

    public void logDeviceOrientationNotSupported(List<InAppCampaign> inAppCampaignList) {
    }

    public void logPriorityStageFailure(InAppCampaign campaign, EvaluationStatusCode statusCode) {
    }

    public void logImpressionStageFailure(InAppCampaign campaign, EvaluationStatusCode statusCode) {
    }

    private void bulkLogging(List<InAppCampaign> campaignList, String reason) {
    }

    public void updateStatForCampaign(String campaignId, String timestamp, String reason) {
    }

    public void writeStatsToStorage(Context context) {
    }

    JSONObject campaignStatToJson(CampaignStats stats) throws JSONException {
        JSONObject campaignStatJson = new JSONObject();
        for (Map.Entry<String, List<String>> entry : stats.reasons.entrySet()) {
            campaignStatJson.put(entry.getKey(), (Object)this.listToJsonArray(entry.getValue()));
        }
        return campaignStatJson;
    }

    private JSONArray listToJsonArray(List<String> timestampList) {
        JSONArray jsonArray = new JSONArray();
        for (String timeStamp : timestampList) {
            jsonArray.put((Object)timeStamp);
        }
        return jsonArray;
    }

    static {
        priorityStageFailureMap = new HashMap<EvaluationStatusCode, String>();
        impressionStageFailureMap = new HashMap<EvaluationStatusCode, String>();
    }
}

