/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp;

import android.content.Context;
import androidx.annotation.NonNull;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEUtils;
import com.moengage.core.Properties;
import com.moengage.core.SdkConfig;
import com.moengage.core.executor.ITask;
import com.moengage.core.executor.TaskManager;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.listeners.InAppMessageListener;
import com.moengage.inapp.model.MoEInAppCampaign;
import com.moengage.inapp.model.enums.StateUpdateType;
import com.moengage.inapp.tasks.UpdateCampaignStateTask;

public class MoEInAppHelper {
    private static final String TAG = "InApp_4.2.03_MoEInAppHelper";
    private InAppMessageListener inAppMessageListener = new InAppMessageListener();
    private static MoEInAppHelper instance = null;

    private MoEInAppHelper() {
    }

    public void registerListener(InAppMessageListener listener) {
        this.inAppMessageListener = listener;
    }

    public InAppMessageListener getListener() {
        return this.inAppMessageListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MoEInAppHelper getInstance() {
        if (instance != null) return instance;
        Class<MoEInAppHelper> clazz = MoEInAppHelper.class;
        synchronized (MoEInAppHelper.class) {
            if (instance != null) return instance;
            instance = new MoEInAppHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void showInApp(Context context) {
        Logger.v((String)"InApp_4.2.03_MoEInAppHelper showInApp() : Inside showInApp() will try to show in-app if possible.");
        if (!InAppController.getInstance().isModuleEnabled(context)) {
            Logger.v((String)"InApp_4.2.03_MoEInAppHelper showInApp() : InApp Module is disabled. Cannot show in-app.");
            return;
        }
        if (!SdkConfig.getConfig().isLifecycleInAppOptedOut) {
            Logger.w((String)"InApp_4.2.03_MoEInAppHelper showInApp() : Hasn't opted out of lifecycle campaign. Cannot show campaigns using this method. Opt out of default display in the MoEngage.Builder to use this API");
            return;
        }
        if (!InAppController.getInstance().isInAppSynced()) {
            Logger.v((String)"InApp_4.2.03_MoEInAppHelper showInApp() : Either campaign sync is pending or campaign cannot be shown because of global delay.");
            InAppController.getInstance().setShowInAppPending(true);
            return;
        }
        Logger.v((String)"InApp_4.2.03_MoEInAppHelper showInApp() : Will try to show in-app");
        InAppController.getInstance().tryToShowInApp(context);
    }

    public void getSelfHandledInApp(Context context) {
        Logger.v((String)"InApp_4.2.03_MoEInAppHelper getSelfHandledInApp() : Inside getSelfHandledInApp() will try to return in-app if possible.");
        if (!InAppController.getInstance().isModuleEnabled(context)) {
            Logger.v((String)"InApp_4.2.03_MoEInAppHelper getSelfHandledInApp() : InApp Module is disabled. Cannot show in-app.");
            return;
        }
        if (!InAppController.getInstance().isInAppSynced()) {
            Logger.v((String)"InApp_4.2.03_MoEInAppHelper getSelfHandledInApp() : Either campaign sync is pending or campaign cannot be shown because of global delay.");
            InAppController.getInstance().setSelfHandledInAppPending(true);
            return;
        }
        Logger.v((String)"InApp_4.2.03_MoEInAppHelper getSelfHandledInApp() : Will try to return self handled in-app.");
        InAppController.getInstance().tryToShowSelfHandledInApp(context);
    }

    public void selfHandledShown(Context context, @NonNull MoEInAppCampaign campaign) {
        if (campaign == null || MoEUtils.isEmptyString((String)campaign.campaignId)) {
            Logger.w((String)"InApp_4.2.03_MoEInAppHelper selfHandledCampaignShown() : Campaign object or Id is null. Ignoring request.");
            return;
        }
        InAppController.getInstance().trackInAppShown(context, campaign.campaignId, campaign.campaignName);
        TaskManager.getInstance().addTaskToQueue((ITask)new UpdateCampaignStateTask(context, campaign.campaignId, StateUpdateType.SHOWN, true));
    }

    public void selfHandledClicked(Context context, @NonNull MoEInAppCampaign campaign) {
        this.selfHandledClicked(context, campaign, -1);
    }

    public void selfHandledClicked(Context context, @NonNull MoEInAppCampaign campaign, int widgetId) {
        Logger.v((String)("InApp_4.2.03_MoEInAppHelper selfHandledClicked() : Will log self handled click. " + campaign));
        if (campaign == null || campaign.selfHandledCampaign == null || MoEUtils.isEmptyString((String)campaign.campaignId)) {
            Logger.w((String)"InApp_4.2.03_MoEInAppHelper selfHandledClicked() : Ignoring request, Reason - one of the following - \n 1. Campaign object is null \n 2. Campaign is not of type self handled \n 3. Campaign is an empty string.");
            return;
        }
        Properties properties = new Properties();
        properties.addAttribute("campaign_id", (Object)campaign.campaignId).addAttribute("campaign_name", (Object)campaign.campaignName);
        if (widgetId > 0) {
            properties.addAttribute(MoEConstants.ATTRIBUTE_WIDGET_ID, (Object)widgetId);
        }
        MoEHelper.getInstance((Context)context).trackEvent(MoEConstants.EVENT_IN_APP_CLICKED, properties);
    }

    public void selfHandledPrimaryClicked(Context context, @NonNull MoEInAppCampaign campaign) {
        if (campaign == null || MoEUtils.isEmptyString((String)campaign.campaignId)) {
            Logger.w((String)"InApp_4.2.03_MoEInAppHelper selfHandledPrimaryClicked() : Ignoring request, Reason - one of the following - \n 1. Campaign object is null \n 2. Campaign is not of type self handled \n 3. Campaign is an empty string.");
            return;
        }
        TaskManager.getInstance().addTaskToQueue((ITask)new UpdateCampaignStateTask(context, campaign.campaignId, StateUpdateType.CLICKED, true));
    }

    public void selfHandledDismissed(Context context, MoEInAppCampaign campaign) {
        Logger.v((String)("InApp_4.2.03_MoEInAppHelper selfHandledDismissed() : Will log self-handled dismissed. " + campaign));
        if (campaign == null || campaign.selfHandledCampaign == null || MoEUtils.isEmptyString((String)campaign.campaignId)) {
            Logger.w((String)"InApp_4.2.03_MoEInAppHelper selfHandledDismissed() : Campaign object or Id is null. Ignoring request, Reason - one of the following - \n 1. Campaign object is null \n 2. Campaign is not of type self handled \n 3. Campaign is an empty string.");
            return;
        }
        Properties properties = new Properties();
        properties.addAttribute("campaign_id", (Object)campaign.campaignId).addAttribute("campaign_name", (Object)campaign.campaignName);
        MoEHelper.getInstance((Context)context).trackEvent(MoEConstants.EVENT_IN_APP_DISMISSED, properties);
    }
}

