/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.View;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.InAppInjector;
import com.moengage.inapp.model.InAppGlobalState;
import com.moengage.inapp.model.ViewDimension;
import java.util.ArrayList;
import java.util.List;

public class InAppUtils {
    private static final String TAG = "InApp_4.2.03_InAppUtils";
    private static final String[] USED_GLIDE_CLASSES = new String[]{"com.bumptech.glide.load.resource.gif.GifDrawable", "com.bumptech.glide.Glide"};
    private static final ArrayList<String> OEMS_DONT_EXCLUDE_STATUS_BAR = new ArrayList();

    private InAppUtils() {
    }

    public static int getStatusBarHeight(Context context) {
        int marginTop = 0;
        int resource = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resource > 0) {
            marginTop = context.getResources().getDimensionPixelSize(resource);
        }
        return marginTop;
    }

    public static ViewDimension getScreenDimension(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return new ViewDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
    }

    public static void logCurrentInAppState(Context context) {
        Logger.v((String)("InApp_4.2.03_InAppUtils logCurrentInAppState() : Current Activity Name: " + InAppController.getInstance().getCurrentActivityName()));
        List contextList = MoEHelper.getInstance((Context)context).getAppContext();
        if (contextList != null) {
            Logger.v((String)("InApp_4.2.03_InAppUtils logCurrentInAppState() : Current context: " + contextList));
        } else {
            Logger.v((String)"InApp_4.2.03_InAppUtils logCurrentInAppState() : No context set.");
        }
        InAppGlobalState globalState = InAppInjector.getInstance().getInAppRepository((Context)context).localRepository.getGlobalState();
        Logger.v((String)("InApp_4.2.03_InAppUtils logCurrentInAppState() : Global Delay: " + globalState.globalDelay + "\n Last campaign shown at: " + MoEUtils.isoStringFromSeconds((long)globalState.lastShowTime) + "\n Current time: " + MoEUtils.isoStringFromSeconds((long)globalState.currentDeviceTime)));
    }

    public static boolean hasGifSupport() {
        try {
            ClassLoader staticClassLoader = InAppUtils.class.getClassLoader();
            boolean isGlideOnPath = true;
            for (String classPath : USED_GLIDE_CLASSES) {
                if (Class.forName(classPath, false, staticClassLoader) != null) continue;
                isGlideOnPath = false;
                break;
            }
            return isGlideOnPath;
        }
        catch (Exception e) {
            Logger.v((String)"InApp_4.2.03_InAppUtils hasGifSupport() Glide library not found");
        }
        catch (NoClassDefFoundError ncd) {
            Logger.v((String)"InApp_4.2.03_InAppUtils hasGifSupport() Glide library not found");
        }
        catch (Throwable t) {
            Logger.v((String)"InApp_4.2.03_InAppUtils hasGifSupport() Glide library not found");
        }
        return false;
    }

    public static ViewDimension getUnspecifiedViewDimension(View view) {
        view.measure(0, 0);
        return new ViewDimension(view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    public static boolean isInAppExceedingScreen(ViewDimension inAppDimensions, ViewDimension screenDimensions) {
        return screenDimensions.height < inAppDimensions.height;
    }

    static {
        OEMS_DONT_EXCLUDE_STATUS_BAR.add("HMD Global");
        OEMS_DONT_EXCLUDE_STATUS_BAR.add("OnePlus");
    }
}

