/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.Logger;
import com.moengage.core.SdkConfig;
import com.moengage.core.internal.inapp.InAppHandler;
import com.moengage.core.model.InAppV2Meta;
import com.moengage.core.model.InAppV3Meta;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.InAppInjector;
import com.moengage.inapp.model.meta.CampaignMeta;
import com.moengage.inapp.model.meta.CampaignState;
import com.moengage.inapp.model.meta.DeliveryControl;
import com.moengage.inapp.model.meta.DisplayControl;
import com.moengage.inapp.model.meta.FrequencyCapping;
import com.moengage.inapp.model.meta.Rules;

public class InAppHandlerImpl
implements InAppHandler {
    private static final String TAG = "InApp_4.2.03_InAppHandlerImpl";

    public void showInAppIfRequired(Context context) {
        if (SdkConfig.getConfig().isLifecycleInAppOptedOut) {
            Logger.v((String)"InApp_4.2.03_InAppHandlerImpl showInAppIfRequired() : lifecycle campaigns opted out cannot show in-app");
            return;
        }
        if (!InAppController.getInstance().isInAppSynced()) {
            Logger.v((String)"InApp_4.2.03_InAppHandlerImpl showInAppIfRequired() : Sync pending, cannot show in-app now.");
            return;
        }
        InAppController.getInstance().tryToShowInApp(context);
    }

    public void showTriggerInAppIfPossible(Context context, Event event) {
        InAppController.getInstance().tryToShowTriggerInAppIfPossible(context, event);
    }

    public void unregisterInAppManager(Activity currentActivity) {
        InAppController.getInstance().unRegisterActivity(currentActivity);
    }

    public void registerInAppManager(Activity currentActivity) {
        InAppController.getInstance().registerActivity(currentActivity);
    }

    public void onAppClose(Context context) {
        InAppController.getInstance().onAppClose(context);
    }

    public void onLogout(Context context) {
        InAppController.getInstance().setInAppSynced(false);
        InAppInjector.getInstance().getInAppRepository(context).onLogout(context);
    }

    public void syncInAppIfRequired(Context context) {
        InAppController.getInstance().syncInApps(context);
    }

    public InAppV3Meta generateMetaForV2Campaign(InAppV2Meta inAppV2Meta) {
        CampaignMeta meta = new CampaignMeta(inAppV2Meta.campaignId, "", inAppV2Meta.expiry, 0L, new DisplayControl(new Rules(null, null)), "", new DeliveryControl(inAppV2Meta.priority, new FrequencyCapping(false, 0L, 0L), true), null);
        CampaignState campaignState = new CampaignState(inAppV2Meta.showCount, inAppV2Meta.lastShowTime / 1000L, inAppV2Meta.isClicked == 1);
        return new InAppV3Meta(CampaignMeta.toJson(meta), CampaignState.toJson(campaignState));
    }

    public void showInAppFromPush(Context context, Bundle pushPayload) {
        InAppController.getInstance().showInAppFromPush(context, pushPayload);
    }
}

