/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp;

import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.SdkConfig;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.StatsLogger;
import com.moengage.inapp.model.InAppGlobalState;
import com.moengage.inapp.model.enums.EvaluationStatusCode;
import com.moengage.inapp.model.meta.CampaignMeta;
import com.moengage.inapp.model.meta.CampaignState;
import com.moengage.inapp.model.meta.InAppCampaign;
import java.util.List;
import java.util.Set;

public class InAppEvaluator {
    private static final String TAG = "InApp_4.2.03_InAppEvaluator";

    public boolean canShowInAppOnActivity(String activityName, @Nullable List<String> blockedActivityList) {
        if (blockedActivityList != null && blockedActivityList.contains(activityName)) {
            Logger.i((String)("InApp_4.2.03_InAppEvaluator canShowInAppOnActivity() : reason: in-app blocked on screen. Screen Name: " + activityName));
            return false;
        }
        return true;
    }

    public EvaluationStatusCode isCampaignEligibleForDisplay(InAppCampaign inAppCampaign, List<String> contextList, String currentActivityName, InAppGlobalState globalState) {
        CampaignMeta meta = inAppCampaign.campaignMeta;
        CampaignState campaignState = inAppCampaign.campaignState;
        Logger.v((String)("InApp_4.2.03_InAppEvaluator isCampaignEligibleForDisplay() : Evaluating campaign: " + meta.campaignId + "\n Campaign meta: " + meta + "\n Campaign state: " + campaignState));
        if (!this.canShowInAppOnActivity(currentActivityName, SdkConfig.getConfig().inAppOptOutList)) {
            Logger.i((String)("InApp_4.2.03_InAppEvaluator isCampaignEligibleForDisplay() : Cannot show campaign: " + meta.campaignId + "reason: in-app blocked on screen."));
            return EvaluationStatusCode.BLOCKED_ON_SCREEN;
        }
        Logger.v((String)"InApp_4.2.03_InAppEvaluator isCampaignEligibleForDisplay() : InApp Blocked on screen check passed.");
        if (globalState.lastShowTime + globalState.globalDelay > globalState.currentDeviceTime && !meta.deliveryControl.frequencyCapping.ignoreGlobalDelay) {
            Logger.i((String)("InApp_4.2.03_InAppEvaluator isCampaignEligibleForDisplay() : Cannot show campaign: " + meta.campaignId + "reason: global delay failure"));
            return EvaluationStatusCode.GLOBAL_DELAY;
        }
        Logger.v((String)"InApp_4.2.03_InAppEvaluator isCampaignEligibleForDisplay() : Global minimum delay check passed.");
        if (meta.expiryTime < globalState.currentDeviceTime) {
            Logger.i((String)("InApp_4.2.03_InAppEvaluator isCampaignEligibleForDisplay() : Cannot show campaign: " + meta.campaignId + "reason: campaign expired"));
            return EvaluationStatusCode.EXPIRY;
        }
        Logger.v((String)"InApp_4.2.03_InAppEvaluator isCampaignEligibleForDisplay() : Campaign expiry check passed.");
        if (meta.displayControl.rules.screenName != null && !meta.displayControl.rules.screenName.equals(currentActivityName)) {
            Logger.i((String)("InApp_4.2.03_InAppEvaluator isCampaignEligibleForDisplay() : Cannot show campaign: " + meta.campaignId + "reason: cannot show in-app on this screen"));
            return EvaluationStatusCode.INVALID_SCREEN;
        }
        Logger.v((String)"InApp_4.2.03_InAppEvaluator isCampaignEligibleForDisplay(): Show only in screen check has passed ");
        if (meta.displayControl.rules.context != null && !meta.displayControl.rules.context.isEmpty()) {
            if (contextList == null) {
                return EvaluationStatusCode.INVALID_CONTEXT;
            }
            boolean contextExists = false;
            Set<String> contextToShowIn = meta.displayControl.rules.context;
            for (String context : contextList) {
                if (!contextToShowIn.contains(context)) continue;
                contextExists = true;
            }
            if (!contextExists) {
                Logger.i((String)("InApp_4.2.03_InAppEvaluator isCampaignEligibleForDisplay() : Cannot show campaign: " + meta.campaignId + "reason: current contextList not as"));
                return EvaluationStatusCode.INVALID_CONTEXT;
            }
        }
        Logger.v((String)"InApp_4.2.03_InAppEvaluator isCampaignEligibleForDisplay(): Context check has passed.");
        if (!meta.deliveryControl.persistent && campaignState.isClicked) {
            Logger.i((String)("InApp_4.2.03_InAppEvaluator isCampaignEligibleForDisplay() : Cannot show campaign: " + meta.campaignId + "reason: already clicked and campaign is not persistent"));
            return EvaluationStatusCode.PERSISTENT;
        }
        Logger.v((String)"InApp_4.2.03_InAppEvaluator isCampaignEligibleForDisplay(): Persistent check passed.");
        if (meta.deliveryControl.frequencyCapping.maxCount > 0L && campaignState.showCount >= meta.deliveryControl.frequencyCapping.maxCount) {
            Logger.i((String)("InApp_4.2.03_InAppEvaluator isCampaignEligibleForDisplay() : Cannot show campaign: " + meta.campaignId + "reason: already shown max times"));
            return EvaluationStatusCode.MAX_COUNT;
        }
        Logger.v((String)"InApp_4.2.03_InAppEvaluator isCampaignEligibleForDisplay(): Max count check passed.");
        if (campaignState.lastShowTime + meta.deliveryControl.frequencyCapping.minimumDelay > globalState.currentDeviceTime) {
            Logger.i((String)("InApp_4.2.03_InAppEvaluator isCampaignEligibleForDisplay() : Cannot show campaign: " + meta.campaignId + "reason: minimum delay between same campaign"));
            return EvaluationStatusCode.CAMPAIGN_DELAY;
        }
        Logger.v((String)"InApp_4.2.03_InAppEvaluator isCampaignEligibleForDisplay(): Minimum delay between same campaign check passed.");
        return EvaluationStatusCode.SUCCESS;
    }

    @Nullable
    public InAppCampaign getEligibleCampaignFromList(List<InAppCampaign> campaignList, InAppGlobalState globalState, List<String> appContext) {
        int index;
        StatsLogger.getInstance().logCampaignAttempted(campaignList);
        InAppCampaign suitableCampaign = null;
        for (index = 0; index < campaignList.size(); ++index) {
            InAppCampaign campaign = campaignList.get(index);
            EvaluationStatusCode statusCode = this.isCampaignEligibleForDisplay(campaign, appContext, InAppController.getInstance().getCurrentActivityName(), globalState);
            if (statusCode == EvaluationStatusCode.SUCCESS) {
                suitableCampaign = campaign;
                break;
            }
            StatsLogger.getInstance().logPriorityStageFailure(campaign, statusCode);
        }
        if (suitableCampaign != null) {
            ++index;
            String timestamp = MoEUtils.currentISOTime();
            while (index < campaignList.size()) {
                InAppCampaign campaign = campaignList.get(index);
                StatsLogger.getInstance().updateStatForCampaign(campaign.campaignMeta.campaignId, timestamp, "PRT_HIGH_PRT_CMP_AVL");
                ++index;
            }
        }
        return suitableCampaign;
    }

    public boolean isServerSyncRequired(long lastSyncTime, long currentTime, long syncInterval, boolean isInAppSynced) {
        return !isInAppSynced || lastSyncTime + syncInterval < currentTime;
    }
}

