/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEUtils;
import com.moengage.core.Properties;
import com.moengage.core.RemoteConfig;
import com.moengage.core.SdkConfig;
import com.moengage.core.executor.ITask;
import com.moengage.core.executor.TaskManager;
import com.moengage.inapp.InAppEvaluator;
import com.moengage.inapp.InAppInjector;
import com.moengage.inapp.InAppUtils;
import com.moengage.inapp.MoEInAppHelper;
import com.moengage.inapp.R;
import com.moengage.inapp.StatsLogger;
import com.moengage.inapp.SyncCompleteObservable;
import com.moengage.inapp.ViewCreationMeta;
import com.moengage.inapp.ViewEngine;
import com.moengage.inapp.listeners.InAppMessageListener;
import com.moengage.inapp.model.CampaignPayload;
import com.moengage.inapp.model.MoEInAppCampaign;
import com.moengage.inapp.model.SelfHandledCampaign;
import com.moengage.inapp.model.enums.EvaluationStatusCode;
import com.moengage.inapp.model.enums.StateUpdateType;
import com.moengage.inapp.model.meta.InAppCampaign;
import com.moengage.inapp.model.style.ContainerStyle;
import com.moengage.inapp.repository.remote.FetchMetaTask;
import com.moengage.inapp.tasks.ShowInAppTask;
import com.moengage.inapp.tasks.ShowSelfHandledInAppTask;
import com.moengage.inapp.tasks.ShowTestInAppTask;
import com.moengage.inapp.tasks.ShowTriggerInAppTask;
import com.moengage.inapp.tasks.UpdateCampaignStateTask;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class InAppController {
    private static final String TAG = "InApp_4.2.03_InAppController";
    private static InAppController instance = null;
    private WeakReference<Activity> currentActivity = null;
    private AtomicBoolean inAppManagerState;
    private boolean isInAppSynced = false;
    private boolean isShowInAppPending = false;
    private boolean isSelfHandledInAppPending = false;
    private boolean isInAppShowing = false;
    public Handler mainThreadHandler;
    private List<Event> pendingTriggerEvents;
    private SyncCompleteObservable syncObservable;
    private ScheduledExecutorService scheduledExecutorService;
    private final Object lock = new Object();
    private Set<String> visibleOrProcessingNudge;

    private InAppController() {
        this.inAppManagerState = new AtomicBoolean();
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
        this.pendingTriggerEvents = new ArrayList<Event>();
        this.syncObservable = new SyncCompleteObservable();
        this.visibleOrProcessingNudge = new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InAppController getInstance() {
        if (instance != null) return instance;
        Class<InAppController> clazz = InAppController.class;
        synchronized (InAppController.class) {
            if (instance != null) return instance;
            instance = new InAppController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    void registerActivity(Activity activity) {
        this.updateCurrentActivityContext(activity);
        this.inAppManagerState.set(true);
    }

    void unRegisterActivity(Activity activity) {
        try {
            if (this.currentActivity != null && this.currentActivity.getClass().getName().equals(activity.getClass().getName())) {
                this.updateCurrentActivityContext(null);
                this.inAppManagerState.set(false);
            }
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_InAppController unRegisterActivity() : ", (Throwable)e);
            this.inAppManagerState.set(false);
        }
    }

    private void updateCurrentActivityContext(Activity activity) {
        this.currentActivity = activity == null ? null : new WeakReference<Activity>(activity);
    }

    @Nullable
    public String getCurrentActivityName() {
        if (this.currentActivity == null) {
            return null;
        }
        Activity activity = (Activity)this.currentActivity.get();
        if (activity == null) {
            return null;
        }
        return activity.getClass().getName();
    }

    void tryToShowSelfHandledInApp(Context context) {
        TaskManager.getInstance().startTask((ITask)new ShowSelfHandledInAppTask(context));
    }

    public boolean canShowInAppForConfig(Context context, List<InAppCampaign> campaignList) {
        if (this.isTablet(context)) {
            Logger.v((String)"InApp_4.2.03_InAppControllercanShowInAppForConfig() : Cannot show in-app on tablet will return.");
            return false;
        }
        if (this.isLandscapeMode(context)) {
            Logger.v((String)"InApp_4.2.03_InAppControllercanShowInAppForConfig() : Cannot show in-app in landscape mode will return");
            StatsLogger.getInstance().logDeviceOrientationNotSupported(campaignList);
            return false;
        }
        return true;
    }

    void tryToShowInApp(Context context) {
        TaskManager.getInstance().startTask((ITask)new ShowInAppTask(context));
    }

    public boolean isTablet(Context context) {
        return context.getResources().getBoolean(R.bool.moeIsTablet);
    }

    public boolean isLandscapeMode(Context context) {
        return context.getResources().getBoolean(R.bool.moeIsLand);
    }

    public void buildAndShowInApp(Context context, InAppCampaign suitableInApp, CampaignPayload campaignPayload) {
        ViewCreationMeta viewCreationMeta = new ViewCreationMeta(InAppUtils.getScreenDimension(context), InAppUtils.getStatusBarHeight(context));
        View view = this.buildInApp(campaignPayload, viewCreationMeta);
        if (view == null) {
            Logger.v((String)("InApp_4.2.03_InAppController buildAndShowInApp() : Could not create view for in-app campaign " + suitableInApp.campaignMeta.campaignId));
            return;
        }
        if (this.canShowInApp(context, suitableInApp, view)) {
            this.showInApp(view, viewCreationMeta, campaignPayload);
        }
    }

    @Nullable
    public View buildInApp(CampaignPayload campaignPayload, ViewCreationMeta viewCreationMeta) {
        Activity activity = (Activity)this.currentActivity.get();
        if (activity == null) {
            Logger.v((String)"InApp_4.2.03_InAppController buildInApp() : Cannot build in-app without activity. Aborting in-app creation");
            return null;
        }
        return new ViewEngine(activity, campaignPayload, viewCreationMeta).createInApp();
    }

    private void showInApp(View view, ViewCreationMeta viewCreationMeta, CampaignPayload campaignPayload) {
        Logger.v((String)("InApp_4.2.03_InAppController showInApp() : Will try to show in-app. Campaign id: " + campaignPayload.campaignId));
        Activity activity = (Activity)this.currentActivity.get();
        if (activity == null) {
            Logger.v((String)"InApp_4.2.03_InAppController showInApp() : Cannot show campaign activity reference is null");
            return;
        }
        this.addInAppToViewHierarchy(activity, view, campaignPayload);
    }

    public void addInAppToViewHierarchy(final Activity currentActivity, final View inAppView, final CampaignPayload campaignPayload) {
        this.hideStatusBarIfRequired(currentActivity);
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                FrameLayout root = InAppController.this.getWindowRoot(currentActivity);
                root.addView(inAppView);
                InAppController.this.isInAppShowing = true;
                InAppController.this.autoDismissInAppIfRequired(root, campaignPayload, inAppView, currentActivity);
                InAppController.this.onInAppShown(currentActivity.getApplicationContext(), campaignPayload);
            }
        });
    }

    private void autoDismissInAppIfRequired(final FrameLayout root, final CampaignPayload campaignPayload, final View inAppView, final Activity currentActivity) {
        if (campaignPayload.dismissInterval > 0L) {
            this.mainThreadHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (root.indexOfChild(inAppView) == -1) {
                        Logger.v((String)"InApp_4.2.03_InAppController autoDismissInAppIfRequired() : in-app was closed before being auto dismissed");
                    } else {
                        InAppController.this.removeViewFromHierarchy(campaignPayload, (Context)currentActivity, inAppView);
                        InAppController.this.onAutoDismiss(currentActivity.getApplicationContext(), campaignPayload);
                    }
                }
            }, campaignPayload.dismissInterval * 1000L);
        }
    }

    FrameLayout getWindowRoot(Activity activity) {
        return (FrameLayout)activity.getWindow().getDecorView().findViewById(0x1020002).getRootView();
    }

    @SuppressLint(value={"ResourceType"})
    void removeViewFromHierarchy(CampaignPayload campaignPayload, Context context, View inAppView) {
        try {
            ContainerStyle style = (ContainerStyle)campaignPayload.primaryContainer.style;
            if (style.animation != null && style.animation.exit != -1) {
                Animation animation = AnimationUtils.loadAnimation((Context)context, (int)style.animation.exit);
                inAppView.setAnimation(animation);
            }
            ((ViewGroup)inAppView.getParent()).removeView(inAppView);
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_InAppController removeViewFromHierarchy() : ", (Throwable)e);
        }
    }

    private boolean canShowInApp(Context context, InAppCampaign inAppCampaign, View inAppView) {
        if (this.isInAppShowing) {
            Logger.i((String)"InApp_4.2.03_InAppController canShowInApp() : InApp is already being shown. Cannot show another in-app.");
            StatsLogger.getInstance().updateStatForCampaign(inAppCampaign.campaignMeta.campaignId, MoEUtils.currentISOTime(), "IMP_ANTR_CMP_VISB");
            return false;
        }
        if (this.isLandscapeMode(context)) {
            Logger.i((String)"InApp_4.2.03_InAppController canShowInApp() : Cannot show in-app for config.");
            StatsLogger.getInstance().updateStatForCampaign(inAppCampaign.campaignMeta.campaignId, MoEUtils.currentISOTime(), "IMP_ORT_UNSPP");
            return false;
        }
        InAppEvaluator evaluator = new InAppEvaluator();
        EvaluationStatusCode statusCode = evaluator.isCampaignEligibleForDisplay(inAppCampaign, MoEHelper.getInstance((Context)context).getAppContext(), this.getCurrentActivityName(), InAppInjector.getInstance().getInAppRepository((Context)context).localRepository.getGlobalState());
        if (statusCode != EvaluationStatusCode.SUCCESS) {
            Logger.i((String)"InApp_4.2.03_InAppController canShowInApp() : Cannot show in-app, conditions don't satisfy.");
            StatsLogger.getInstance().logImpressionStageFailure(inAppCampaign, statusCode);
            return false;
        }
        if (InAppUtils.isInAppExceedingScreen(InAppUtils.getUnspecifiedViewDimension(inAppView), InAppUtils.getScreenDimension(context))) {
            Logger.i((String)"InApp_4.2.03_InAppController canShowInApp() : Cannot show in-app, view dimensions exceed device dimensions.");
            StatsLogger.getInstance().updateStatForCampaign(inAppCampaign.campaignMeta.campaignId, MoEUtils.currentISOTime(), "IMP_HGT_EXD_DEVC");
            return false;
        }
        return true;
    }

    public boolean isInAppSynced() {
        return this.isInAppSynced;
    }

    void setInAppSynced(boolean inAppSynced) {
        this.isInAppSynced = inAppSynced;
    }

    private boolean isShowInAppPending() {
        return this.isShowInAppPending;
    }

    void setShowInAppPending(boolean showInAppPending) {
        this.isShowInAppPending = showInAppPending;
    }

    private boolean isSelfHandledInAppPending() {
        return this.isSelfHandledInAppPending;
    }

    void setSelfHandledInAppPending(boolean selfHandledInAppPending) {
        this.isSelfHandledInAppPending = selfHandledInAppPending;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void tryToShowTriggerInAppIfPossible(Context context, Event event) {
        if (!this.isInAppSynced) {
            Logger.v((String)"InApp_4.2.03_InAppController tryToShowTriggerInAppIfPossible() : In-App has not synced. Will show try to show trigger in-app after sync, queueing event.");
            this.pendingTriggerEvents.add(event);
            return;
        }
        Set<String> triggerEvents = InAppInjector.getInstance().getInAppRepository((Context)context).cache.triggerEvents;
        if (triggerEvents != null && triggerEvents.contains(event.eventName)) {
            TaskManager.getInstance().startTask((ITask)new ShowTriggerInAppTask(context, event));
        }
    }

    void syncInApps(Context context) {
        try {
            if (this.isTablet(context)) {
                Logger.i((String)"$tag syncInAppIfRequired() : Cannot show in-apps on tablet. No point making a sync request.");
                return;
            }
            TaskManager.getInstance().addTaskToQueue((ITask)new FetchMetaTask(context));
        }
        catch (Exception e) {
            Logger.i((String)"InApp_4.2.03_InAppController syncInAppIfRequired() : ", (Throwable)e);
        }
    }

    void handleDismiss(CampaignPayload campaignPayload) {
        this.isInAppShowing = false;
        this.removeProcessingNudge(campaignPayload.campaignId);
        this.notifyInAppClosedListeners(campaignPayload);
        Activity activity = this.getCurrentActivity();
        if (activity != null) {
            this.showStatusBarIfRequired(activity);
        }
    }

    private void notifyInAppShownListeners(CampaignPayload campaign) {
        final MoEInAppCampaign inAppCampaign = new MoEInAppCampaign(campaign.campaignId, campaign.campaignName);
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                InAppMessageListener listener = MoEInAppHelper.getInstance().getListener();
                listener.onShown(inAppCampaign);
            }
        });
    }

    private void notifyInAppClosedListeners(CampaignPayload campaignPayload) {
        final MoEInAppCampaign inAppCampaign = new MoEInAppCampaign(campaignPayload.campaignId, campaignPayload.campaignName);
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                InAppMessageListener listener = MoEInAppHelper.getInstance().getListener();
                listener.onClosed(inAppCampaign);
            }
        });
    }

    public void onSyncSuccess(Context context) {
        Logger.v((String)"InApp_4.2.03_InAppController onSyncSuccess() : Sync successful will try to process pending showInApp if required.");
        this.setInAppSynced(true);
        this.syncObservable.onSyncSuccess();
        if (InAppInjector.getInstance().getInAppRepository(context).isLifeCycleCallbackOptedOut()) {
            Logger.v((String)"InApp_4.2.03_InAppController onSyncSuccess() : Lifecycle callbacks is opted out, will check if explicit calls are pending.");
            if (this.isShowInAppPending()) {
                MoEInAppHelper.getInstance().showInApp(context);
                this.setShowInAppPending(false);
            }
            if (this.isSelfHandledInAppPending()) {
                MoEInAppHelper.getInstance().getSelfHandledInApp(context);
                this.setSelfHandledInAppPending(false);
            }
        } else {
            Logger.v((String)"InApp_4.2.03_InAppController onSyncSuccess() : Lifecycle in-apps are pending, will try to show.");
            this.tryToShowInApp(context);
            this.tryToShowSelfHandledInApp(context);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void onInAppShown(Context context, CampaignPayload inAppCampaign) {
        this.trackInAppShown(context, inAppCampaign.campaignId, inAppCampaign.campaignName);
        this.notifyInAppShownListeners(inAppCampaign);
        TaskManager.getInstance().addTaskToQueue((ITask)new UpdateCampaignStateTask(context, StateUpdateType.SHOWN, inAppCampaign.campaignId));
    }

    void logPrimaryWidgetClicked(Context context, String campaignId) {
        TaskManager.getInstance().addTaskToQueue((ITask)new UpdateCampaignStateTask(context, StateUpdateType.CLICKED, campaignId));
    }

    private void onAutoDismiss(Context context, CampaignPayload campaignPayload) {
        this.handleDismiss(campaignPayload);
        Properties properties = new Properties();
        properties.addAttribute("campaign_name", (Object)campaignPayload.campaignName).addAttribute("campaign_id", (Object)campaignPayload.campaignId).setNonInteractive();
        MoEHelper.getInstance((Context)context).trackEvent(MoEConstants.EVENT_IN_APP_AUTO_DISMISS, properties);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void clearPendingEvents() {
        Logger.v((String)"InApp_4.2.03_InAppController clearPendingEvents() : Will clear pending events.");
        this.pendingTriggerEvents.clear();
    }

    public List<Event> getPendingTriggerEvents() {
        return this.pendingTriggerEvents;
    }

    @Nullable
    public Activity getCurrentActivity() {
        if (this.currentActivity == null) {
            return null;
        }
        return (Activity)this.currentActivity.get();
    }

    public void registerSyncObserver(Observer observer) {
        this.syncObservable.addObserver(observer);
    }

    public void unregisterSyncObserver(Observer observer) {
        this.syncObservable.deleteObserver(observer);
    }

    void showInAppFromPush(final Context context, Bundle pushPayload) {
        try {
            boolean isTest;
            String campaignId;
            Logger.v((String)("InApp_4.2.03_InAppController showInAppFromPush() : Will try to show inapp from push. Metadata: \n" + pushPayload));
            long timeDelay = 5L;
            if (pushPayload.containsKey(MoEConstants.PUSH_EXTRA_INAPP_META)) {
                JSONObject inAppMetaJson = new JSONObject(pushPayload.getString(MoEConstants.PUSH_EXTRA_INAPP_META));
                campaignId = inAppMetaJson.getString("cid");
                isTest = inAppMetaJson.optBoolean("isTest", false);
                timeDelay = inAppMetaJson.optLong("timeDelay", 5L);
            } else if (pushPayload.containsKey(MoEConstants.PUSH_EXTRA_INAPP_LEGACY_META)) {
                campaignId = pushPayload.getString(MoEConstants.PUSH_EXTRA_INAPP_LEGACY_META);
                isTest = true;
            } else {
                Logger.v((String)"InApp_4.2.03_InAppController showInAppFromPush() : InApp meta data missing cannot show campaign.");
                return;
            }
            if (MoEUtils.isEmptyString((String)campaignId)) {
                Logger.v((String)"InApp_4.2.03_InAppController showInAppFromPush() : Cannot show in-app. Campaign id missing.");
                return;
            }
            if (this.scheduledExecutorService == null || this.scheduledExecutorService.isShutdown()) {
                this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
            }
            final boolean finalIsTest = isTest;
            final String finalCampaignId = campaignId;
            this.scheduledExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    if (finalIsTest) {
                        TaskManager.getInstance().startTask((ITask)new ShowTestInAppTask(context, finalCampaignId));
                    }
                }
            }, timeDelay, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_InAppController showInAppFromPush() : ", (Throwable)e);
        }
    }

    void onAppClose(Context context) {
        this.clearPendingEvents();
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
    }

    private void hideStatusBarIfRequired(final Activity activity) {
        if (SdkConfig.getConfig().isNavBarOptedOut) {
            return;
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                View decorView = activity.getWindow().getDecorView();
                decorView.setSystemUiVisibility(4);
            }
        });
    }

    private void showStatusBarIfRequired(Activity activity) {
        if (SdkConfig.getConfig().isNavBarOptedOut) {
            return;
        }
        if (activity != null) {
            View decorView = activity.getWindow().getDecorView();
            decorView.setSystemUiVisibility(0);
        }
    }

    public void onSelfHandledAvailable(final CampaignPayload campaignPayload) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                MoEInAppHelper.getInstance().getListener().onSelfHandledAvailable(new MoEInAppCampaign(campaignPayload.campaignId, campaignPayload.campaignName, new SelfHandledCampaign(campaignPayload.customPayload, campaignPayload.dismissInterval, campaignPayload.isCancellable)));
            }
        });
    }

    public boolean isModuleEnabled(Context context) {
        RemoteConfig config = RemoteConfig.getConfig();
        return !ConfigurationProvider.getInstance((Context)context).isInAppOptedOut() && config.isInAppEnabled && config.isAppEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InAppCampaign getEligibleNudgeView(Context context, Map<String, InAppCampaign> campaignMap) {
        Object object = this.lock;
        synchronized (object) {
            Logger.v((String)("InApp_4.2.03_InAppController getEligibleNudgeView() : Campaigns Being show or processed: " + this.visibleOrProcessingNudge));
            if (campaignMap == null) {
                return null;
            }
            InAppEvaluator evaluator = new InAppEvaluator();
            for (String campaignId : this.visibleOrProcessingNudge) {
                campaignMap.remove(campaignId);
            }
            if (campaignMap.isEmpty()) {
                return null;
            }
            InAppCampaign campaign = evaluator.getEligibleCampaignFromList(new ArrayList<InAppCampaign>(campaignMap.values()), InAppInjector.getInstance().getInAppRepository((Context)context).localRepository.getGlobalState(), MoEHelper.getInstance((Context)context).getAppContext());
            if (campaign == null) {
                return null;
            }
            this.addProcessingNudge(campaign.campaignMeta.campaignId);
            return campaign;
        }
    }

    public void addProcessingNudge(String campaignId) {
        this.visibleOrProcessingNudge.add(campaignId);
    }

    public void removeProcessingNudge(String campaignId) {
        Logger.v((String)("InApp_4.2.03_InAppController removeProcessingNudge() : Removing campaign from processing list, id: " + campaignId));
        this.visibleOrProcessingNudge.remove(campaignId);
    }

    void trackInAppShown(Context context, String campaignId, String campaignName) {
        Properties properties = new Properties();
        properties.addAttribute("campaign_id", (Object)campaignId).addAttribute("campaign_name", (Object)campaignName).setNonInteractive();
        MoEHelper.getInstance((Context)context).trackEvent(MoEConstants.EVENT_IN_APP_SHOWN, properties);
    }
}

