/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.inapp;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.activities.MoEActivity;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ActionManagerBase;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.Properties;
import com.moengage.evaluator.ConditionEvaluator;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.MoEInAppHelper;
import com.moengage.inapp.listeners.InAppMessageListener;
import com.moengage.inapp.model.CampaignPayload;
import com.moengage.inapp.model.MoEInAppCampaign;
import com.moengage.inapp.model.actions.Action;
import com.moengage.inapp.model.actions.CallAction;
import com.moengage.inapp.model.actions.Condition;
import com.moengage.inapp.model.actions.ConditionAction;
import com.moengage.inapp.model.actions.CopyAction;
import com.moengage.inapp.model.actions.CustomAction;
import com.moengage.inapp.model.actions.NavigationAction;
import com.moengage.inapp.model.actions.ShareAction;
import com.moengage.inapp.model.actions.SmsAction;
import com.moengage.inapp.model.actions.TrackAction;
import com.moengage.inapp.model.actions.UserInputAction;
import com.moengage.inapp.model.enums.ActionType;
import com.moengage.inapp.model.enums.NavigationType;
import com.moengage.widgets.MoERatingBar;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ActionManager
extends ActionManagerBase {
    private static final String TAG = "InApp_4.2.03_ActionManager";

    void onActionPerformed(Activity context, View inAppView, Action action, CampaignPayload campaignPayload) {
        try {
            switch (action.actionType) {
                case SMS: {
                    this.smsAction((Context)context, action, campaignPayload.campaignId);
                    break;
                }
                case CALL: {
                    this.callAction((Context)context, action, campaignPayload.campaignId);
                    break;
                }
                case SHARE: {
                    this.shareAction((Context)context, action, campaignPayload.campaignId);
                    break;
                }
                case NAVIGATE: {
                    this.navigateAction(context, action, campaignPayload);
                    break;
                }
                case DISMISS: {
                    this.dismissAction(context, action, inAppView, campaignPayload);
                    break;
                }
                case TRACK_DATA: {
                    this.trackAction((Context)context, action, campaignPayload.campaignId);
                    break;
                }
                case COPY_TEXT: {
                    this.copyAction((Context)context, action, campaignPayload.campaignId);
                    break;
                }
                case CONDITION_ACTION: {
                    this.conditionAction(context, inAppView, action, campaignPayload);
                    break;
                }
                case CUSTOM_ACTION: {
                    this.customAction(action, campaignPayload);
                    break;
                }
                case USER_INPUT: {
                    this.userInputAction(context, inAppView, action, campaignPayload);
                    break;
                }
                default: {
                    Logger.v((String)"InApp_4.2.03_ActionManager onActionPerformed() : Not a valid action.");
                    break;
                }
            }
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_ActionManager onActionPerformed() : ", (Throwable)e);
        }
    }

    private void navigateAction(Activity context, Action action, CampaignPayload campaignPayload) throws ClassNotFoundException {
        MoEInAppCampaign moEInAppCampaign;
        Logger.v((String)"InApp_4.2.03_ActionManager navigateAction() : Will try to navigate user");
        if (!(action instanceof NavigationAction)) {
            Logger.v((String)("InApp_4.2.03_ActionManager navigateAction() : Not a valid navigation action. Campaign-id: " + campaignPayload.campaignId));
            return;
        }
        NavigationAction navigationAction = (NavigationAction)action;
        Logger.v((String)("InApp_4.2.03_ActionManager navigateAction() : Navigation Action: " + navigationAction.toString()));
        if (MoEUtils.isEmptyString((String)navigationAction.navigationUrl)) {
            Logger.v((String)("InApp_4.2.03_ActionManager navigateAction() : Navigation url empty, aborting action. Campaign id: " + campaignPayload.campaignId));
            return;
        }
        InAppMessageListener listener = MoEInAppHelper.getInstance().getListener();
        if (navigationAction.navigationType != NavigationType.RICH_LANDING && listener.onNavigation(moEInAppCampaign = new MoEInAppCampaign(campaignPayload.campaignId, campaignPayload.campaignName, navigationAction))) {
            Logger.v((String)"InApp_4.2.03_ActionManager navigateAction() : Navigation handled by the app, SDK need not take any action");
            return;
        }
        Intent redirectIntent = null;
        switch (navigationAction.navigationType) {
            case SCREEN: {
                redirectIntent = new Intent((Context)context, Class.forName(navigationAction.navigationUrl));
                Bundle extras = new Bundle();
                if (navigationAction.keyValuePairs == null) break;
                for (Map.Entry<String, Object> entry : navigationAction.keyValuePairs.entrySet()) {
                    extras.putString(entry.getKey(), String.valueOf(entry.getValue()));
                }
                if (extras.isEmpty()) break;
                redirectIntent.putExtras(extras);
                break;
            }
            case RICH_LANDING: {
                redirectIntent = new Intent((Context)context, MoEActivity.class);
                redirectIntent.putExtra("gcm_webUrl", this.buildUriFromString(navigationAction).toString());
                redirectIntent.putExtra("isEmbeddedWebView", true);
                break;
            }
            case DEEP_LINKING: {
                redirectIntent = new Intent("android.intent.action.VIEW", this.buildUriFromString(navigationAction));
            }
        }
        if (redirectIntent != null) {
            context.startActivity(redirectIntent);
        }
    }

    private Uri buildUriFromString(NavigationAction action) {
        Uri uri = Uri.parse((String)action.navigationUrl);
        if (action.keyValuePairs == null) {
            return uri;
        }
        Uri.Builder builder = uri.buildUpon();
        for (Map.Entry<String, Object> entry : action.keyValuePairs.entrySet()) {
            builder.appendQueryParameter(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return builder.build();
    }

    private void trackAction(Context context, Action action, String campaignId) {
        Logger.v((String)"InApp_4.2.03_ActionManager trackAction() : Will try to track data.");
        if (!(action instanceof TrackAction)) {
            Logger.v((String)("InApp_4.2.03_ActionManager trackAction() : Not a valid track action. Campaign-id: " + campaignId));
            return;
        }
        TrackAction trackAction = (TrackAction)action;
        switch (trackAction.trackType) {
            case EVENT: {
                this.trackEvent(context, trackAction, campaignId);
                break;
            }
            case USER_ATTRIBUTE: {
                this.trackUserAttribute(context, trackAction, campaignId);
            }
        }
    }

    private void trackUserAttribute(Context context, TrackAction action, String campaignId) {
        Logger.v((String)"InApp_4.2.03_ActionManager trackUserAttribute() : Will try to track user attribute");
        if (MoEUtils.isEmptyString((String)action.name.trim())) {
            Logger.v((String)("InApp_4.2.03_ActionManager trackUserAttribute() : Cannot track user attribute with empty name. Campaign id: " + campaignId));
            return;
        }
        MoEHelper.getInstance((Context)context).setUserAttribute(action.name.trim(), action.value);
    }

    private void trackEvent(Context context, TrackAction action, String campaignId) {
        Logger.v((String)"InApp_4.2.03_ActionManager trackEvent() : Will try to track event");
        if (MoEUtils.isEmptyString((String)action.name.trim())) {
            Logger.v((String)("InApp_4.2.03_ActionManager trackEvent() : Event name is empty cannot track event. Campaign id: " + campaignId));
            return;
        }
        Properties properties = new Properties();
        if (action.attributes != null) {
            for (Map.Entry<String, Object> entry : action.attributes.entrySet()) {
                properties.addAttribute(entry.getKey(), entry.getValue());
            }
        }
        MoEHelper.getInstance((Context)context).trackEvent(action.name.trim(), properties);
    }

    private void customAction(Action action, final CampaignPayload campaignPayload) {
        Logger.v((String)"InApp_4.2.03_ActionManager customAction() : will try to trigger a custom action callback");
        if (!(action instanceof CustomAction)) {
            Logger.v((String)("InApp_4.2.03_ActionManager customAction() : Not a valid custom action. Camapaign-id: " + campaignPayload.campaignId));
            return;
        }
        final CustomAction customAction = (CustomAction)action;
        final InAppMessageListener listener = MoEInAppHelper.getInstance().getListener();
        InAppController.getInstance().mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                listener.onCustomAction(new MoEInAppCampaign(campaignPayload.campaignId, campaignPayload.campaignName, customAction));
            }
        });
    }

    private void copyAction(Context context, Action action, String campaignId) {
        Logger.v((String)"InApp_4.2.03_ActionManager copyAction() : will try to copy text on clipboard");
        if (!(action instanceof CopyAction)) {
            Logger.v((String)("InApp_4.2.03_ActionManager copyAction() : Not a valid copy action. Campaign-id: " + campaignId));
            return;
        }
        CopyAction copyAction = (CopyAction)action;
        Logger.v((String)("InApp_4.2.03_ActionManager copyAction() : Copy Action: " + copyAction));
        if (MoEUtils.isEmptyString((String)copyAction.textToCopy)) {
            Logger.v((String)("InApp_4.2.03_ActionManager copyAction() : Text to copy is empty, aborting action. Campaign id: " + campaignId));
        }
        MoEHelperUtils.copyTextToClipboardAndShowToast((Context)context, (String)copyAction.textToCopy, (String)copyAction.message);
    }

    private void shareAction(Context context, Action action, String campaignId) {
        Logger.v((String)"InApp_4.2.03_ActionManager shareAction() : will try to share text");
        if (!(action instanceof ShareAction)) {
            Logger.v((String)("InApp_4.2.03_ActionManager shareAction() : Not a valid share action. Campaign-id: " + campaignId));
            return;
        }
        ShareAction shareAction = (ShareAction)action;
        Logger.v((String)("InApp_4.2.03_ActionManager shareAction() : Share Action: " + shareAction));
        if (MoEUtils.isEmptyString((String)shareAction.shareText)) {
            Logger.v((String)("InApp_4.2.03_ActionManager shareAction() : Text to share is empty, aborting action. Campaign id: " + campaignId));
        }
        this.triggerShareIntent(context, shareAction.shareText);
    }

    private void callAction(Context context, Action action, String campaignId) {
        Logger.v((String)"InApp_4.2.03_ActionManager callAction() : will try to trigger call intent");
        if (!(action instanceof CallAction)) {
            Logger.v((String)("InApp_4.2.03_ActionManager callAction() : Not a valid call action. Campaign-id: " + campaignId));
            return;
        }
        CallAction callAction = (CallAction)action;
        Logger.v((String)("InApp_4.2.03_ActionManager callAction() : Call Action: " + callAction));
        if (MoEUtils.isEmptyString((String)callAction.phoneNumber) || !this.isPhoneNumberValid(callAction.phoneNumber)) {
            Logger.v((String)("InApp_4.2.03_ActionManager callAction() : Phone number is empty, aborting action. Campaign-id: " + campaignId));
            return;
        }
        this.triggerCallIntent(context, callAction.phoneNumber);
    }

    private void smsAction(Context context, Action action, String campaignId) {
        Logger.v((String)"InApp_4.2.03_ActionManager smsAction() : will try to trigger sms intent");
        if (!(action instanceof SmsAction)) {
            Logger.v((String)("InApp_4.2.03_ActionManager smsAction() : Not a valid sms action returning. Campaign-id: " + campaignId));
            return;
        }
        SmsAction smsAction = (SmsAction)action;
        Logger.v((String)("InApp_4.2.03_ActionManager smsAction() : Sms Action: " + smsAction));
        if (MoEUtils.isEmptyString((String)smsAction.phoneNumber) || MoEUtils.isEmptyString((String)smsAction.message)) {
            Logger.v((String)("InApp_4.2.03_ActionManager smsAction() : Either number or body is null Campaign id: " + campaignId));
            return;
        }
        Uri uri = Uri.parse((String)("smsto:" + smsAction.phoneNumber));
        Intent intent = new Intent("android.intent.action.SENDTO", uri);
        intent.putExtra("sms_body", smsAction.message);
        context.startActivity(intent);
    }

    private void dismissAction(Activity activity, Action action, View inAppView, CampaignPayload campaignPayload) {
        Logger.v((String)"InApp_4.2.03_ActionManager dismissAction() : Will try to dismiss in-app");
        InAppController.getInstance().removeViewFromHierarchy(campaignPayload, activity.getApplicationContext(), inAppView);
        InAppController.getInstance().handleDismiss(campaignPayload);
    }

    private void userInputAction(Activity context, View inAppView, Action action, CampaignPayload campaignPayload) {
        Logger.v((String)"InApp_4.2.03_ActionManager userInputAction() : Will try to capture user input.");
        if (!(action instanceof UserInputAction)) {
            Logger.v((String)("InApp_4.2.03_ActionManager userInputAction() : Not a valid User-Input action returning. Campaign-id:" + campaignPayload));
            return;
        }
        UserInputAction inputAction = (UserInputAction)action;
        Logger.v((String)("InApp_4.2.03_ActionManager userInputAction() : User Input Action: " + inputAction));
        switch (inputAction.userInputType) {
            case RATING: {
                View view = inAppView.findViewById(30000 + inputAction.widgetId);
                if (view == null) {
                    Logger.v((String)"InApp_4.2.03_ActionManager userInputAction() : Did not find widget with the given id.");
                    return;
                }
                if (!(view instanceof MoERatingBar)) {
                    Logger.v((String)"InApp_4.2.03_ActionManager userInputAction() : Given view is not a rating widget.");
                    return;
                }
                MoERatingBar ratingView = (MoERatingBar)view;
                float ratingInput = ratingView.getRating();
                for (Action actionItem : inputAction.actionList) {
                    if (actionItem.actionType == ActionType.TRACK_DATA) {
                        TrackAction trackAction = (TrackAction)actionItem;
                        switch (trackAction.trackType) {
                            case EVENT: {
                                trackAction.attributes.put("rating", Float.valueOf(ratingInput));
                                this.trackEvent((Context)context, trackAction, campaignPayload.campaignId);
                                break;
                            }
                            case USER_ATTRIBUTE: {
                                MoEHelper.getInstance((Context)context).setUserAttribute(trackAction.name.trim(), ratingInput);
                            }
                        }
                        continue;
                    }
                    this.onActionPerformed(context, inAppView, actionItem, campaignPayload);
                }
                break;
            }
        }
    }

    private void conditionAction(Activity context, View inAppView, Action action, CampaignPayload campaignPayload) {
        try {
            Logger.v((String)"InApp_4.2.03_ActionManager conditionAction() : Will try to perform actionType based on condition.");
            if (!(action instanceof ConditionAction)) {
                Logger.v((String)("InApp_4.2.03_ActionManager conditionAction() : Not a valid Condition actionType. Will return. Campaign-id: " + campaignPayload.campaignId));
                return;
            }
            ConditionAction conditionAction = (ConditionAction)action;
            Logger.v((String)("InApp_4.2.03_ActionManager conditionAction() : Condition Action: " + conditionAction));
            View view = inAppView.findViewById(30000 + conditionAction.widgetId);
            if (view == null) {
                Logger.v((String)"InApp_4.2.03_ActionManager userInputAction() : Did not find widget with the given id.");
                return;
            }
            if (!(view instanceof MoERatingBar)) {
                Logger.v((String)"InApp_4.2.03_ActionManager userInputAction() : Given view is not a rating widget.");
                return;
            }
            MoERatingBar ratingView = (MoERatingBar)view;
            float ratingInput = ratingView.getRating();
            JSONObject userInput = new JSONObject();
            userInput.put("rating", (double)ratingInput);
            for (Condition condition : conditionAction.conditionList) {
                ConditionEvaluator evaluator = new ConditionEvaluator(this.transformConditionAttributeForPackage(condition.conditionAttribute), userInput);
                if (!evaluator.evaluate()) continue;
                for (Action actionItem : condition.actionList) {
                    this.onActionPerformed(context, inAppView, actionItem, campaignPayload);
                }
            }
        }
        catch (Exception e) {
            Logger.e((String)"InApp_4.2.03_ActionManager conditionAction() : ", (Throwable)e);
        }
    }

    private JSONObject transformConditionAttributeForPackage(JSONObject conditionAttribute) throws JSONException {
        JSONObject attributes = new JSONObject();
        attributes.put("filter_operator", (Object)"and");
        JSONArray filters = new JSONArray();
        filters.put((Object)conditionAttribute);
        attributes.put("filters", (Object)filters);
        return attributes;
    }
}

