package com.moengage.inapp.tasks;

import android.content.Context;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.inapp.InAppConstants;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.InAppInjector;
import com.moengage.inapp.StatsLogger;
import com.moengage.inapp.repository.InAppRepository;

/**
 * @author Umang Chamaria
 * Date: 2019-10-14
 */
public class UploadStatsTask extends SDKTask {

  private static final String TAG = InAppConstants.MODULE_TAG + "UploadStatsTask";

  public UploadStatsTask(Context context) {
    super(context);
  }

  @Override public TaskResult execute() {
    try {
      if (!InAppController.getInstance().isModuleEnabled(context)) {
        Logger.v(TAG + " execute() : InApp Module is disabled. Will not upload stats.");
        return taskResult;
      }
      StatsLogger.getInstance().writeStatsToStorage(context);
      InAppRepository repository = InAppInjector.getInstance().getInAppRepository(context);
      repository.uploadStats();
    } catch (Exception e) {
      Logger.e(TAG + " execute() : ", e);
    }
    return null;
  }

  @Override public String getTaskTag() {
    return TAG_UPLOAD_STATS_TASK;
  }

  @Override public boolean isSynchronous() {
    return true;
  }
}
