package com.moengage.inapp.tasks;

import android.content.Context;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.InAppEvaluator;
import com.moengage.inapp.InAppInjector;
import com.moengage.inapp.MoEInAppHelper;
import com.moengage.inapp.listeners.InAppMessageListener;
import com.moengage.inapp.model.CampaignPayload;
import com.moengage.inapp.model.CampaignRequest;
import com.moengage.inapp.model.meta.InAppCampaign;
import com.moengage.inapp.repository.InAppRepository;
import java.util.List;

/**
 * @author Umang Chamaria
 */
public class ShowSelfHandledInAppTask extends SDKTask {

  private static final String TAG = "ShowSelfHandledInAppTask";
  private InAppEvaluator evaluator;

  public ShowSelfHandledInAppTask(Context context) {
    super(context);
    evaluator = new InAppEvaluator();
  }

  @Override public TaskResult execute() {
    try {
      Logger.v(TAG + " execute() : started execution");
      InAppController controller = InAppController.getInstance();
      InAppRepository repository = InAppInjector.getInstance().getInAppRepository(context);
      final InAppMessageListener listener = MoEInAppHelper.getInstance().getListener();
      // check if in-app module is enabled
      if (!controller.isModuleEnabled(context)) {
        Logger.v(TAG + " execute() : InApp Module is disabled. Cannot show in-app.");
        return taskResult;
      }

      if (!controller.isInAppSynced()) {
        Logger.v(TAG + " execute() : Cannot show trigger in-app as sync is pending");
        return null;
      }

      if (listener == null) {
        Logger.w(TAG + " execute() : InAppMessageListener not set. Cannot pass self-handled "
            + "callback, ignoring request.");
        return taskResult;
      }
      // fetch self-handled campaign from db
      List<InAppCampaign> selfHandledCampaigns = repository.cache.selfHandledCampaign;
      if (selfHandledCampaigns == null) {
        Logger.v(TAG + " execute() : No active campaigns to show");
        return taskResult;
      }

      InAppCampaign suitableInApp = evaluator
          .getEligibleCampaignFromList(selfHandledCampaigns,
              repository.localRepository.getGlobalState(),
              MoEHelper.getInstance(context).getAppContext());

      if (suitableInApp == null) {
        Logger.v(TAG + " execute() : Did not find any suitable campaign to show");
        return taskResult;
      }

      CampaignPayload campaignPayload = repository.fetchSelfHandledPayload(
          new CampaignRequest(repository.localRepository.baseRequest(),
              suitableInApp.campaignMeta.campaignId,
              controller.getCurrentActivityName(),
              MoEHelper.getInstance(context).getAppContext()));

      if (campaignPayload == null) {
        Logger.v(TAG + " execute() : Campaign Payload is empty. Cannot show campaign.");
        return taskResult;
      }

      controller.onSelfHandledAvailable(campaignPayload);
      taskResult.setIsSuccess(true);
      Logger.v(TAG + " execute() : execution completion");
    } catch (Exception e) {
      Logger.e( TAG + " execute() : ", e);
    }
    return taskResult;
  }

  @Override public String getTaskTag() {
    return TAG_CHECK_SELF_HANDLED_IN_APP_TASK;
  }

  @Override public boolean isSynchronous() {
    return true;
  }
}
