package com.moengage.inapp.tasks;

import android.content.Context;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.inapp.InAppConstants;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.InAppEvaluator;
import com.moengage.inapp.InAppInjector;
import com.moengage.inapp.InAppUtils;
import com.moengage.inapp.model.CampaignPayload;
import com.moengage.inapp.model.CampaignRequest;
import com.moengage.inapp.model.meta.InAppCampaign;
import com.moengage.inapp.repository.InAppRepository;
import java.util.List;

/**
 * @author Umang Chamaria
 */
public class ShowInAppTask extends SDKTask {

  private static final String TAG = InAppConstants.MODULE_TAG + "ShowInAppTask";
  private InAppEvaluator evaluator;

  public ShowInAppTask(Context context) {
    super(context);
    this.evaluator = new InAppEvaluator();
  }

  @Override public TaskResult execute() {
    try {
      InAppController controller = InAppController.getInstance();
      Logger.v(TAG + " execute() : started execution");

      if (!controller.isModuleEnabled(context)) {
        Logger.v(TAG + " execute() : InApp Module is disabled. Cannot show in-app.");
        return taskResult;
      }

      if (!controller.isInAppSynced()) {
        Logger.v(TAG + " execute() : Cannot show trigger in-app as sync is pending");
        return null;
      }

      InAppRepository repository = InAppInjector.getInstance().getInAppRepository(context);
      InAppUtils.logCurrentInAppState(context);

      List<InAppCampaign> generalCampaigns = repository.cache.generalCampaign;

      if (generalCampaigns == null) {
        Logger.v(TAG + " execute() : No active campaigns to show");
        return taskResult;
      }
      if (!controller.canShowInAppForConfig(context, generalCampaigns)) return taskResult;

      InAppCampaign suitableInApp = evaluator.getEligibleCampaignFromList(generalCampaigns,
          repository.localRepository.getGlobalState(),
          MoEHelper.getInstance(context).getAppContext());

      if (suitableInApp == null) {
        Logger.v(TAG + " execute() : Did not find any suitable campaign to show");
        return taskResult;
      }

      CampaignPayload campaignPayload =
          repository.fetchCampaignPayload(
              new CampaignRequest(repository.localRepository.baseRequest(),
                  suitableInApp.campaignMeta.campaignId,
                  controller.getCurrentActivityName(),
                  MoEHelper.getInstance(context).getAppContext()),
              suitableInApp.campaignMeta.deliveryControl.persistent);
      if (campaignPayload == null){
        Logger.v(TAG + " execute() : Campaign Payload is empty. Cannot show campaign.");
        return taskResult;
      }

      controller.buildAndShowInApp(context, suitableInApp, campaignPayload);

      Logger.v(TAG + " execute() : execution complete");
    } catch (Exception e) {
      Logger.e(TAG + " execute() : Exception ", e);
    }
    return taskResult;
  }

  @Override public String getTaskTag() {
    return TAG_CHECK_IN_APP_TASK;
  }

  @Override public boolean isSynchronous() {
    return true;
  }
}
