package com.moengage.inapp.tasks;

import android.content.Context;
import android.view.View;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.inapp.InAppConstants;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.InAppInjector;
import com.moengage.inapp.InAppUtils;
import com.moengage.inapp.ViewCreationMeta;
import com.moengage.inapp.model.CampaignPayload;
import com.moengage.inapp.model.CampaignRequest;
import com.moengage.inapp.model.meta.InAppCampaign;
import com.moengage.inapp.repository.InAppRepository;

/**
 * @author Umang Chamaria
 * Date: 2019-09-21
 */
public class PreviewInAppTask extends SDKTask {

  private static final String TAG = "PreviewInAppTask";

  private InAppCampaign campaign;

  public PreviewInAppTask(Context context, InAppCampaign campaign) {
    super(context);
    this.campaign = campaign;
  }

  @Override public TaskResult execute() {
    try {
      Logger.v(TAG + " execute() : will try creating preview");
      InAppRepository repository = InAppInjector.getInstance().getInAppRepository(context);
      ViewCreationMeta meta = new ViewCreationMeta(InAppUtils.getScreenDimension(context),
          InAppUtils.getStatusBarHeight(context));
      CampaignRequest request = new CampaignRequest(repository.localRepository.baseRequest(),
          campaign.campaignMeta.campaignId,
          InAppController.getInstance().getCurrentActivityName(),
          MoEHelper.getInstance(context).getAppContext());
      if (campaign.campaignMeta.templateType.equals(
          InAppConstants.IN_APP_TEMPLATE_TYPE_SELF_HANDLED)) {
        CampaignPayload campaignPayload = repository.fetchSelfHandledPayload(request);
        if (campaignPayload == null) return taskResult;
        InAppController.getInstance().onSelfHandledAvailable(campaignPayload);
        taskResult.setIsSuccess(true);
        return taskResult;
      }
      CampaignPayload campaignPayload =
          repository.fetchCampaignPayload(request, true);
      if (campaignPayload != null) {
        View inAppView = InAppController.getInstance().buildInApp(
            campaignPayload, meta);
        if (inAppView != null) {
          InAppController.getInstance()
              .addInAppToViewHierarchy(InAppController.getInstance().getCurrentActivity(),
                  inAppView, campaignPayload);
          taskResult.setIsSuccess(true);
        }
      }
      Logger.v(TAG + " execute() : Preview creation completed.");
    } catch (Exception e) {
      Logger.e(TAG + " execute() : ", e);
    }
    return taskResult;
  }

  @Override public String getTaskTag() {
    return TAG_PREVIEW_INAPP_TASK;
  }

  @Override public boolean isSynchronous() {
    return true;
  }
}
