package com.moengage.inapp.tasks;

import android.content.Context;
import android.view.View;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.inapp.InAppConstants;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.InAppInjector;
import com.moengage.inapp.InAppUtils;
import com.moengage.inapp.ViewCreationMeta;
import com.moengage.inapp.model.CampaignPayload;
import com.moengage.inapp.model.CampaignRequest;
import com.moengage.inapp.model.NudgeViewResult;
import com.moengage.inapp.model.meta.InAppCampaign;
import com.moengage.inapp.repository.InAppRepository;
import java.util.Map;

/**
 * @author Umang Chamaria
 * Date: 2019-09-24
 */
public class BuildNudgeViewTask extends SDKTask {

  private static final String TAG = InAppConstants.MODULE_TAG + "BuildNudgeViewTask";

  private String requestId;

  public BuildNudgeViewTask(Context context, String requestId) {
    super(context);
    this.requestId = requestId;
  }

  @Override public TaskResult execute() {
    try {
      Logger.v(TAG + " execute() : Will build nudge if available");
      InAppController controller = InAppController.getInstance();
      if (!controller.isInAppSynced()) {
        Logger.v(TAG + " execute() : Cannot show nudge. Api Sync is pending.");
        return taskResult;
      }
      if (!controller.isModuleEnabled(context)) {
        Logger.v(TAG + " execute() : InApp Module is disabled. Cannot show in-app.");
        return taskResult;
      }
      InAppRepository repository = InAppInjector.getInstance().getInAppRepository(context);
      Map<String, InAppCampaign> campaignMap = repository.localRepository.embeddedCampaign();

      if (campaignMap == null) {
        Logger.v(TAG + " execute() : No nudge campaigns found.");
        return taskResult;
      }

      InAppCampaign suitableInApp = InAppController.getInstance().getEligibleNudgeView(context,
          campaignMap);

      if (suitableInApp == null) {
        Logger.v(TAG + " execute() : No valid campaign found.");
        return taskResult;
      }
      Logger.v(TAG + " execute() : Suitable campaign: " + suitableInApp);

      InAppController.getInstance().addProcessingNudge(suitableInApp.campaignMeta.campaignId);
      CampaignPayload campaignPayload =
          repository.fetchCampaignPayload(
              new CampaignRequest(repository.localRepository.baseRequest(),
                  suitableInApp.campaignMeta.campaignId,
                  controller.getCurrentActivityName(),
                  MoEHelper.getInstance(context).getAppContext()),
              suitableInApp.campaignMeta.deliveryControl.persistent);
      if (campaignPayload == null) {
        InAppController.getInstance().removeProcessingNudge(suitableInApp.campaignMeta.campaignId);
        return taskResult;
      }
      View view = controller
          .buildInApp(campaignPayload,
              new ViewCreationMeta(InAppUtils.getScreenDimension(context),
                  InAppUtils.getStatusBarHeight(context)));
      if (view == null) {
        InAppController.getInstance().removeProcessingNudge(suitableInApp.campaignMeta.campaignId);
        return taskResult;
      }
      taskResult.setIsSuccess(true);
      taskResult.setPayload(new NudgeViewResult(requestId, campaignPayload, view));

      Logger.v(TAG + " execute() : Nudge creation complete");
    } catch (Exception e) {
      Logger.e(TAG + " execute() : ", e);
    }
    return taskResult;
  }

  @Override public String getTaskTag() {
    return TAG_BUILD_NUDGE_VIEW_TASK;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}
