package com.moengage.inapp.repository.remote;

import com.moengage.inapp.model.CampaignRequest;
import com.moengage.inapp.model.InAppCampaignResponse;
import com.moengage.inapp.model.InAppMetaRequest;
import com.moengage.inapp.model.InAppMetaResponse;
import com.moengage.inapp.model.StatsUploadRequest;
import com.moengage.inapp.model.StatsUploadResponse;
import com.moengage.inapp.model.TestCampaignResponse;

/**
 * @author Umang Chamaria
 * Date: 2019-05-02
 */
public class RemoteRepository {

  private ApiManager apiManager;
  private ResponseParser responseParser;

  public RemoteRepository(){
    apiManager = new ApiManager();
    responseParser = new ResponseParser();
  }

  public InAppMetaResponse fetchCampaignMeta(InAppMetaRequest inAppMetaRequest){
    return responseParser.parseSyncResponse(apiManager.fetchCampaignMeta(inAppMetaRequest));
  }

  public InAppCampaignResponse fetchCampaignPayload(CampaignRequest request){
    return responseParser.parseCampaignPayload(apiManager.fetchCampaignPayload(request));
  }

  public TestCampaignResponse fetchTestCampaign(CampaignRequest request){
    return responseParser.parseTestCampaignResponse(apiManager.fetchTestCampaign(request));
  }

  public InAppCampaignResponse fetchSelfHandledCampaign(CampaignRequest request){
    return responseParser.selfHandledCampaignFromResponse(apiManager.fetchCampaignPayload(request));
  }

  public StatsUploadResponse uploadStats(StatsUploadRequest request){
    return responseParser.statsUploadResponse(apiManager.uploadStats(request));
  }

}
