package com.moengage.inapp.repository.remote;

import android.content.Context;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.inapp.InAppConstants;
import com.moengage.inapp.InAppController;
import com.moengage.inapp.InAppEvaluator;
import com.moengage.inapp.InAppInjector;
import com.moengage.inapp.repository.InAppRepository;

/**
 * @author Umang Chamaria
 * Date: 2019-05-03
 */
public class FetchMetaTask extends SDKTask {

  private static final String TAG = InAppConstants.MODULE_TAG + "FetchMetaTask";

  public FetchMetaTask(Context context) {
    super(context);
  }

  @Override public TaskResult execute() {
    try {
      Logger.v(TAG + " execute() : Fetching InApp Meta");

      InAppEvaluator evaluator = new InAppEvaluator();
      InAppRepository repository = InAppInjector.getInstance().getInAppRepository(context);
      InAppController controller = InAppController.getInstance();

      if (!evaluator.isServerSyncRequired(repository.localRepository.getLastSyncTime(),
          MoEUtils.currentSeconds(),
          repository.localRepository.getApiSyncInterval(), controller.isInAppSynced())) {
        Logger.e(TAG
            + " execute() : Serve sync not required. Next Sync will happen at: "
            + MoEUtils.isoStringFromSeconds(repository.localRepository.getLastSyncTime()));
        return taskResult;
      }

      boolean response = repository.fetchInAppCampaignMeta();
      if (response) {
        repository.localRepository.deleteExpiredCampaigns();
        repository.updateCache();
        controller.onSyncSuccess(context);
        for (Event event : controller.getPendingTriggerEvents()) {
          controller.tryToShowTriggerInAppIfPossible(context, event);
        }
      }
      controller.clearPendingEvents();
      taskResult.setIsSuccess(response);
      Logger.v(TAG + " execute() : Task Complete");
    } catch (Exception e) {
      Logger.e(TAG + " execute() : Exception ", e);
    }
    return taskResult;
  }

  @Override public String getTaskTag() {
    return TAG_FETCH_IN_APP_META_TASK;
  }

  @Override public boolean isSynchronous() {
    return true;
  }
}
