package com.moengage.inapp.repository.remote;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEUtils;
import com.moengage.core.rest.Request;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.rest.RequestBuilder.RequestType;
import com.moengage.core.rest.Response;
import com.moengage.core.rest.RestClient;
import com.moengage.core.utils.JsonBuilder;
import com.moengage.core.RestUtils;
import com.moengage.inapp.InAppConstants;
import com.moengage.inapp.model.CampaignRequest;
import com.moengage.inapp.model.InAppMetaRequest;
import com.moengage.inapp.model.StatsUploadRequest;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 * Date: 2019-05-02
 */
class ApiManager {

  private static final String TAG = InAppConstants.MODULE_TAG + "ApiManager";

  @Nullable Response fetchCampaignMeta(InAppMetaRequest requestMeta) {
    try {
      Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder()
          .appendEncodedPath(BASE_PATH)
          .appendEncodedPath(PATH_PARAM_LIVE)
          .appendQueryParameter(QUERY_PARAM_UNIQUE_ID, requestMeta.uniqueId)
          .appendQueryParameter(QUERY_PARAM_SDK_VERSION, String.valueOf(requestMeta.sdkVersion))
          .appendQueryParameter(QUERY_PARAM_OS, requestMeta.platform);
      JSONObject requestBody = new JSONObject();
      requestBody.put(MoEConstants.REQUEST_ATTR_QUERY_PARAMS, requestMeta.defaultParams.build());
      Request request = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestType.POST,
          requestMeta.appId)
          .addBody(requestBody)
          .build();
      RestClient restClient = new RestClient(request);
      return restClient.executeRequest();
    } catch (Exception e) {
      Logger.e(TAG + " fetchCampaignMeta() : Exception: ", e);
    }
    return null;
  }

  @Nullable Response fetchCampaignPayload(CampaignRequest campaignRequest) {
    try {
      Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder()
          .appendEncodedPath(BASE_PATH)
          .appendEncodedPath(PATH_PARAM_LIVE)
          .appendEncodedPath(campaignRequest.campaignId)
          .appendQueryParameter(QUERY_PARAM_UNIQUE_ID, campaignRequest.uniqueId)
          .appendQueryParameter(QUERY_PARAM_SDK_VERSION, String.valueOf(campaignRequest.sdkVersion))
          .appendQueryParameter(QUERY_PARAM_OS, campaignRequest.platform);
      JsonBuilder requestBodyBuilder = new JsonBuilder();

      if (campaignRequest.triggerMeta != null){
        JsonBuilder eventBuilder = new JsonBuilder();
        eventBuilder.putString(EVENT_NAME, campaignRequest.triggerMeta.eventName)
            .putString(TIME, campaignRequest.triggerMeta.timeStamp)
            .putJsonObject(ATTRIBUTES, campaignRequest.triggerMeta.attributes);
        requestBodyBuilder.putJsonObject(TRIGGER_EVENT, eventBuilder.build());
      }

      requestBodyBuilder.putJsonObject(MoEConstants.REQUEST_ATTR_QUERY_PARAMS,
          campaignRequest.defaultParams.build());

      if (!MoEUtils.isEmptyString(campaignRequest.screenName)) {
        requestBodyBuilder.putString(SCREEN_NAME, campaignRequest.screenName);
      }

      if (campaignRequest.contextList
          != null && !campaignRequest.contextList.isEmpty()) {
        JSONArray contextArray = new JSONArray();
        for (String context : campaignRequest.contextList) {
          contextArray.put(context);
        }
        requestBodyBuilder.putJsonArray(CONTEXTS, contextArray);
      }

      Request request = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestType.POST,
          campaignRequest.appId)
          .addBody(requestBodyBuilder.build())
          .build();
      RestClient restClient = new RestClient(request);
      return restClient.executeRequest();
    } catch (Exception e) {
      Logger.e(TAG + " fetchCampaignPayload() : Exception ", e);
    }
    return null;
  }

  @Nullable Response fetchTestCampaign(CampaignRequest campaignRequest) {
    try {
      Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder()
          .appendEncodedPath(BASE_PATH)
          .appendEncodedPath(PATH_PARAM_TEST)
          .appendEncodedPath(campaignRequest.campaignId)
          .appendQueryParameter(QUERY_PARAM_SDK_VERSION, String.valueOf(campaignRequest.sdkVersion))
          .appendQueryParameter(QUERY_PARAM_OS, campaignRequest.platform)
          .appendQueryParameter(QUERY_PARAM_UNIQUE_ID, campaignRequest.uniqueId);
      RequestBuilder requestBuilder =
          RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestType.GET, campaignRequest.appId);
      RestClient restClient = new RestClient(requestBuilder.build());
      return restClient.executeRequest();
    } catch (Exception e) {
      Logger.e(TAG + " fetchTestCampaign() : Exception ", e);
    }
    return null;
  }

  @Nullable Response uploadStats(StatsUploadRequest request) {
    try {
      Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder()
          .appendEncodedPath(BASE_PATH)
          .appendEncodedPath(PATH_PARAM_STATS)
          .appendQueryParameter(QUERY_PARAM_SDK_VERSION, String.valueOf(request.sdkVersion))
          .appendQueryParameter(QUERY_PARAM_OS, request.platform)
          .appendQueryParameter(QUERY_PARAM_UNIQUE_ID, request.uniqueId);
      JSONObject requestBody = new JSONObject();
      requestBody.put(STATS, request.stat.statsJson);
      requestBody.put(MoEConstants.REQUEST_ATTR_QUERY_PARAMS,
          request.defaultParams.build());
      RequestBuilder requestBuilder =
          RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestType.POST,
              request.appId)
          .addBody(requestBody)
          .addHeader(HEADER_KEY, request.stat.requestId);
      RestClient restClient = new RestClient(requestBuilder.build());
      return restClient.executeRequest();
    }catch (Exception e){
      Logger.e( TAG + " uploadStats() : ", e);
    }
    return null;
  }

  private static final String BASE_PATH = "v3/campaigns/inapp/";
  private static final String PATH_PARAM_LIVE = "live";
  private static final String PATH_PARAM_TEST = "test";
  private static final String PATH_PARAM_STATS = "live/stats";
  private static final String QUERY_PARAM_SDK_VERSION = "sdk_ver";
  private static final String QUERY_PARAM_OS = "os";
  private static final String QUERY_PARAM_UNIQUE_ID = "unique_id";
  private static final String HEADER_KEY = "MOE-INAPP-BATCH-ID";

  private static final String TRIGGER_EVENT = "event";
  private static final String EVENT_NAME = "name";
  private static final String TIME = "time";
  private static final String ATTRIBUTES = "attributes";
  private static final String SCREEN_NAME = "screen_name";
  private static final String CONTEXTS = "contexts";
  private static final String STATS = "stats";

}
