package com.moengage.inapp.model.style;

import com.moengage.inapp.model.Background;
import com.moengage.inapp.model.Border;
import com.moengage.inapp.model.Font;

/**
 * @author Umang Chamaria
 * Date: 2019-09-09
 */
public class TextStyle extends InAppStyle {

  public final Font font;
  public final Background background;
  public final Border border;

  public TextStyle(InAppStyle inAppStyle, Font font, Background background,
      Border border) {
    super(inAppStyle);
    this.font = font;
    this.background = background;
    this.border = border;
  }

  @Override public String toString() {
    return "TextStyle{" +
        "font=" + font +
        ", background=" + background +
        ", border=" + border +
        ", height=" + height +
        ", width=" + width +
        ", margin=" + margin +
        ", padding=" + padding +
        ", display=" + display +
        '}';
  }
}
