package com.moengage.inapp.model.style;

import com.moengage.inapp.model.Border;
import com.moengage.inapp.model.Color;

/**
 * @author Umang Chamaria
 * Date: 2019-09-09
 */
public class RatingStyle extends InAppStyle{

  public final Border border;
  public final Color color;
  public final int numberOfStars;
  public final boolean isHalfStepAllowed;
  public final double realHeight;

  public RatingStyle(InAppStyle inAppStyle, Border border, Color color, int numberOfStars,
      boolean isHalfStepAllowed, double realHeight) {
    super(inAppStyle);
    this.border = border;
    this.color = color;
    this.numberOfStars = numberOfStars;
    this.isHalfStepAllowed = isHalfStepAllowed;
    this.realHeight = realHeight;
  }

  @Override public String toString() {
    return "RatingStyle{" +
        "border=" + border +
        ", color=" + color +
        ", numberOfStars=" + numberOfStars +
        ", isHalfStepAllowed=" + isHalfStepAllowed +
        ", realHeight=" + realHeight +
        ", height=" + height +
        ", width=" + width +
        ", margin=" + margin +
        ", padding=" + padding +
        ", display=" + display +
        '}';
  }
}
