package com.moengage.inapp.model.style;

import com.moengage.inapp.model.Animation;
import com.moengage.inapp.model.Background;
import com.moengage.inapp.model.Border;

/**
 * @author Umang Chamaria
 * Date: 2019-09-09
 */
public class ContainerStyle extends InAppStyle {

  public final Border border;
  public final Background background;
  public final Animation animation;

  public ContainerStyle(InAppStyle inAppStyle, Border border,
      Background background, Animation animation) {
    super(inAppStyle);
    this.border = border;
    this.background = background;
    this.animation = animation;
  }

  @Override public String toString() {
    return "ContainerStyle{" +
        "border=" + border +
        ", background=" + background +
        ", animation=" + animation +
        ", height=" + height +
        ", width=" + width +
        ", margin=" + margin +
        ", padding=" + padding +
        ", display=" + display +
        '}';
  }
}
