package com.moengage.inapp.model.style;

import com.moengage.inapp.model.Background;
import com.moengage.inapp.model.Border;
import com.moengage.inapp.model.Font;

/**
 * @author Umang Chamaria
 * Date: 2019-09-09
 */
public class ButtonStyle extends TextStyle {

  public final int minHeight;

  public ButtonStyle(InAppStyle inAppStyle, Font font,
      Background background, Border border,
      int minHeight) {
    super(inAppStyle, font, background, border);
    this.minHeight = minHeight;
  }

  @Override public String toString() {
    return "{\"ButtonStyle\":{"
        + "\"minHeight\":" + minHeight
        + ", \"font\":" + font
        + ", \"background\":" + background
        + ", \"border\":" + border
        + ", \"height\":" + height
        + ", \"width\":" + width
        + ", \"margin\":" + margin
        + ", \"padding\":" + padding
        + ", \"display\":" + display
        + "}}";
  }
}
