package com.moengage.inapp.model.meta;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 * Date: 2019-08-27
 */
public class TriggerCondition {

  private static final String TAG = "TriggerCondition";
  /**
   * Trigger Event name
   */
  @NonNull public final String eventName;
  /**
   * Attribute conditions.
   */
  @Nullable public final JSONObject attributes;

  public TriggerCondition(@NonNull String eventName, @Nullable JSONObject attributes) {
    this.eventName = eventName;
    this.attributes = attributes;
  }

  public static TriggerCondition fromJson(JSONObject triggerJson) throws JSONException {
      return new TriggerCondition(
          triggerJson.getString(ACTION_NAME),
          triggerJson.optJSONObject(ATTRIBUTES)
      );
  }

  public static JSONObject toJson(TriggerCondition trigger) {
    try {
      JSONObject triggerJson = new JSONObject();
      triggerJson.put(ACTION_NAME, trigger.eventName);
      if (trigger.attributes != null) {
        triggerJson.put(ATTRIBUTES, trigger.attributes);
      } else {
        triggerJson.put(ATTRIBUTES, new JSONObject());
      }
      return triggerJson;
    } catch (Exception e) {
      Logger.e(TAG + " toJson() : Exception ", e);
    }
    return null;
  }

  private static final String ACTION_NAME = "action_name";
  private static final String ATTRIBUTES = "attributes";

  @Override public String toString() {
    try {
      JSONObject jsonObject = toJson(this);
      if (jsonObject != null){
        return jsonObject.toString(4);
      }
    } catch (JSONException e) {

    }
    return super.toString();
  }
}
