package com.moengage.inapp.model.meta;

import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
public class Trigger {

  private static final String TAG = "Trigger";
  /**
   * Primary condition for trigger action.
   */
  public final TriggerCondition primaryCondition;

  public Trigger(TriggerCondition primaryCondition) {
    this.primaryCondition = primaryCondition;
  }

  @Nullable public static Trigger fromJson(@Nullable JSONObject triggerJson) throws JSONException {
    if (triggerJson == null) return null;
    if (triggerJson.has(PRIMARY_CONDITION) && triggerJson.getJSONObject(PRIMARY_CONDITION)
        .has(ACTION_NAME) && !MoEUtils.isEmptyString(
        triggerJson.getJSONObject(PRIMARY_CONDITION).getString(ACTION_NAME))) {
      return new Trigger(TriggerCondition.fromJson(triggerJson.getJSONObject(PRIMARY_CONDITION)));
    } else {
      return null;
    }
  }

  @Nullable public static JSONObject toJson(@Nullable Trigger trigger){
    try {
      if (trigger == null) return null;
      JSONObject triggerJson = new JSONObject();
      JSONObject primaryCondition = TriggerCondition.toJson(trigger.primaryCondition);
      triggerJson.put(PRIMARY_CONDITION, primaryCondition);
      return triggerJson;
    } catch (Exception e) {
      Logger.e( TAG + " toJson() : Exception ", e);
    }
    return null;
  }

  private static final String PRIMARY_CONDITION = "primary_condition";
  private static final String ACTION_NAME = "action_name";

  @Override public String toString() {
    try {
      JSONObject jsonObject = toJson(this);
      if (jsonObject != null) {
        return jsonObject.toString(4);
      }
    } catch (JSONException e) {

    }
    return super.toString();
  }
}
