/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.inapp.model.meta;

import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.utils.ApiUtility;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Rules {

  private static final String TAG = "Rules";
  /**
   * Screen name on which the campaign should be shown.
   */
  @Nullable public final String screenName;
  /**
   * Context for which the campaign should be shown.
   */
  @Nullable public final Set<String> context;

  public Rules(@Nullable String screenName, @Nullable Set<String> context) {
    this.screenName = screenName;
    this.context = context;
  }

  public static Rules fromJson(@Nullable JSONObject rulesJson) {
    if (rulesJson == null) return new Rules(null, null);
    return new Rules(
        rulesJson.optString(SCREEN_NAME, null),
        ApiUtility.jsonArrayToStringSet(rulesJson.optJSONArray(CONTEXTS))
    );
  }

  public static JSONObject toJson(Rules rules) {
    try {
      JSONObject rulesJson = new JSONObject();
      if (!MoEUtils.isEmptyString(rules.screenName)) {
        rulesJson.put(SCREEN_NAME, rules.screenName);
      }
      if (rules.context != null && !rules.context.isEmpty()) {
        JSONArray contextArray = new JSONArray();
        Iterator<String> iterator = rules.context.iterator();
        while (iterator.hasNext()) {
          contextArray.put(iterator.next());
        }
        rulesJson.put(CONTEXTS, contextArray);
      }
      return rulesJson;
    } catch (Exception e) {
      Logger.e(TAG + " toJson() : ", e);
    }
    return null;
  }

  @Override public String toString() {
    try {
      JSONObject jsonObject = toJson(this);
      if (jsonObject != null) {
        return jsonObject.toString(4);
      }
    } catch (JSONException e) {

    }
    return super.toString();
  }

  private static final String SCREEN_NAME = "screen_name";
  private static final String CONTEXTS = "contexts";

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    Rules rules = (Rules) o;

    if (screenName != null ? !screenName.equals(rules.screenName) : rules.screenName != null) {
      return false;
    }
    return context != null ? context.equals(rules.context) : rules.context == null;
  }

}