package com.moengage.inapp.model.meta;

/**
 * InApp Campaigns meta object. Contains campaign type, campaign meta data, current state, etc.
 *
 * @author Umang Chamaria
 */
public class InAppCampaign {

  /**
   * Database id for the campaign.
   */
  public long _id = -1;
  /**
   * Type of campaign trigger based or general.
   */
  public final String campaignType;
  /**
   * Whether campaign is active or not for a given user.
   */
  public String status;
  /**
   * Time after which campaign can be deleted.
   */
  public final long deletionTime;
  /**
   * Last time campaign was received in the api response.
   */
  public final long lastReceivedTime;
  /**
   * Meta data for the campaign contains rules and delivery control params.
   */
  public final CampaignMeta campaignMeta;
  /**
   * Current state of the campaign, parameters which directly effect the delivery.
   */
  public CampaignState campaignState;

  @Override public String toString() {
    return "{\n" +
        "\"_id\": " + _id + ",\n" +
        " \"campaignType\": \"" + campaignType + "\" ,\n" +
        " \"status\": \"" + status + "\" ,\n" +
        " \"deletionTime\": " + deletionTime + ",\n" +
        " \"lastReceivedTime\": " + lastReceivedTime + ",\n" +
        " \"campaignMeta\": " + campaignMeta + ",\n" +
        " \"campaignState\": " + campaignState + ",\n" +
        '}';
  }

  public InAppCampaign(long _id, String campaignType, String status, long deletionTime,
      long lastReceivedTime, CampaignMeta campaignMeta,
      CampaignState campaignState) {
    this._id = _id;
    this.campaignType = campaignType;
    this.status = status;
    this.deletionTime = deletionTime;
    this.lastReceivedTime = lastReceivedTime;
    this.campaignMeta = campaignMeta;
    this.campaignState = campaignState;
  }

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    InAppCampaign that = (InAppCampaign) o;

    if (deletionTime != that.deletionTime) return false;
    if (lastReceivedTime != that.lastReceivedTime) return false;
    if (!campaignType.equals(that.campaignType)) return false;
    if (!status.equals(that.status)) return false;
    if (!campaignMeta.equals(that.campaignMeta)) return false;
    return campaignState.equals(that.campaignState);
  }
}
