package com.moengage.inapp.model.meta;

import com.moengage.core.Logger;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Controls the frequency at which the campaign is shown.
 */
public class FrequencyCapping {

  private static final String TAG = "FrequencyCapping";

  /**
   * Whether campaign should obey global delay or not.
   */
  public final boolean ignoreGlobalDelay;
  /**
   * Maximum times campaign should be shown.
   */
  public final long maxCount;
  /**
   * Minimum delay before which campaign should not be shown again.
   */
  public final long minimumDelay;

  public FrequencyCapping(boolean ignoreGlobalDelay, long maxCount, long minimumDelay) {
    this.ignoreGlobalDelay = ignoreGlobalDelay;
    this.maxCount = maxCount;
    this.minimumDelay = minimumDelay;
  }

  @Override public String toString() {
    try {
      JSONObject jsonObject = toJson(this);
      if (jsonObject != null) {
        return jsonObject.toString(4);
      }
    } catch (JSONException e) {

    }
    return super.toString();
  }

  public static FrequencyCapping fromJson(JSONObject frequencyJson) throws JSONException {
    return new FrequencyCapping(
        frequencyJson.getBoolean(IGNORE_GLOBAL_DELAY),
        frequencyJson.getLong(MAX_COUNT),
        frequencyJson.getLong(MINIMUM_DELAY)
    );
  }

  public static JSONObject toJson(FrequencyCapping frequencyCapping){
    try {
      JSONObject frequencyJson = new JSONObject();
      frequencyJson.put(IGNORE_GLOBAL_DELAY, frequencyCapping.ignoreGlobalDelay)
          .put(MAX_COUNT, frequencyCapping.maxCount)
          .put(MINIMUM_DELAY, frequencyCapping.minimumDelay);
      return frequencyJson;
    }catch (Exception e){
      Logger.e( TAG + " toJson() : ", e);
    }
    return null;
  }

  private static final String IGNORE_GLOBAL_DELAY = "ignore_global_delay";
  private static final String MAX_COUNT = "count";
  private static final String MINIMUM_DELAY = "delay";

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    FrequencyCapping that = (FrequencyCapping) o;

    if (ignoreGlobalDelay != that.ignoreGlobalDelay) return false;
    if (maxCount != that.maxCount) return false;
    return minimumDelay == that.minimumDelay;
  }
}