package com.moengage.inapp.model.meta;

import com.moengage.core.Logger;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 * Date: 2019-07-25
 */
public class DisplayControl {

  private static final String TAG = "DisplayControl";

  public final Rules rules;

  public DisplayControl(Rules rules) {
    this.rules = rules;
  }

  public static DisplayControl fromJson(JSONObject displayJson) throws JSONException{
    if (displayJson == null) return new DisplayControl(new Rules(null, null));
    return new DisplayControl(
        Rules.fromJson(displayJson.optJSONObject(RULES))
    );
  }

  public static JSONObject toJson(DisplayControl displayControl){
    try {
      JSONObject displayJson = new JSONObject();
      displayJson.put(RULES, Rules.toJson(displayControl.rules));
      return displayJson;
    }catch (Exception e){
      Logger.e( TAG + " toJson() : Exception ", e);
    }
    return null;
  }

  @Override public String toString() {
    return "DisplayControl{" +
        "rules=" + rules +
        '}';
  }

  private static final String RULES = "rules";

  @Override public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    DisplayControl that = (DisplayControl) o;

    return rules != null ? rules.equals(that.rules) : that.rules == null;
  }

}
